/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.skilltree;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yesman.epicskills.util.JsonUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.skill.Skill;

public record SkillTreeEntry(List<Node> nodes, int workPriority) {
    public static final Codec<Vec2i> VEC2_INT_CODEC = Codec.INT.listOf().comapFlatMap(instance -> Util.m_143795_((List)instance, (int)2).map(result -> new Vec2i(((Integer)result.get(0)).intValue(), ((Integer)result.get(1)).intValue())), vec2 -> List.of(Integer.valueOf(vec2.x), Integer.valueOf(vec2.y)));
    public static final ResourceKey<Registry<SkillTreeEntry>> SKILL_TREE_ENTRY_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"entry"));
    public static final Codec<SkillTreeEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Node.CODEC.listOf().optionalFieldOf("nodes").forGetter(skillTreeEntry -> Optional.ofNullable(skillTreeEntry.nodes())), (App)Codec.INT.optionalFieldOf("priority").forGetter(skillTreeEntry -> Optional.of(skillTreeEntry.workPriority()))).apply((Applicative)instance, (nodes, workPriorityOpt) -> new SkillTreeEntry(nodes.orElse(List.of()), workPriorityOpt.orElse(0))));

    public static int comparator(SkillTreeEntry e1, SkillTreeEntry e2) {
        return Integer.compare(e2.workPriority(), e1.workPriority());
    }

    public record Node(Skill skill, @Nullable List<ParentLink> parents, @Nullable EntityPredicate unlockCondition, boolean hasCustomUnlockCondition, @Nullable Component unlockTip, int requiredAbilityPoints, Vec2i positionInScreen, boolean hidden, @Nullable ResourceLocation importFrom) {
        public static final Codec<Node> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SkillManager.CODEC.fieldOf("skill").forGetter(Node::skill), (App)ParentLink.CODEC.listOf().optionalFieldOf("parents").forGetter(node -> Optional.ofNullable(node.parents())), (App)ExtraCodecs.f_252400_.optionalFieldOf("conditions").forGetter(node -> {
            JsonElement serialized = node.unlockCondition() == null ? null : JsonUtil.removeNullElements(node.unlockCondition().m_36606_());
            return Optional.ofNullable(serialized);
        }), (App)Codec.BOOL.optionalFieldOf("custom_condition").forGetter(node -> Optional.ofNullable(node.hasCustomUnlockCondition())), (App)Codec.STRING.optionalFieldOf("unlock_tip").forGetter(node -> node.unlockTip() == null ? Optional.empty() : Optional.of(((TranslatableContents)((MutableComponent)node.unlockTip()).m_214077_()).m_237508_())), (App)Codec.INT.optionalFieldOf("ability_points").forGetter(node -> Optional.ofNullable(node.requiredAbilityPoints())), (App)VEC2_INT_CODEC.fieldOf("position_in_screen").forGetter(Node::positionInScreen), (App)Codec.BOOL.optionalFieldOf("hidden").forGetter(node -> Optional.ofNullable(node.hidden())), (App)ResourceLocation.f_135803_.optionalFieldOf("import").forGetter(node -> Optional.ofNullable(node.importFrom()))).apply((Applicative)instance, (skill, parentOpt, conditions, hasCustomCondition, unlockTip, requiredAbilityPoints, positionInScreen, hiddenOpt, importFromOpt) -> {
            JsonElement entityPredicatesJson = conditions.orElse(null);
            EntityPredicate entityPredicates = entityPredicatesJson == null ? null : EntityPredicate.m_36614_((JsonElement)entityPredicatesJson);
            return new Node((Skill)skill, parentOpt.orElse(null), entityPredicates, hasCustomCondition.orElse(false), (Component)(unlockTip.isPresent() ? Component.m_237115_((String)((String)unlockTip.get())) : null), requiredAbilityPoints.orElse(0), (Vec2i)positionInScreen, hiddenOpt.orElse(false), importFromOpt.orElse(null));
        }));

        public boolean is(Skill skill) {
            return this.skill.equals(skill);
        }

        public boolean noUnlockConditions() {
            return this.unlockCondition == null && !this.hasCustomUnlockCondition;
        }
    }

    public record ParentLink(Skill parentSkill, @Nullable List<Vec2i> controlPoints) {
        public static final Codec<ParentLink> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SkillManager.CODEC.fieldOf("skill").forGetter(ParentLink::parentSkill), (App)VEC2_INT_CODEC.listOf().optionalFieldOf("control_points").forGetter(object -> Optional.ofNullable(object.controlPoints()))).apply((Applicative)instance, (skill, controlPointsOpt) -> new ParentLink((Skill)skill, controlPointsOpt.orElse(null))));
    }
}

