/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.skilltree;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yesman.epicskills.util.JsonUtil;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;

public record SkillTree(Vec3i menuBarColor, @Nullable EntityPredicate conditions, @Nullable Component unlockTip, boolean locked, boolean hiddenWhenLocked, boolean disabled, int priority) {
    public static final ResourceKey<Registry<SkillTree>> SKILL_TREE_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"epicskills", (String)"tree"));
    public static final Codec<SkillTree> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec3i.f_123287_.optionalFieldOf("menu_color").forGetter(skilltree -> Optional.ofNullable(skilltree.menuBarColor())), (App)ExtraCodecs.f_252400_.optionalFieldOf("conditions").forGetter(skilltree -> {
        JsonElement serialized = skilltree.conditions() == null ? null : JsonUtil.removeNullElements(skilltree.conditions().m_36606_());
        return Optional.ofNullable(serialized);
    }), (App)Codec.STRING.optionalFieldOf("unlock_tip").forGetter(node -> node.unlockTip() == null ? Optional.empty() : Optional.of(((TranslatableContents)((MutableComponent)node.unlockTip()).m_214077_()).m_237508_())), (App)Codec.BOOL.optionalFieldOf("locked").forGetter(skilltree -> Optional.ofNullable(skilltree.locked())), (App)Codec.BOOL.optionalFieldOf("hidden").forGetter(skilltree -> Optional.ofNullable(skilltree.hiddenWhenLocked())), (App)Codec.BOOL.optionalFieldOf("disabled").forGetter(skilltree -> Optional.ofNullable(skilltree.disabled())), (App)Codec.INT.optionalFieldOf("priority").forGetter(skilltree -> Optional.ofNullable(skilltree.priority()))).apply((Applicative)instance, (menuBarColorOpt, conditions, unlockTip, lockedOpt, hiddenWhenLockedOpt, disabledOpt, priorityOpt) -> {
        JsonElement entityPredicatesJson = conditions.orElse(null);
        EntityPredicate entityPredicates = entityPredicatesJson == null ? null : EntityPredicate.m_36614_((JsonElement)entityPredicatesJson);
        return new SkillTree(menuBarColorOpt.orElse(new Vec3i(255, 255, 255)), entityPredicates, (Component)(unlockTip.isPresent() ? Component.m_237115_((String)((String)unlockTip.get())) : null), lockedOpt.orElse(false), hiddenWhenLockedOpt.orElse(false), disabledOpt.orElse(false), priorityOpt.orElse(100));
    }));

    public static String toDescriptionId(ResourceKey<SkillTree> resourceKey) {
        return String.format("skill_tree.%s.%s", resourceKey.m_135782_().m_135827_(), resourceKey.m_135782_().m_135815_());
    }

    public boolean noUnlcokConditions() {
        return this.conditions() == null;
    }
}

