/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.network.client;

import com.yesman.epicskills.network.NetworkManager;
import com.yesman.epicskills.skilltree.SkillTree;
import com.yesman.epicskills.world.capability.SkillTreeProgression;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.skill.Skill;

public record ClientBoundUnlockNode(ResourceKey<SkillTree> skillTree, Skill skill, SkillTreeProgression.NodeState nodeState, boolean unlockAlarm, boolean unequip, boolean askChange, boolean closeScreen) {
    public static ClientBoundUnlockNode fromBytes(FriendlyByteBuf buf) {
        return new ClientBoundUnlockNode((ResourceKey<SkillTree>)buf.m_236801_(SkillTree.SKILL_TREE_REGISTRY_KEY), (Skill)buf.readRegistryId(), (SkillTreeProgression.NodeState)buf.m_130066_(SkillTreeProgression.NodeState.class), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    public static void toBytes(ClientBoundUnlockNode msg, FriendlyByteBuf buf) {
        buf.m_236858_(msg.skillTree());
        buf.writeRegistryId((IForgeRegistry)RegistryManager.ACTIVE.getRegistry(SkillManager.SKILL_REGISTRY_KEY), (Object)msg.skill());
        buf.m_130068_((Enum)msg.nodeState());
        buf.writeBoolean(msg.unlockAlarm());
        buf.writeBoolean(msg.unequip());
        buf.writeBoolean(msg.askChange());
        buf.writeBoolean(msg.closeScreen());
    }

    public static void handle(ClientBoundUnlockNode msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> NetworkManager.getPlayerInClient().getCapability(SkillTreeProgression.SKILL_TREE_PROGRESSION).ifPresent(skilltreeProgression -> skilltreeProgression.processSyncPacket(msg)));
        ctx.get().setPacketHandled(true);
    }
}

