/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicskills.compat.controlify;

import com.yesman.epicskills.EpicSkills;
import com.yesman.epicskills.client.gui.screen.SkillInfoScreen;
import com.yesman.epicskills.client.gui.screen.SkillTreeScreen;
import com.yesman.epicskills.client.input.EpicSkillsKeyMappings;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBindingBuilder;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ControlifyCompat
implements ControlifyEntrypoint {
    private static InputBindingSupplier openSkillTreeScreen;
    private static InputBindingSupplier moveSkillTreeUp;
    private static InputBindingSupplier moveSkillTreeDown;
    private static InputBindingSupplier moveSkillTreeLeft;
    private static InputBindingSupplier moveSkillTreeRight;
    private static InputBindingSupplier scaleSkillTreeUp;
    private static InputBindingSupplier scaleSkillTreeDown;
    private static InputBindingSupplier navigateSkillTreeNext;
    private static InputBindingSupplier navigateSkillTreePrev;
    private static InputBindingSupplier openSkillEditor;
    private static InputBindingSupplier convertXpToAbilityPoint;

    public void onControllersDiscovered(ControlifyApi controlify) {
    }

    public void onControlifyInit(InitContext context) {
    }

    public void onControlifyPreInit(PreInitContext context) {
        ControlifyBindApi registrar = ControlifyBindApi.get();
        ControlifyCompat.registerCustomRadialIcons();
        registrar.registerBindContext(EpicSkillsBindContext.IN_SKILL_TREE);
        ControlifyCompat.registerInputBindings(registrar);
        ControlifyCompat.registerScreenProcessors();
    }

    private static void registerCustomRadialIcons() {
        for (EpicSkillsRadialIcons icon : EpicSkillsRadialIcons.values()) {
            ResourceLocation location = icon.getId();
            RadialIcons.registerIcon((ResourceLocation)location, (graphics, x, y, tickDelta) -> {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                Blit.blitTex((GuiGraphics)graphics, (ResourceLocation)location, (int)0, (int)0, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                graphics.m_280168_().m_85849_();
            });
        }
    }

    private static void registerInputBindings(ControlifyBindApi registrar) {
        MutableComponent guiCategory = Component.m_237115_((String)"key.epicfight.gui");
        openSkillTreeScreen = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$1((Component)guiCategory, arg_0));
        moveSkillTreeUp = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$2((Component)guiCategory, arg_0));
        moveSkillTreeDown = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$3((Component)guiCategory, arg_0));
        moveSkillTreeLeft = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$4((Component)guiCategory, arg_0));
        moveSkillTreeRight = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$5((Component)guiCategory, arg_0));
        scaleSkillTreeUp = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$6((Component)guiCategory, arg_0));
        scaleSkillTreeDown = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$7((Component)guiCategory, arg_0));
        navigateSkillTreeNext = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$8((Component)guiCategory, arg_0));
        navigateSkillTreePrev = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$9((Component)guiCategory, arg_0));
        openSkillEditor = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$10((Component)guiCategory, arg_0));
        convertXpToAbilityPoint = registrar.registerBinding(arg_0 -> ControlifyCompat.lambda$registerInputBindings$11((Component)guiCategory, arg_0));
    }

    private static void registerScreenProcessors() {
        ScreenProcessorProvider.registerProvider(SkillTreeScreen.class, SkillTreeScreenProcessor::new);
        ScreenProcessorProvider.registerProvider(SkillInfoScreen.class, SkillInfoScreenProcessor::new);
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$11(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("convert_xp_to_ability_point")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.convert_xp_to_ability_point")).description((Component)Component.m_237115_((String)"controller.epicskills.convert_xp_to_ability_point.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$10(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("open_skill_editor")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.open_skill_editor")).description((Component)Component.m_237115_((String)"controller.epicskills.open_skill_editor.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$9(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("navigate_skill_tree_prev")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.navigate_skill_tree_prev")).description((Component)Component.m_237115_((String)"controller.epicskills.navigate_skill_tree_prev.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$8(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("navigate_skill_tree_next")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.navigate_skill_tree_next")).description((Component)Component.m_237115_((String)"controller.epicskills.navigate_skill_tree_next.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$7(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("scale_skill_tree_down")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.scale_skill_tree_down")).description((Component)Component.m_237115_((String)"controller.epicskills.scale_skill_tree_down.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$6(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("scale_skill_tree_up")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.scale_skill_tree_up")).description((Component)Component.m_237115_((String)"controller.epicskills.scale_skill_tree_up.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$5(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("move_skill_tree_right")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.move_skill_tree_right")).description((Component)Component.m_237115_((String)"controller.epicskills.move_skill_tree_right.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$4(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("move_skill_tree_left")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.move_skill_tree_left")).description((Component)Component.m_237115_((String)"controller.epicskills.move_skill_tree_left.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$3(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("move_skill_tree_down")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.move_skill_tree_down")).description((Component)Component.m_237115_((String)"controller.epicskills.move_skill_tree_down.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$2(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("move_skill_tree_up")).category(guiCategory).allowedContexts(new BindContext[]{EpicSkillsBindContext.IN_SKILL_TREE}).name((Component)Component.m_237115_((String)"controller.epicskills.move_skill_tree_up")).description((Component)Component.m_237115_((String)"controller.epicskills.move_skill_tree_up.description"));
    }

    private static /* synthetic */ InputBindingBuilder lambda$registerInputBindings$1(Component guiCategory, InputBindingBuilder builder) {
        return builder.id(EpicSkills.rl("attack")).category(guiCategory).allowedContexts(new BindContext[]{BindContext.IN_GAME}).name((Component)Component.m_237115_((String)"key.epicskills.open_skill_tree")).description((Component)Component.m_237115_((String)"key.epicskills.open_skill_tree.description")).addKeyCorrelation(EpicSkillsKeyMappings.OPEN_SKILL_TREE).keyEmulation(EpicSkillsKeyMappings.OPEN_SKILL_TREE).radialCandidate(EpicSkillsRadialIcons.ABILITY_STONE.getId());
    }

    private static class EpicSkillsBindContext {
        private static final BindContext IN_SKILL_TREE = new BindContext(EpicSkills.rl("in_skill_tree"), mc -> mc.f_91080_ instanceof SkillTreeScreen);

        private EpicSkillsBindContext() {
        }
    }

    private static enum EpicSkillsRadialIcons {
        ABILITY_STONE(EpicSkills.rl("textures/item/ability_stone.png"));

        @NotNull
        private final ResourceLocation id;

        private EpicSkillsRadialIcons(ResourceLocation id) {
            this.id = id;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }
    }

    private static class SkillInfoScreenProcessor
    extends ScreenProcessor<SkillInfoScreen> {
        private static final InputBindingSupplier ACTION = ControlifyBindings.GUI_PRESS;

        public SkillInfoScreenProcessor(SkillInfoScreen screen) {
            super((Screen)screen);
        }

        protected void handleButtons(ControllerEntity controller) {
            if (ACTION.on(controller).guiPressed().get()) {
                ((SkillInfoScreen)this.screen).getActionButton().m_5691_();
                SkillInfoScreenProcessor.playClackSound();
            }
            super.handleButtons(controller);
        }

        protected void setInitialFocus() {
        }

        protected void handleComponentNavigation(ControllerEntity controller) {
        }

        public void onWidgetRebuild() {
            super.onWidgetRebuild();
            ButtonGuideApi.addGuideToButton((Object)((SkillInfoScreen)this.screen).getActionButton(), (InputBindingSupplier)ACTION, (ButtonGuidePredicate)ButtonGuidePredicate.always());
        }
    }

    private static class SkillTreeScreenProcessor
    extends ScreenProcessor<SkillTreeScreen> {
        public SkillTreeScreenProcessor(SkillTreeScreen screen) {
            super((Screen)screen);
        }

        public void onControllerUpdate(ControllerEntity controller) {
            super.onControllerUpdate(controller);
            this.updateDisableMouseDragging(ControlifyApi.get().currentInputMode());
        }

        public VirtualMouseBehaviour virtualMouseBehaviour() {
            return VirtualMouseBehaviour.ENABLED;
        }

        public void onInputModeChanged(InputMode mode) {
            super.onInputModeChanged(mode);
            this.updateDisableMouseDragging(mode);
        }

        private void updateDisableMouseDragging(InputMode mode) {
            ((SkillTreeScreen)this.screen).setDisableMouseDragging(mode.isController());
        }

        protected void handleScreenVMouse(ControllerEntity controller, VirtualMouseHandler vmouse) {
            super.handleScreenVMouse(controller, vmouse);
            this.handleViewportMove(controller, vmouse);
            this.handleViewportScale(controller);
            this.handleTreeNavigation(controller);
            this.handleOtherActions(controller);
        }

        private void handleViewportMove(@NotNull ControllerEntity controller, @NotNull VirtualMouseHandler vmouse) {
            vmouse.preventScrollingThisTick();
            float up = moveSkillTreeUp.on(controller).analogueNow();
            float down = moveSkillTreeDown.on(controller).analogueNow();
            float right = moveSkillTreeRight.on(controller).analogueNow();
            float left = moveSkillTreeLeft.on(controller).analogueNow();
            float horizontal = right - left;
            float vertical = up - down;
            float deadZone = 0.1f;
            if (Math.abs(horizontal) < 0.1f) {
                horizontal = 0.0f;
            }
            if (Math.abs(vertical) < 0.1f) {
                vertical = 0.0f;
            }
            float sensitivity = 10.0f;
            float deltaX = horizontal * 10.0f;
            float deltaY = vertical * 10.0f;
            ((SkillTreeScreen)this.screen).moveViewport(deltaX * -1.0f, deltaY);
        }

        private void handleViewportScale(@NotNull ControllerEntity controller) {
            boolean isUp = this.isPressed(scaleSkillTreeUp, controller);
            boolean isDown = this.isPressed(scaleSkillTreeDown, controller);
            if (isUp || isDown) {
                if (isUp) {
                    ((SkillTreeScreen)this.screen).scaleUp();
                } else {
                    ((SkillTreeScreen)this.screen).scaleDown();
                }
                SkillTreeScreenProcessor.playClackSound();
            }
        }

        private void handleTreeNavigation(@NotNull ControllerEntity controller) {
            boolean navigated;
            boolean isNext = this.isPressed(navigateSkillTreeNext, controller);
            boolean isPrev = this.isPressed(navigateSkillTreePrev, controller);
            if ((isNext || isPrev) && (navigated = ((SkillTreeScreen)this.screen).navigateTreePage(isNext))) {
                SkillTreeScreen.playSkillTreeDownSound(Minecraft.m_91087_().m_91106_());
            }
        }

        private void handleOtherActions(@NotNull ControllerEntity controller) {
            if (this.isPressed(openSkillEditor, controller)) {
                ((SkillTreeScreen)this.screen).openSkillEditorScreen();
                SkillTreeScreenProcessor.playClackSound();
            } else if (this.isPressed(convertXpToAbilityPoint, controller)) {
                ((SkillTreeScreen)this.screen).getExpConversionButton().convert();
            }
        }

        private boolean isPressed(@NotNull InputBindingSupplier binding, @NotNull ControllerEntity controller) {
            return binding.on(controller).guiPressed().get();
        }
    }
}

