/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSetAttackTarget;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public abstract class MobPatch<T extends Mob>
extends LivingEntityPatch<T> {
    protected final Faction mobFaction;

    public MobPatch() {
        this.mobFaction = Factions.NEUTRAL;
    }

    public MobPatch(Faction faction) {
        this.mobFaction = faction;
    }

    @Override
    public void onJoinWorld(T entity, EntityJoinLevelEvent event) {
        super.onJoinWorld(entity, event);
        if (!entity.m_9236_().m_5776_() && !((Mob)this.original).m_21525_()) {
            this.initAI();
        }
    }

    protected void initAI() {
        if (((Mob)this.original).m_6274_().f_21845_.isEmpty()) {
            HashSet toRemove = Sets.newHashSet();
            this.selectGoalToRemove(toRemove);
            toRemove.forEach(arg_0 -> ((GoalSelector)((Mob)this.original).f_21345_).m_25363_(arg_0));
        }
    }

    protected void selectGoalToRemove(Set<Goal> toRemove) {
        for (WrappedGoal wrappedGoal : ((Mob)this.original).f_21345_.m_148105_()) {
            Goal goal = wrappedGoal.m_26015_();
            if (!(goal instanceof MeleeAttackGoal) && !(goal instanceof AnimatedAttackGoal) && !(goal instanceof RangedAttackGoal) && !(goal instanceof TargetChasingGoal)) continue;
            toRemove.add(goal);
        }
    }

    protected final void commonMobUpdateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((Mob)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.INACTION : (((Mob)this.original).m_20202_() != null ? LivingMotions.MOUNT : (((Mob)this.original).m_20184_().f_82480_ < (double)-0.55f || this.isAirborneState() ? LivingMotions.FALL : (((Mob)this.original).f_267362_.m_267731_() > 0.01f ? LivingMotions.WALK : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    protected final void commonAggressiveMobUpdateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((Mob)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((Mob)this.original).m_20202_() != null ? LivingMotions.MOUNT : (((Mob)this.original).m_20184_().f_82480_ < (double)-0.55f || this.isAirborneState() ? LivingMotions.FALL : (((Mob)this.original).f_267362_.m_267731_() > 0.08f ? (((Mob)this.original).m_5912_() ? LivingMotions.CHASE : LivingMotions.WALK) : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    protected final void commonAggressiveRangedMobUpdateMotion(boolean considerInaction) {
        this.commonAggressiveMobUpdateMotion(considerInaction);
        UseAnim useAction = ((Mob)this.original).m_21120_(((Mob)this.original).m_7655_()).m_41780_();
        this.currentCompositeMotion = this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getRealAnimation().get().isReboundAnimation() ? LivingMotions.SHOT : (((Mob)this.original).m_6117_() ? (useAction == UseAnim.CROSSBOW ? LivingMotions.RELOAD : LivingMotions.AIM) : (CrossbowItem.m_40932_((ItemStack)((Mob)this.original).m_21205_()) ? LivingMotions.AIM : this.currentLivingMotion));
    }

    @Override
    public void updateArmor(CapabilityItem fromCap, CapabilityItem toCap, EquipmentSlot slotType) {
        if (((Mob)this.original).m_21204_().m_22171_((Attribute)EpicFightAttributes.STUN_ARMOR.get())) {
            if (fromCap != null) {
                ((Mob)this.original).m_21204_().m_22161_(fromCap.getAttributeModifiers(slotType, this));
            }
            if (toCap != null) {
                ((Mob)this.original).m_21204_().m_22178_(toCap.getAttributeModifiers(slotType, this));
            }
        }
    }

    @Override
    public boolean isTargetInvulnerable(Entity entity) {
        MobPatch mobpatch = EpicFightCapabilities.getEntityPatch(entity, MobPatch.class);
        if (mobpatch != null && mobpatch.mobFaction.equals(this.mobFaction)) {
            if (this.getTarget() == null) {
                return true;
            }
            return !this.getTarget().m_7306_(entity);
        }
        return super.isTargetInvulnerable(entity);
    }

    @Override
    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        boolean offhandValid = this.isOffhandItemValid();
        ItemStack mainHandItem = ((Mob)this.getOriginal()).m_21205_();
        ItemStack offHandItem = ((Mob)this.getOriginal()).m_21206_();
        List<AttributeModifier> mainHandAttributes = CapabilityItem.getAttributeModifiers(Attributes.f_22281_, EquipmentSlot.MAINHAND, ((Mob)this.original).m_21205_(), this);
        Set<AttributeModifier> offHandAttributes = this.isOffhandItemValid() ? CapabilityItem.getAttributeModifiers(Attributes.f_22281_, EquipmentSlot.MAINHAND, ((Mob)this.original).m_21206_(), this) : Set.of();
        this.epicFightDamageSource = damageSource;
        this.setOffhandDamage(hand, mainHandItem, offHandItem, offhandValid, mainHandAttributes, offHandAttributes);
        ((Mob)this.original).m_7327_(target);
        this.recoverMainhandDamage(hand, mainHandItem, offHandItem, mainHandAttributes, offHandAttributes);
        this.epicFightDamageSource = null;
        return super.attack(damageSource, target, hand);
    }

    @Override
    public LivingEntity getTarget() {
        return ((Mob)this.original).m_5448_();
    }

    public void setAttakTargetSync(LivingEntity entityIn) {
        if (!((Mob)this.original).m_9236_().m_5776_()) {
            ((Mob)this.original).m_6710_(entityIn);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPSetAttackTarget(((Mob)this.original).m_19879_(), entityIn != null ? entityIn.m_19879_() : -1), this.original, new Object[0]);
        }
    }

    @Override
    public float getAttackDirectionPitch() {
        LivingEntity attackTarget = this.getTarget();
        if (attackTarget != null) {
            float partialTicks = EpicFightSharedConstants.isPhysicalClient() ? Minecraft.m_91087_().m_91296_() : 1.0f;
            Vec3 target = attackTarget.m_20299_(partialTicks);
            Vec3 vector3d = ((Mob)this.original).m_20299_(partialTicks);
            double d0 = target.f_82479_ - vector3d.f_82479_;
            double d1 = target.f_82480_ - vector3d.f_82480_;
            double d2 = target.f_82481_ - vector3d.f_82481_;
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            return Mth.m_14036_((float)Mth.m_14177_((float)((float)(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))), (float)-30.0f, (float)30.0f);
        }
        return super.getAttackDirectionPitch();
    }

    @Override
    public Faction getFaction() {
        return this.mobFaction;
    }
}

