/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPClearSkills;
import yesman.epicfight.network.server.SPRemoveSkillAndLearn;
import yesman.epicfight.server.commands.arguments.SkillArgument;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class PlayerSkillCommand {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.epicfight.skill.add.failed"));
    private static final SimpleCommandExceptionType ERROR_REMOVE_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.epicfight.skill.remove.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.epicfight.skill.clear.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        RequiredArgumentBuilder addCommandBuilder = Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_());
        RequiredArgumentBuilder removeCommandBuilder = Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_());
        for (SkillSlot skillSlot : SkillSlot.ENUM_MANAGER.universalValues()) {
            if (!skillSlot.category().learnable()) continue;
            addCommandBuilder.then(Commands.m_82127_((String)skillSlot.toString().toLowerCase(Locale.ROOT)).then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).executes(commandContext -> PlayerSkillCommand.addSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets"), skillSlot, SkillArgument.getSkill((CommandContext<CommandSourceStack>)commandContext, "skill")))));
            removeCommandBuilder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)skillSlot.toString().toLowerCase(Locale.ROOT)).executes(commandContext -> PlayerSkillCommand.removeSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets"), skillSlot, null))).then(Commands.m_82129_((String)"skill", (ArgumentType)SkillArgument.skill()).executes(commandContext -> PlayerSkillCommand.removeSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets"), skillSlot, SkillArgument.getSkill((CommandContext<CommandSourceStack>)commandContext, "skill")))));
        }
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"skill").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").executes(commandContext -> PlayerSkillCommand.clearSkill((CommandSourceStack)commandContext.getSource(), (Collection<? extends ServerPlayer>)ImmutableList.of((Object)((CommandSourceStack)commandContext.getSource()).m_81375_())))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(commandContext -> PlayerSkillCommand.clearSkill((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets")))))).then(Commands.m_82127_((String)"add").then((ArgumentBuilder)addCommandBuilder))).then(Commands.m_82127_((String)"remove").then((ArgumentBuilder)removeCommandBuilder));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"epicfight").then((ArgumentBuilder)builder));
    }

    public static int clearSkill(CommandSourceStack commandSourceStack, Collection<? extends ServerPlayer> targets) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class).ifPresent(playerpatch -> {
                playerpatch.getSkillCapability().clearContainersAndLearnedSkills(true);
                SPClearSkills clearpacket = new SPClearSkills(player.m_19879_());
                EpicFightNetworkManager.sendToPlayer(clearpacket, player, new Object[0]);
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(clearpacket, (Entity)player, new Object[0]);
            });
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.m_288197_(PlayerSkillCommand.wrap(Component.m_237110_((String)"commands.epicfight.skill.clear.success.single", (Object[])new Object[]{targets.iterator().next().m_5446_()})), true);
            } else {
                commandSourceStack.m_288197_(PlayerSkillCommand.wrap(Component.m_237110_((String)"commands.epicfight.skill.clear.success.multiple", (Object[])new Object[]{i})), true);
            }
        } else {
            throw ERROR_CLEAR_FAILED.create();
        }
        return i;
    }

    public static int addSkill(CommandSourceStack commandSourceStack, Collection<? extends ServerPlayer> targets, SkillSlot slot, Skill skill) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class);
            SkillContainer skillContainer = playerpatch.getSkillCapability().getSkillContainerFor(slot);
            if (!skillContainer.setSkill(skill)) continue;
            if (skill.getCategory().learnable()) {
                playerpatch.getSkillCapability().addLearnedSkill(skill);
            }
            EpicFightNetworkManager.sendToPlayer(skillContainer.createSyncPacketToLocalPlayer(), serverPlayer, new Object[0]);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(skillContainer.createSyncPacketToRemotePlayer(), (Entity)serverPlayer, new Object[0]);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.m_288197_(PlayerSkillCommand.wrap(Component.m_237110_((String)"commands.epicfight.skill.add.success.single", (Object[])new Object[]{skill.getDisplayName(), targets.iterator().next().m_5446_()})), true);
            } else {
                commandSourceStack.m_288197_(PlayerSkillCommand.wrap(Component.m_237110_((String)"commands.epicfight.skill.add.success.multiple", (Object[])new Object[]{skill.getDisplayName(), i})), true);
            }
        } else {
            throw ERROR_ADD_FAILED.create();
        }
        return i;
    }

    public static int removeSkill(CommandSourceStack commandSourceStack, Collection<? extends ServerPlayer> targets, SkillSlot slot, Skill skill) throws CommandSyntaxException {
        int i = 0;
        for (ServerPlayer serverPlayer : targets) {
            SkillContainer skillContainer;
            ServerPlayerPatch playerpatch = EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class);
            if (playerpatch == null) continue;
            if (skill == null) {
                skillContainer = playerpatch.getSkill(slot);
                skill = skillContainer.getSkill();
                if (skill == null) continue;
                skillContainer.setSkill(null);
                EpicFightNetworkManager.sendToPlayer(new SPRemoveSkillAndLearn(slot, skill), serverPlayer, new Object[0]);
                EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(skillContainer.createSyncPacketToRemotePlayer(), (Entity)serverPlayer, new Object[0]);
                ++i;
                continue;
            }
            if (!playerpatch.getSkillCapability().removeLearnedSkill(skill) || (skillContainer = playerpatch.getSkill(slot)).getSkill() != skill) continue;
            skillContainer.setSkill(null);
            EpicFightNetworkManager.sendToPlayer(new SPRemoveSkillAndLearn(slot, skill), serverPlayer, new Object[0]);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(skillContainer.createSyncPacketToRemotePlayer(), (Entity)serverPlayer, new Object[0]);
            ++i;
        }
        if (i > 0) {
            if (i == 1) {
                commandSourceStack.m_288197_(PlayerSkillCommand.wrap(Component.m_237110_((String)"commands.epicfight.skill.remove.success.single", (Object[])new Object[]{skill.getDisplayName(), targets.iterator().next().m_5446_()})), true);
            } else {
                commandSourceStack.m_288197_(PlayerSkillCommand.wrap(Component.m_237110_((String)"commands.epicfight.skill.remove.success.multiple", (Object[])new Object[]{skill.getDisplayName(), i})), true);
            }
        } else {
            throw ERROR_REMOVE_FAILED.create();
        }
        return i;
    }

    private static <T> Supplier<T> wrap(T value) {
        return () -> value;
    }
}

