/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Vector4f;
import yesman.epicfight.main.EpicFightMod;

public final class EpicFightRenderTypes
extends RenderType {
    private static final BiFunction<ResourceLocation, RenderStateShard.CullStateShard, RenderType> TRIANGULATED_OUTLINE = Util.m_143821_((texLocation, cullStateShard) -> RenderType.m_173215_((String)EpicFightMod.prefix("outline"), (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173077_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texLocation, false, false)).m_110661_(cullStateShard).m_110663_(f_110111_).m_110675_(f_110124_).m_110689_(RenderType.OutlineProperty.IS_OUTLINE)));
    private static final Map<String, Map<ResourceLocation, RenderType>> TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE = new HashMap<String, Map<ResourceLocation, RenderType>>();
    private static final Function<RenderType, RenderType> TRIANGULATED_RENDER_TYPES = Util.m_143827_(renderType -> {
        if (renderType.m_173186_() == VertexFormat.Mode.TRIANGLES) {
            return renderType;
        }
        if (renderType instanceof RenderType.CompositeRenderType) {
            Optional cutoutTexture;
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            RenderStateShard.EmptyTextureStateShard patt2721$temp = compositeRenderType.f_110511_.f_110576_;
            if (patt2721$temp instanceof RenderStateShard.TextureStateShard) {
                RenderStateShard.TextureStateShard texStateShard = (RenderStateShard.TextureStateShard)patt2721$temp;
                cutoutTexture = texStateShard.f_110328_;
            } else {
                cutoutTexture = Optional.empty();
            }
            if (TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.containsKey(renderType.f_110133_)) {
                ResourceLocation texLocation2;
                Map<ResourceLocation, RenderType> renderTypesByTexture = TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.get(renderType.f_110133_);
                if (compositeRenderType.f_110511_.f_110576_ instanceof RenderStateShard.TextureStateShard && renderTypesByTexture.containsKey(texLocation2 = (ResourceLocation)cutoutTexture.orElse(null))) {
                    return renderTypesByTexture.get(texLocation2);
                }
            }
            RenderType.CompositeRenderType triangulatedRenderType = new RenderType.CompositeRenderType(renderType.f_110133_, renderType.f_110389_, VertexFormat.Mode.TRIANGLES, renderType.m_110507_(), renderType.m_110405_(), renderType.f_110393_, compositeRenderType.f_110511_);
            triangulatedRenderType.f_110513_ = triangulatedRenderType.f_110513_.isEmpty() ? triangulatedRenderType.f_110513_ : cutoutTexture.map(texLocation -> TRIANGULATED_OUTLINE.apply((ResourceLocation)texLocation, compositeRenderType.f_110511_.f_110582_));
            return triangulatedRenderType;
        }
        return renderType;
    });
    protected static final RenderStateShard.ShaderStateShard PARTICLE_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172829_);
    private static final RenderType ENTITY_UI_COLORED = EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("ui_color"), (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110685_(f_110139_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(false));
    private static final Function<ResourceLocation, RenderType> ENTITY_UI_TEXTURE = Util.m_143827_(textureLocation -> EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("ui_texture"), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173102_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false, false)).m_110685_(f_110134_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(false)));
    private static final RenderType OBB = EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("debug_collider"), (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
    private static final RenderType DEBUG_QUADS = EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("debug_quad"), (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110669_(f_110119_).m_110685_(f_110134_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
    private static final RenderType GUI_TRIANGLE = EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("gui_triangle"), (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_285573_).m_110685_(f_110139_).m_110663_(f_110113_).m_110691_(false));
    private static final Function<ResourceLocation, RenderType> OVERLAY_MODEL = Util.m_143827_(texLocation -> EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("overlay_model"), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texLocation, false, false)).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110112_).m_110685_(f_110139_).m_110671_(f_110152_).m_110691_(false)));
    private static final RenderType ENTITY_AFTERIMAGE_WHITE = EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("entity_afterimage"), (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(PARTICLE_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/common/white.png"), false, false)).m_110661_(f_110110_).m_110687_(f_110115_).m_110663_(f_110112_).m_110685_(f_110139_).m_110671_(f_110152_).m_110691_(false));
    private static final RenderType ITEM_AFTERIMAGE_WHITE = EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("item_afterimage"), (VertexFormat)DefaultVertexFormat.f_85813_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(PARTICLE_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/common/white.png"), false, false)).m_110661_(f_110110_).m_110687_(f_110115_).m_110663_(f_110112_).m_110685_(f_110139_).m_110671_(f_110152_).m_110691_(false));
    private static final Function<ResourceLocation, RenderType> ENTITY_PARTICLE = Util.m_143827_(texLocation -> EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("entity_particle"), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texLocation, false, false)).m_110687_(f_110115_).m_110663_(f_110112_).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110691_(false)));
    private static final RenderType ITEM_PARTICLE = EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("item_particle"), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173066_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.f_39692_, false, false)).m_110687_(f_110115_).m_110663_(f_110112_).m_110685_(f_110139_).m_110661_(f_110110_).m_110671_(f_110152_).m_110691_(false));
    private static final Function<ResourceLocation, RenderType> ENTITY_PARTICLE_STENCIL = Util.m_143827_(texLocation -> EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("entity_particle_stencil"), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173102_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texLocation, false, false)).m_110687_(f_110116_).m_110691_(false)));
    private static final RenderType ITEM_PARTICLE_STENCIL = EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("item_particle_stencil"), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173102_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InventoryMenu.f_39692_, false, false)).m_110687_(f_110116_).m_110691_(false));
    private static final RenderType.CompositeRenderType BLOCK_HIGHLIGHT = EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("block_highlight"), (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/common/white.png"), false, false)).m_110671_(f_110152_).m_173292_(f_173108_).m_110685_(f_110139_).m_110663_(f_110112_).m_110691_(false));
    private static final Map<Entity, RenderType.CompositeRenderType> WORLD_RENDERTYPES_COLORED_GLINT = new HashMap<Entity, RenderType.CompositeRenderType>();

    public static RenderType makeTriangulated(RenderType renderType) {
        if (renderType.m_173186_() == VertexFormat.Mode.TRIANGLES) {
            return renderType;
        }
        if (renderType instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            return new RenderType.CompositeRenderType(renderType.f_110133_, renderType.f_110389_, VertexFormat.Mode.TRIANGLES, renderType.m_110507_(), renderType.m_110405_(), renderType.f_110393_, compositeRenderType.f_110511_);
        }
        return renderType;
    }

    public static RenderType getTriangulated(RenderType renderType) {
        return TRIANGULATED_RENDER_TYPES.apply(renderType);
    }

    public static void addRenderType(String name, ResourceLocation textureLocation, RenderType renderType) {
        Map renderTypesByTexture = TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.computeIfAbsent(name, k -> Maps.newHashMap());
        renderTypesByTexture.put(textureLocation, renderType);
    }

    private static RenderType replaceTextureShard(ResourceLocation texToReplace, RenderType renderType) {
        if (renderType instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            RenderStateShard.EmptyTextureStateShard emptyTextureStateShard = compositeRenderType.f_110511_.f_110576_;
            if (emptyTextureStateShard instanceof RenderStateShard.TextureStateShard) {
                RenderStateShard.TextureStateShard texStateShard = (RenderStateShard.TextureStateShard)emptyTextureStateShard;
                RenderType.CompositeState textureReplacedState = new RenderType.CompositeState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texToReplace, texStateShard.f_110329_, texStateShard.f_110330_), compositeRenderType.f_110511_.f_173274_, compositeRenderType.f_110511_.f_110577_, compositeRenderType.f_110511_.f_110581_, compositeRenderType.f_110511_.f_110582_, compositeRenderType.f_110511_.f_110583_, compositeRenderType.f_110511_.f_110584_, compositeRenderType.f_110511_.f_110586_, compositeRenderType.f_110511_.f_110587_, compositeRenderType.f_110511_.f_110588_, compositeRenderType.f_110511_.f_110589_, compositeRenderType.f_110511_.f_110590_, compositeRenderType.f_110511_.f_285566_, compositeRenderType.f_110511_.f_110591_);
                return new RenderType.CompositeRenderType(renderType.f_110133_, renderType.f_110389_, compositeRenderType.m_173186_(), renderType.m_110507_(), renderType.m_110405_(), renderType.f_110393_, textureReplacedState);
            }
        }
        return null;
    }

    public static RenderType replaceTexture(ResourceLocation texLocation, RenderType renderType) {
        Map<ResourceLocation, RenderType> renderTypesByTexture;
        if (TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.containsKey(renderType.f_110133_) && (renderTypesByTexture = TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.get(renderType.f_110133_)).containsKey(texLocation)) {
            return renderTypesByTexture.get(texLocation);
        }
        RenderType textureReplacedRenderType = EpicFightRenderTypes.replaceTextureShard(texLocation, renderType);
        if (textureReplacedRenderType == null) {
            return renderType;
        }
        Map renderTypesByTexture2 = TRIANGLED_RENDERTYPES_BY_NAME_TEXTURE.computeIfAbsent(textureReplacedRenderType.f_110133_, k -> Maps.newHashMap());
        renderTypesByTexture2.put(texLocation, textureReplacedRenderType);
        return textureReplacedRenderType;
    }

    public static RenderType entityUIColor() {
        return ENTITY_UI_COLORED;
    }

    public static RenderType entityUITexture(ResourceLocation resourcelocation) {
        return ENTITY_UI_TEXTURE.apply(resourcelocation);
    }

    public static RenderType debugCollider() {
        return OBB;
    }

    public static RenderType m_269166_() {
        return DEBUG_QUADS;
    }

    public static RenderType guiTriangle() {
        return GUI_TRIANGLE;
    }

    public static RenderType overlayModel(ResourceLocation textureLocation) {
        return OVERLAY_MODEL.apply(textureLocation);
    }

    public static RenderType entityAfterimageStencil(ResourceLocation textureLocation) {
        return ENTITY_PARTICLE_STENCIL.apply(textureLocation);
    }

    public static RenderType itemAfterimageStencil() {
        return ITEM_PARTICLE_STENCIL;
    }

    public static RenderType entityAfterimageTranslucent(ResourceLocation textureLocation) {
        return ENTITY_PARTICLE.apply(textureLocation);
    }

    public static RenderType itemAfterimageTranslucent() {
        return ITEM_PARTICLE;
    }

    public static RenderType entityAfterimageWhite() {
        return ENTITY_AFTERIMAGE_WHITE;
    }

    public static RenderType itemAfterimageWhite() {
        return ITEM_AFTERIMAGE_WHITE;
    }

    public static RenderType blockHighlight() {
        return BLOCK_HIGHLIGHT;
    }

    public static void freeUnusedWorldRenderTypes() {
        WORLD_RENDERTYPES_COLORED_GLINT.entrySet().removeIf(entry -> ((Entity)entry.getKey()).m_213877_());
    }

    public static void clearWorldRenderTypes() {
        WORLD_RENDERTYPES_COLORED_GLINT.clear();
    }

    public static RenderType coloredGlintWorldRendertype(Entity owner, float r, float g, float b) {
        RenderType.CompositeRenderType glintRenderType = WORLD_RENDERTYPES_COLORED_GLINT.computeIfAbsent(owner, k -> EpicFightRenderTypes.m_173215_((String)EpicFightMod.prefix("colored_glint"), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)MutableCompositeState.mutableStateBuilder().setShaderState(f_173079_).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"epicfight", (String)"textures/entity/overlay/glint_white.png"), true, false)).setWriteMaskState(f_110115_).setCullState(f_110110_).setDepthTestState(f_110112_).setTransparencyState(f_110137_).setTexturingState(f_110151_).createCompositeState(false)));
        ((MutableCompositeState)glintRenderType.f_110511_).setShaderColor(r, g, b, 1.0f);
        return glintRenderType;
    }

    public static RenderType coloredGlintWorldRendertype(Entity owner, int r, int g, int b) {
        return EpicFightRenderTypes.coloredGlintWorldRendertype(owner, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    private EpicFightRenderTypes() {
        super(null, null, null, -1, false, false, null, null);
    }

    static /* synthetic */ RenderStateShard.EmptyTextureStateShard access$000() {
        return f_110147_;
    }

    static /* synthetic */ RenderStateShard.ShaderStateShard access$100() {
        return f_173096_;
    }

    static /* synthetic */ RenderStateShard.TransparencyStateShard access$200() {
        return f_110134_;
    }

    static /* synthetic */ RenderStateShard.DepthTestStateShard access$300() {
        return f_110113_;
    }

    static /* synthetic */ RenderStateShard.CullStateShard access$400() {
        return f_110158_;
    }

    static /* synthetic */ RenderStateShard.LightmapStateShard access$500() {
        return f_110153_;
    }

    static /* synthetic */ RenderStateShard.OverlayStateShard access$600() {
        return f_110155_;
    }

    static /* synthetic */ RenderStateShard.LayeringStateShard access$700() {
        return f_110117_;
    }

    static /* synthetic */ RenderStateShard.OutputStateShard access$800() {
        return f_110123_;
    }

    static /* synthetic */ RenderStateShard.TexturingStateShard access$900() {
        return f_110148_;
    }

    static /* synthetic */ RenderStateShard.WriteMaskStateShard access$1000() {
        return f_110114_;
    }

    static /* synthetic */ RenderStateShard.LineStateShard access$1100() {
        return f_110130_;
    }

    static /* synthetic */ RenderStateShard.ColorLogicStateShard access$1200() {
        return f_285585_;
    }

    public static class MutableCompositeState
    extends RenderType.CompositeState {
        private ShaderColorStateShard shaderColorState = new ShaderColorStateShard(new Vector4f(1.0f));

        public MutableCompositeState(RenderStateShard.EmptyTextureStateShard pTextureState, RenderStateShard.ShaderStateShard pShaderState, RenderStateShard.TransparencyStateShard pTransparencyState, RenderStateShard.DepthTestStateShard pDepthState, RenderStateShard.CullStateShard pCullState, RenderStateShard.LightmapStateShard pLightmapState, RenderStateShard.OverlayStateShard pOverlayState, RenderStateShard.LayeringStateShard pLayeringState, RenderStateShard.OutputStateShard pOutputState, RenderStateShard.TexturingStateShard pTexturingState, RenderStateShard.WriteMaskStateShard pWriteMaskState, RenderStateShard.LineStateShard pLineState, RenderStateShard.ColorLogicStateShard pColorLogicState, RenderType.OutlineProperty pOutlineProperty) {
            super(pTextureState, pShaderState, pTransparencyState, pDepthState, pCullState, pLightmapState, pOverlayState, pLayeringState, pOutputState, pTexturingState, pWriteMaskState, pLineState, pColorLogicState, pOutlineProperty);
            ArrayList<ShaderColorStateShard> list = new ArrayList<ShaderColorStateShard>((Collection<ShaderColorStateShard>)this.f_110592_);
            list.add(this.shaderColorState);
            this.f_110592_ = ImmutableList.copyOf(list);
        }

        public void setShaderColor(int r, int g, int b, int a) {
            this.shaderColorState.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }

        public void setShaderColor(float r, float g, float b, float a) {
            this.shaderColorState.setColor(r, g, b, a);
        }

        public static MutableCompositeStateBuilder mutableStateBuilder() {
            return new MutableCompositeStateBuilder();
        }

        public static class MutableCompositeStateBuilder {
            private RenderStateShard.EmptyTextureStateShard textureState = EpicFightRenderTypes.access$000();
            private RenderStateShard.ShaderStateShard shaderState = EpicFightRenderTypes.access$100();
            private RenderStateShard.TransparencyStateShard transparencyState = EpicFightRenderTypes.access$200();
            private RenderStateShard.DepthTestStateShard depthTestState = EpicFightRenderTypes.access$300();
            private RenderStateShard.CullStateShard cullState = EpicFightRenderTypes.access$400();
            private RenderStateShard.LightmapStateShard lightmapState = EpicFightRenderTypes.access$500();
            private RenderStateShard.OverlayStateShard overlayState = EpicFightRenderTypes.access$600();
            private RenderStateShard.LayeringStateShard layeringState = EpicFightRenderTypes.access$700();
            private RenderStateShard.OutputStateShard outputState = EpicFightRenderTypes.access$800();
            private RenderStateShard.TexturingStateShard texturingState = EpicFightRenderTypes.access$900();
            private RenderStateShard.WriteMaskStateShard writeMaskState = EpicFightRenderTypes.access$1000();
            private RenderStateShard.LineStateShard lineState = EpicFightRenderTypes.access$1100();
            private RenderStateShard.ColorLogicStateShard colorLogicState = EpicFightRenderTypes.access$1200();

            public MutableCompositeStateBuilder setTextureState(RenderStateShard.EmptyTextureStateShard pTextureState) {
                this.textureState = pTextureState;
                return this;
            }

            public MutableCompositeStateBuilder setShaderState(RenderStateShard.ShaderStateShard pShaderState) {
                this.shaderState = pShaderState;
                return this;
            }

            public MutableCompositeStateBuilder setTransparencyState(RenderStateShard.TransparencyStateShard pTransparencyState) {
                this.transparencyState = pTransparencyState;
                return this;
            }

            public MutableCompositeStateBuilder setDepthTestState(RenderStateShard.DepthTestStateShard pDepthTestState) {
                this.depthTestState = pDepthTestState;
                return this;
            }

            public MutableCompositeStateBuilder setCullState(RenderStateShard.CullStateShard pCullState) {
                this.cullState = pCullState;
                return this;
            }

            public MutableCompositeStateBuilder setLightmapState(RenderStateShard.LightmapStateShard pLightmapState) {
                this.lightmapState = pLightmapState;
                return this;
            }

            public MutableCompositeStateBuilder setOverlayState(RenderStateShard.OverlayStateShard pOverlayState) {
                this.overlayState = pOverlayState;
                return this;
            }

            public MutableCompositeStateBuilder setLayeringState(RenderStateShard.LayeringStateShard pLayerState) {
                this.layeringState = pLayerState;
                return this;
            }

            public MutableCompositeStateBuilder setOutputState(RenderStateShard.OutputStateShard pOutputState) {
                this.outputState = pOutputState;
                return this;
            }

            public MutableCompositeStateBuilder setTexturingState(RenderStateShard.TexturingStateShard pTexturingState) {
                this.texturingState = pTexturingState;
                return this;
            }

            public MutableCompositeStateBuilder setWriteMaskState(RenderStateShard.WriteMaskStateShard pWriteMaskState) {
                this.writeMaskState = pWriteMaskState;
                return this;
            }

            public MutableCompositeStateBuilder setLineState(RenderStateShard.LineStateShard pLineState) {
                this.lineState = pLineState;
                return this;
            }

            public MutableCompositeStateBuilder setColorLogicState(RenderStateShard.ColorLogicStateShard pColorLogicState) {
                this.colorLogicState = pColorLogicState;
                return this;
            }

            public MutableCompositeState createCompositeState(boolean pOutline) {
                return this.createCompositeState(pOutline ? RenderType.OutlineProperty.AFFECTS_OUTLINE : RenderType.OutlineProperty.NONE);
            }

            public MutableCompositeState createCompositeState(RenderType.OutlineProperty pOutlineState) {
                return new MutableCompositeState(this.textureState, this.shaderState, this.transparencyState, this.depthTestState, this.cullState, this.lightmapState, this.overlayState, this.layeringState, this.outputState, this.texturingState, this.writeMaskState, this.lineState, this.colorLogicState, pOutlineState);
            }
        }
    }

    public static class ShaderColorStateShard
    extends RenderStateShard {
        private Vector4f color;

        public ShaderColorStateShard(Vector4f color) {
            super("shader_color", () -> RenderSystem.setShaderColor((float)color.x, (float)color.y, (float)color.z, (float)color.w), () -> RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
            this.color = color;
        }

        public void setColor(float r, float g, float b, float a) {
            this.color.set(r, g, b, a);
        }
    }
}

