/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.event;

import java.util.TreeMap;
import yesman.epicfight.api.event.Event;
import yesman.epicfight.api.event.EventContext;
import yesman.epicfight.api.event.EventListener;
import yesman.epicfight.api.event.subscriptions.DefaultEventSubscription;
import yesman.epicfight.api.event.subscriptions.EventSubscription;

public class EventHook<T extends Event> {
    final TreeMap<Integer, EventListener<T>> subscriptions = new TreeMap((i1, i2) -> Integer.compare(i2, i1));

    public boolean post(T eventInstance) {
        EventContext eventContext = new EventContext();
        for (EventListener<T> subscriber : this.subscriptions.values()) {
            eventContext.subscriptionStart(subscriber.name());
            EventSubscription<T> eventSubscription = subscriber.subscription();
            if (!(eventSubscription instanceof DefaultEventSubscription)) continue;
            DefaultEventSubscription passiveSubscription = (DefaultEventSubscription)eventSubscription;
            passiveSubscription.fire(eventInstance);
            eventContext.onCalled();
        }
        eventContext.subscriptionEnd();
        return false;
    }

    public void registerEvent(DefaultEventSubscription<T> subscription) {
        this.registerEvent(subscription, EventHook.getDefaultSubscriberName(), 0);
    }

    public void registerEvent(DefaultEventSubscription<T> subscription, int priority) {
        this.registerEvent(subscription, EventHook.getDefaultSubscriberName(), priority);
    }

    public void registerEvent(DefaultEventSubscription<T> subscription, String name) {
        this.registerEvent(subscription, name, 0);
    }

    public void registerEvent(DefaultEventSubscription<T> subscription, String name, int priority) {
        this.subscriptions.put(priority, new EventListener<T>(name, subscription));
    }

    protected static String getDefaultSubscriberName() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[2];
        return caller.getClassName();
    }

    public static <T extends Event> EventHook<T> createEventHook() {
        return new EventHook<T>();
    }
}

