/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.input.action;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.client.input.controller.ControllerBinding;
import yesman.epicfight.api.utils.ExtendableEnum;
import yesman.epicfight.api.utils.ExtendableEnumManager;

@ApiStatus.Experimental
public interface InputAction
extends ExtendableEnum {
    public static final ExtendableEnumManager<InputAction> ENUM_MANAGER = new ExtendableEnumManager("input_action");

    @NotNull
    public KeyMapping keyMapping();

    @NotNull
    public @NotNull Optional<@NotNull ControllerBinding> controllerBinding();

    default public boolean isVanilla() {
        return false;
    }

    @NotNull
    public static Set<InputAction> nonVanillaActions() {
        HashSet<InputAction> result = new HashSet<InputAction>();
        for (InputAction action : ENUM_MANAGER.universalValues()) {
            if (action.isVanilla()) continue;
            result.add(action);
        }
        return result;
    }

    @Nullable
    public static InputAction fromKeyMapping(@NotNull KeyMapping keyMapping) {
        return ENUM_MANAGER.universalValues().stream().filter(action -> action.keyMapping() == keyMapping).findFirst().orElse(null);
    }
}

