/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.util;

import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.WeaponType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class CombatHelper {
    public static float getAttackReach(Player player, MedievalWeaponItem weapon) {
        return weapon.getAttackReach(CombatHelper.getBaseAttackReach(player));
    }

    public static float getBaseAttackReach(Player player) {
        return player.m_7500_() ? 5.0f : 4.5f;
    }

    public static float getBaseAttackDamage(ModItemTier material, WeaponType type) {
        return type.getBaseAttackDamage() + 1.6f * material.m_6631_() / type.getBaseAttackSpeed();
    }

    public static float getBaseAttackSpeed(ModItemTier material, WeaponType type) {
        return type.getAttackSpeed(material) - 4.0f;
    }

    public static float getDecreasedAttackDamage(float baseattackdamage, WeaponType type) {
        return type.getTwoHanded() > 1 ? 14.0f * baseattackdamage / (3.0f * (float)type.getTwoHanded() + 12.0f) : baseattackdamage;
    }

    public static float getDecreasedAttackSpeed(float baseattackspeed, WeaponType type) {
        return 14.0f * (baseattackspeed + 4.0f) / (5.0f * (float)type.getTwoHanded() + 10.0f) - 4.0f;
    }

    public static float getSilverAttackDamage(ModItemTier material, WeaponType type) {
        return (float)Math.round(6.0f / type.getAttackSpeed(material) * 100.0f) / 100.0f;
    }

    public static float getArmorPiercingFactor(Entity attacker) {
        LivingEntity livingentity;
        Item item;
        float f = 1.0f;
        if (attacker instanceof LivingEntity && (item = (livingentity = (LivingEntity)attacker).m_21205_().m_41720_()) instanceof MedievalWeaponItem) {
            MedievalWeaponItem weapon = (MedievalWeaponItem)item;
            float f2 = (float)weapon.type.getArmorPiercing() / 100.0f;
            f = f2 / (1.0f - f2);
        }
        return f;
    }

    public static float getDamageAfterArmorAbsorb(DamageSource source, LivingEntity victim, float damage) {
        if (!source.m_269533_(DamageTypeTags.f_268490_)) {
            damage = CombatRules.m_19272_((float)damage, (float)victim.m_21230_(), (float)((float)victim.m_21133_(Attributes.f_22285_)));
        }
        return damage;
    }

    public static float getDamageAfterMagicAbsorb(DamageSource source, LivingEntity victim, float damage) {
        int k;
        int j;
        float f;
        float f1;
        float f2;
        if (source.m_269533_(DamageTypeTags.f_268437_)) {
            return damage;
        }
        if (victim.m_21023_(MobEffects.f_19606_) && !source.m_269533_(DamageTypeTags.f_268630_) && (f2 = (f1 = damage) - (damage = Math.max((f = damage * (float)(j = 25 - (k = (victim.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (victim instanceof ServerPlayer) {
                ((ServerPlayer)victim).m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12934_), Math.round(f2 * 10.0f));
            } else if (source.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)source.m_7639_()).m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12930_), Math.round(f2 * 10.0f));
            }
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        if (source.m_269533_(DamageTypeTags.f_268413_)) {
            return damage;
        }
        k = EnchantmentHelper.m_44856_((Iterable)victim.m_6168_(), (DamageSource)source);
        if (k > 0) {
            damage = CombatRules.m_19269_((float)damage, (float)k);
        }
        return damage;
    }

    public static float getDamageAfterAbsorb(DamageSource source, LivingEntity victim, float damage) {
        Entity entity;
        if (victim.m_6673_(source) || damage <= 0.0f) {
            return 0.0f;
        }
        damage = CombatHelper.getDamageAfterArmorAbsorb(source, victim, damage);
        damage = CombatHelper.getDamageAfterMagicAbsorb(source, victim, damage);
        float f1 = Math.max(damage - victim.m_6103_(), 0.0f);
        victim.m_7911_(victim.m_6103_() - (damage - f1));
        float f = damage - f1;
        if (f > 0.0f && f < 3.4028235E37f && (entity = source.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.m_36222_(Stats.f_12929_, Math.round(f * 10.0f));
        }
        return f1;
    }
}

