/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item.crafting;

import com.magistuarmory.item.ArmorDecoration;
import com.magistuarmory.item.crafting.forge.ArmorDecorationRecipeImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArmorDecorationRecipe
extends CustomRecipe {
    public static RecipeSerializer<ArmorDecorationRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(ArmorDecorationRecipe::new);

    public ArmorDecorationRecipe(ResourceLocation location, CraftingBookCategory category) {
        super(location, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer container, Level level) {
        Item item;
        ItemStack wearabledecorationstack = ItemStack.f_41583_;
        ItemStack armorstack = ItemStack.f_41583_;
        ItemStack decorationstack = ItemStack.f_41583_;
        for (ItemStack stack : container.m_280657_()) {
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ArmorItem && stack.m_41720_() instanceof ArmorDecoration) {
                if (!wearabledecorationstack.m_41619_()) {
                    return false;
                }
                wearabledecorationstack = stack;
                continue;
            }
            if (stack.m_41720_() instanceof ArmorDecoration) {
                if (!decorationstack.m_41619_()) {
                    return false;
                }
                decorationstack = stack;
                continue;
            }
            if (stack.m_41720_() instanceof ArmorItem) {
                if (!armorstack.m_41619_()) {
                    return false;
                }
                armorstack = stack;
                continue;
            }
            return false;
        }
        if (!wearabledecorationstack.m_41619_()) {
            if (!decorationstack.m_41619_() && armorstack.m_41619_()) {
                armorstack = wearabledecorationstack;
            } else if (decorationstack.m_41619_() && !armorstack.m_41619_()) {
                decorationstack = wearabledecorationstack;
            } else {
                return false;
            }
        }
        if ((item = decorationstack.m_41720_()) instanceof ArmorDecoration) {
            ArmorDecoration decoration = (ArmorDecoration)item;
            return decoration.isApplicableForDecoration(armorstack);
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer container, @NotNull RegistryAccess access) {
        Item item;
        ItemStack wearabledecorationstack = ItemStack.f_41583_;
        ItemStack armorstack = ItemStack.f_41583_;
        ItemStack decorationstack = ItemStack.f_41583_;
        for (ItemStack stack : container.m_280657_()) {
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ArmorDecoration && stack.m_41720_() instanceof ArmorItem) {
                wearabledecorationstack = stack;
                continue;
            }
            if (stack.m_41720_() instanceof ArmorDecoration) {
                decorationstack = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof ArmorItem)) continue;
            armorstack = stack.m_41777_();
        }
        if (!wearabledecorationstack.m_41619_()) {
            if (!decorationstack.m_41619_() && armorstack.m_41619_()) {
                armorstack = wearabledecorationstack.m_41777_();
            } else if (decorationstack.m_41619_() && !armorstack.m_41619_()) {
                decorationstack = wearabledecorationstack;
            } else {
                return armorstack;
            }
        }
        if (!armorstack.m_41619_() && !decorationstack.m_41619_() && (item = decorationstack.m_41720_()) instanceof ArmorDecoration) {
            ArmorDecoration decoration = (ArmorDecoration)item;
            decoration.decorate(armorstack, decorationstack);
        }
        return armorstack;
    }

    public boolean m_8004_(int n, int m) {
        return n * m >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return ArmorDecorationRecipe.getSerializerInstance();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RecipeSerializer<ArmorDecorationRecipe> getSerializerInstance() {
        return ArmorDecorationRecipeImpl.getSerializerInstance();
    }
}

