/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.epicfight.animations;

import com.google.common.collect.Sets;
import com.merlin204.avalon.epicfight.api.AnimationAttackEvent;
import com.merlin204.avalon.epicfight.api.AnimationRenderEvent;
import com.merlin204.avalon.epicfight.api.AvalonAnimationProperty;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.BasicAttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.entity.eventlistener.AttackPhaseEndEvent;
import yesman.epicfight.world.entity.eventlistener.DetachablePlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class AvalonAttackAnimation
extends BasicAttackAnimation {
    private final float play_speed;
    private final float damageMulti;

    public AvalonAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti) {
        super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature);
        this.play_speed = play_speed;
        this.damageMulti = damageMulti;
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
    }

    public AvalonAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti, AvalonPhase ... phases) {
        super(transitionTime, accessor, armature, (AttackAnimation.Phase[])phases);
        this.play_speed = play_speed;
        this.damageMulti = damageMulti;
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
    }

    public AvalonAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, float damageMulti, AvalonPhase ... phases) {
        super(transitionTime, accessor, armature, (AttackAnimation.Phase[])phases);
        this.damageMulti = damageMulti;
        this.play_speed = 1.0f;
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
    }

    public AvalonAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends BasicAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AvalonPhase ... phases) {
        super(transitionTime, accessor, armature, (AttackAnimation.Phase[])phases);
        this.damageMulti = 1.0f;
        this.play_speed = 1.0f;
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
    }

    public AvalonAttackAnimation(float convertTime, String path, AssetAccessor<? extends Armature> armature, float play_speed, float damageMulti, AvalonPhase ... phases) {
        super(convertTime, path, armature, (AttackAnimation.Phase[])phases);
        this.play_speed = play_speed;
        this.damageMulti = damageMulti;
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, null);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.getCurrentlyActuallyHitEntities().clear();
        entitypatch.getCurrentlyAttackTriedEntities().clear();
        for (AttackAnimation.Phase phase : this.phases) {
            if (!(phase instanceof AvalonPhase)) continue;
            AvalonPhase avalonPhase = (AvalonPhase)phase;
            avalonPhase.resetAttackRecord(entitypatch);
        }
    }

    protected void attackTick(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> animation) {
        AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
        float prevElapsedTime = player.getPrevElapsedTime();
        float elapsedTime = player.getElapsedTime();
        EntityState prevState = ((DynamicAnimation)animation.get()).getState(entitypatch, prevElapsedTime);
        EntityState state = ((DynamicAnimation)animation.get()).getState(entitypatch, elapsedTime);
        List<AttackAnimation.Phase> activePhases = this.getActivePhases(elapsedTime);
        for (AttackAnimation.Phase phase : activePhases) {
            if (prevElapsedTime < phase.start && elapsedTime >= phase.start && phase instanceof AvalonPhase) {
                AvalonPhase avalonPhase = (AvalonPhase)phase;
                avalonPhase.resetAttackRecord(entitypatch);
            }
            if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
                MobPatch mobpatch = (MobPatch)entitypatch;
                ((Mob)mobpatch.getOriginal()).m_21573_().m_26573_();
                ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
                LivingEntity target = entitypatch.getTarget();
                if (target != null) {
                    entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
                }
            }
            if (!prevState.attacking() && !state.attacking() && (prevState.getLevel() > 2 || state.getLevel() <= 2)) continue;
            if (!prevState.attacking() || (prevElapsedTime < phase.start || prevElapsedTime >= phase.end) && (state.attacking() || prevState.getLevel() <= 2 && state.getLevel() > 2)) {
                entitypatch.playSound(this.getSwingSound(entitypatch, phase), 0.0f, 0.0f);
                entitypatch.removeHurtEntities();
            }
            this.hurtCollidingEntities(entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase);
            if (state.attacking() && !(elapsedTime >= this.getTotalTime()) || !(entitypatch instanceof ServerPlayerPatch)) continue;
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)entitypatch;
            playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ATTACK_PHASE_END_EVENT, (DetachablePlayerEvent)new AttackPhaseEndEvent(playerpatch, this.getAccessor(), phase, this.getPhaseOrderByTime(elapsedTime)));
        }
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        if (prevElapsedTime < phase.start && elapsedTime >= phase.start) {
            entitypatch.getCurrentlyActuallyHitEntities().clear();
            entitypatch.getCurrentlyAttackTriedEntities().clear();
            if (phase instanceof AvalonPhase) {
                AvalonPhase avalonPhase = (AvalonPhase)phase;
                avalonPhase.resetAttackRecord(entitypatch);
            }
        }
        float phasePrevTime = Math.max(prevElapsedTime, phase.start);
        float phaseCurrentTime = Math.min(elapsedTime, phase.end);
        float phasePreDelay = phase.start + phase.preDelay;
        float phaseContact = phase.start + phase.contact;
        if (phaseCurrentTime < phasePreDelay || phasePrevTime >= phaseContact) {
            return;
        }
        List list = phase.getCollidingEntities(entitypatch, (AttackAnimation)this, phasePrevTime, phaseCurrentTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
        if (!list.isEmpty()) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            int maxStrikes = 10;
            while (hitEntities.next()) {
                boolean canAttack;
                Entity target = hitEntities.getEntity();
                LivingEntity trueEntity = this.getTrueEntity(target);
                boolean bl = canAttack = trueEntity != null && trueEntity.m_6084_() && !entitypatch.getCurrentlyActuallyHitEntities().contains(trueEntity) && !entitypatch.isTargetInvulnerable(target);
                if (phase instanceof AvalonPhase) {
                    AvalonPhase avalonPhase = (AvalonPhase)phase;
                    boolean bl2 = canAttack = canAttack && avalonPhase.tryAttack(entitypatch, (Entity)trueEntity);
                }
                if (!canAttack || !entity.m_142582_(target)) continue;
                EpicFightDamageSource damagesource = this.getEpicFightDamageSource(entitypatch, target, phase);
                int prevInvulTime = target.f_19802_;
                target.f_19802_ = 0;
                this.getProperty((AnimationProperty)AvalonAnimationProperty.ATTACK_EVENTS).ifPresent(events -> {
                    for (AnimationAttackEvent event : events) {
                        event.execute(entitypatch, target, damagesource);
                    }
                });
                AttackResult attackResult = entitypatch.attack(damagesource, target, phase.hand);
                target.f_19802_ = prevInvulTime;
                if (attackResult.resultType.dealtDamage()) {
                    target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), this.getHitSound(entitypatch, phase), target.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)target.m_9236_(), entitypatch, target, phase);
                }
                entitypatch.getCurrentlyActuallyHitEntities().add(trueEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entitypatch.getCurrentlyAttackTriedEntities().add(trueEntity);
            }
        }
    }

    public <A extends AvalonAttackAnimation> A noPhysics() {
        this.addProperty(AnimationProperty.StaticAnimationProperty.NO_PHYSICS, true);
        return (A)((Object)this);
    }

    public <A extends AvalonAttackAnimation> A noPhysics(int startFrame, int endFrame) {
        this.newTimePair((float)startFrame / 60.0f, (float)endFrame / 60.0f).addProperty(AnimationProperty.StaticAnimationProperty.NO_PHYSICS, (Object)true);
        return (A)((Object)this);
    }

    public <A extends AvalonAttackAnimation> A noGravity() {
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, TimePairList.create((float[])new float[]{0.0f, 9999.0f}));
        return (A)((Object)this);
    }

    public <A extends AvalonAttackAnimation> A noGravity(int startFrame, int endFrame) {
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, TimePairList.create((float[])new float[]{(float)startFrame / 60.0f, (float)endFrame / 60.0f}));
        return (A)((Object)this);
    }

    public <A extends AvalonAttackAnimation> A useVerticalMove() {
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, true);
        return (A)((Object)this);
    }

    public <A extends AvalonAttackAnimation> A useVerticalMove(int startFrame, int endFrame) {
        this.newTimePair((float)startFrame / 60.0f, (float)endFrame / 60.0f).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, (Object)true);
        return (A)((Object)this);
    }

    public <A extends AvalonAttackAnimation> A useRawMove() {
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.RAW_COORD).addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (Object)MoveCoordFunctions.RAW_COORD);
        return (A)((Object)this);
    }

    public <A extends AvalonAttackAnimation> A addAttackEvents(AnimationAttackEvent<?> ... events) {
        this.properties.computeIfPresent(AvalonAnimationProperty.ATTACK_EVENTS, (k, v) -> Stream.concat(((Collection)v).stream(), List.of(events).stream()).toList());
        this.properties.computeIfAbsent(AvalonAnimationProperty.ATTACK_EVENTS, k -> List.of(events));
        return (A)((Object)this);
    }

    public <A extends AvalonAttackAnimation> A addRenderEvents(AnimationRenderEvent<?> ... events) {
        this.properties.computeIfPresent(AvalonAnimationProperty.RENDER_EVENTS, (k, v) -> Stream.concat(((Collection)v).stream(), List.of(events).stream()).toList());
        this.properties.computeIfAbsent(AvalonAnimationProperty.RENDER_EVENTS, k -> List.of(events));
        return (A)((Object)this);
    }

    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        int entityId = ((LivingEntity)entitypatch.getOriginal()).m_19879_();
        for (AttackAnimation.Phase phase : this.phases) {
            if (!(phase instanceof AvalonPhase)) continue;
            AvalonPhase avalonPhase = (AvalonPhase)phase;
            avalonPhase.clearAttackRecord(entityId);
        }
    }

    public float getPlaySpeed(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            AttackAnimation.Phase phase = this.getPhaseByTime(playerpatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor()).getElapsedTime());
            return playerpatch.getAttackSpeed(phase.hand) * this.play_speed;
        }
        return this.play_speed;
    }

    protected void bindPhaseState(AttackAnimation.Phase phase) {
        float preDelay = phase.preDelay;
        this.stateSpectrumBlueprint.newTimePair(0.0f, preDelay).addState(EntityState.PHASE_LEVEL, (Object)1).newTimePair(phase.start, phase.recovery).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).newTimePair(phase.start, phase.recovery + 0.1f).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).newTimePair(phase.start, phase.recovery).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, (Object)true).newTimePair(phase.antic, phase.end).addState(EntityState.TURNING_LOCKED, (Object)true).newTimePair(preDelay, phase.contact).addState(EntityState.ATTACKING, (Object)true).addState(EntityState.PHASE_LEVEL, (Object)2).newTimePair(phase.contact, phase.end).addState(EntityState.PHASE_LEVEL, (Object)3);
    }

    public EpicFightDamageSource getEpicFightDamageSource(DamageSource originalSource, LivingEntityPatch<?> entitypatch, Entity target, AttackAnimation.Phase phase) {
        EpicFightDamageSource epicfightDamageSource;
        if (phase == null) {
            phase = this.getPhaseByTime(entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor()).getElapsedTime());
        }
        EpicFightDamageSource extendedSource = originalSource instanceof EpicFightDamageSource ? (epicfightDamageSource = (EpicFightDamageSource)originalSource) : EpicFightDamageSources.fromVanillaDamageSource((DamageSource)originalSource).setAnimation(this.getAccessor());
        float phaseDamageMulti = 1.0f;
        float phaseImpactMulti = 1.0f;
        float phaseArmorNegationMulti = 1.0f;
        if (phase instanceof AvalonPhase) {
            AvalonPhase avalonPhase = (AvalonPhase)phase;
            phaseDamageMulti = avalonPhase.phaseDamageMulti;
            phaseImpactMulti = avalonPhase.phaseImpactMulti;
            phaseArmorNegationMulti = avalonPhase.phaseArmorNegationMulti;
        }
        ValueModifier damageModifier = ValueModifier.multiplier((float)(this.damageMulti * phaseDamageMulti));
        extendedSource.attachDamageModifier(damageModifier);
        extendedSource.setBaseImpact(extendedSource.getBaseImpact() * phaseImpactMulti);
        extendedSource.setBaseArmorNegation(extendedSource.getBaseArmorNegation() * phaseArmorNegationMulti);
        phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).ifPresent(opt -> extendedSource.setStunType(opt));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG).ifPresent(opt -> {
            Objects.requireNonNull(extendedSource);
            opt.forEach(arg_0 -> ((EpicFightDamageSource)extendedSource).addRuntimeTag(arg_0));
        });
        phase.getProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE).ifPresent(opt -> {
            Objects.requireNonNull(extendedSource);
            opt.forEach(arg_0 -> ((EpicFightDamageSource)extendedSource).addExtraDamage(arg_0));
        });
        phase.getProperty(AnimationProperty.AttackPhaseProperty.SOURCE_LOCATION_PROVIDER).ifPresent(opt -> extendedSource.setInitialPosition((Vec3)opt.apply(entitypatch)));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.SOURCE_LOCATION_PROVIDER).ifPresentOrElse(opt -> extendedSource.setInitialPosition((Vec3)opt.apply(entitypatch)), () -> extendedSource.setInitialPosition(((LivingEntity)entitypatch.getOriginal()).m_20182_()));
        return extendedSource;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, float playbackTime, float partialTicks) {
        AnimationPlayer animPlayer = entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
        float prevElapsedTime = animPlayer.getPrevElapsedTime();
        float elapsedTime = animPlayer.getElapsedTime();
        List<AttackAnimation.Phase> activePhases = this.getActivePhases(playbackTime);
        for (AttackAnimation.Phase phase : activePhases) {
            AttackAnimation.JointColliderPair[] colliders = phase.getColliders();
            if (colliders == null) continue;
            for (AttackAnimation.JointColliderPair colliderInfo : colliders) {
                Collider collider = (Collider)colliderInfo.getSecond();
                if (collider == null) {
                    collider = entitypatch.getColliderMatching(phase.hand);
                }
                float phaseStart = phase.start;
                float phaseEnd = phase.end;
                float phasePrevTime = Math.max(prevElapsedTime, phaseStart);
                float phaseCurrentTime = Math.min(elapsedTime, phaseEnd);
                collider.draw(poseStack, buffer, entitypatch, (AttackAnimation)this, (Joint)colliderInfo.getFirst(), phasePrevTime, phaseCurrentTime, partialTicks, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
            }
        }
    }

    public List<AttackAnimation.Phase> getActivePhases(float elapsedTime) {
        ArrayList<AttackAnimation.Phase> activePhases = new ArrayList<AttackAnimation.Phase>();
        for (AttackAnimation.Phase phase : this.phases) {
            if (!(elapsedTime >= phase.start) || !(elapsedTime < phase.end)) continue;
            activePhases.add(phase);
        }
        return activePhases;
    }

    public static class AvalonPhase
    extends AttackAnimation.Phase {
        public final float phaseDamageMulti;
        public final float phaseImpactMulti;
        public final float phaseArmorNegationMulti;
        private final Map<Integer, Set<Integer>> attackedEntitiesMap = new ConcurrentHashMap<Integer, Set<Integer>>();

        public void resetAttackRecord(LivingEntityPatch<?> entitypatch) {
            int entityId = ((LivingEntity)entitypatch.getOriginal()).m_19879_();
            this.attackedEntitiesMap.computeIfAbsent(entityId, k -> Collections.newSetFromMap(new ConcurrentHashMap())).clear();
        }

        public boolean tryAttack(LivingEntityPatch<?> entitypatch, Entity target) {
            int attackerId = ((LivingEntity)entitypatch.getOriginal()).m_19879_();
            int targetId = target.m_19879_();
            Set attackedEntities = this.attackedEntitiesMap.computeIfAbsent(attackerId, k -> Collections.newSetFromMap(new ConcurrentHashMap()));
            return attackedEntities.add(targetId);
        }

        public void clearAttackRecord(int entityId) {
            this.attackedEntitiesMap.remove(entityId);
        }

        public <V> AvalonPhase setHitSound(SoundEvent soundEvent) {
            this.addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, soundEvent);
            return this;
        }

        public <V> AvalonPhase setSwingSound(SoundEvent soundEvent) {
            this.addProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND, soundEvent);
            return this;
        }

        public <V> AvalonPhase addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value) {
            return (AvalonPhase)super.addProperty(propertyType, value);
        }

        public AvalonPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, Joint joint, Collider collider) {
            super(start, antic, preDelay, contact, recovery, end, hand, joint, collider);
            this.phaseDamageMulti = damageMulti;
            this.phaseImpactMulti = 1.0f;
            this.phaseArmorNegationMulti = 1.0f;
        }

        public AvalonPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, float phaseImpactMulti, Joint joint, Collider collider) {
            super(start, antic, preDelay, contact, recovery, end, hand, joint, collider);
            this.phaseDamageMulti = damageMulti;
            this.phaseImpactMulti = phaseImpactMulti;
            this.phaseArmorNegationMulti = 1.0f;
        }

        public AvalonPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, float phaseImpactMulti, float phaseArmorNegationMulti, Joint joint, Collider collider) {
            super(start, antic, preDelay, contact, recovery, end, hand, joint, collider);
            this.phaseDamageMulti = damageMulti;
            this.phaseImpactMulti = phaseImpactMulti;
            this.phaseArmorNegationMulti = phaseArmorNegationMulti;
        }

        public AvalonPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, Joint joint, Collider collider) {
            super(start, antic, preDelay, contact, recovery, end, hand, joint, collider);
            this.phaseDamageMulti = 1.0f;
            this.phaseImpactMulti = 1.0f;
            this.phaseArmorNegationMulti = 1.0f;
        }

        public AvalonPhase(InteractionHand hand, Joint joint, Collider collider) {
            super(hand, joint, collider);
            this.phaseDamageMulti = 1.0f;
            this.phaseImpactMulti = 1.0f;
            this.phaseArmorNegationMulti = 1.0f;
        }

        public AvalonPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, AttackAnimation.JointColliderPair ... colliders) {
            super(start, antic, preDelay, contact, recovery, end, hand, colliders);
            this.phaseDamageMulti = damageMulti;
            this.phaseImpactMulti = 1.0f;
            this.phaseArmorNegationMulti = 1.0f;
        }

        public AvalonPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, float phaseImpactMulti, AttackAnimation.JointColliderPair ... colliders) {
            super(start, antic, preDelay, contact, recovery, end, hand, colliders);
            this.phaseDamageMulti = damageMulti;
            this.phaseImpactMulti = phaseImpactMulti;
            this.phaseArmorNegationMulti = 1.0f;
        }

        public AvalonPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, float damageMulti, float phaseImpactMulti, float phaseArmorNegationMulti, AttackAnimation.JointColliderPair ... colliders) {
            super(start, antic, preDelay, contact, recovery, end, hand, colliders);
            this.phaseDamageMulti = damageMulti;
            this.phaseImpactMulti = phaseImpactMulti;
            this.phaseArmorNegationMulti = phaseArmorNegationMulti;
        }

        public AvalonPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, AttackAnimation.JointColliderPair ... colliders) {
            super(start, antic, preDelay, contact, recovery, end, hand, colliders);
            this.phaseDamageMulti = 1.0f;
            this.phaseImpactMulti = 1.0f;
            this.phaseArmorNegationMulti = 1.0f;
        }

        public List<Entity> getCollidingEntities(LivingEntityPatch<?> entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float attackSpeed) {
            HashSet entities = Sets.newHashSet();
            for (AttackAnimation.JointColliderPair colliderInfo : this.colliders) {
                Collider collider = (Collider)colliderInfo.getSecond();
                if (collider == null) {
                    collider = entitypatch.getColliderMatching(this.hand);
                }
                float phasePrev = Math.max(prevElapsedTime, this.start);
                float phaseCurrent = Math.min(elapsedTime, this.end);
                entities.addAll(collider.updateAndSelectCollideEntity(entitypatch, animation, phasePrev, phaseCurrent, (Joint)colliderInfo.getFirst(), attackSpeed));
            }
            return new ArrayList<Entity>(entities);
        }
    }
}

