/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.entity.vfx;

import com.merlin204.avalon.entity.vfx.VFXEntity;
import com.merlin204.avalon.epicfight.AvalonFctions;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

public class VFXEntityPatch<T extends VFXEntity>
extends MobPatch<T> {
    @Nullable
    private LivingEntityPatch<?> ownerPatch;

    public VFXEntityPatch() {
    }

    public Faction getFaction() {
        return AvalonFctions.EMPTY;
    }

    public void onConstructed(T entityIn) {
        Animator animator;
        this.original = entityIn;
        this.armature = this.getArmature();
        this.animator = animator = EpicFightSharedConstants.getAnimator((LivingEntityPatch)this);
        this.initAnimator(animator);
        animator.postInit();
    }

    public VFXEntityPatch(Faction faction) {
        super(faction);
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        float ownerYRot = ((VFXEntity)this.original).getStartYRot();
        ((VFXEntity)this.original).m_146922_(ownerYRot);
        boolean playAnimation = ((VFXEntity)this.getOriginal()).getPlayAnimation();
        if (!(this.isLogicalClient() && ((VFXEntity)this.original).getDefaultAnimation() == null && !playAnimation || playAnimation)) {
            if (this.getYRot() != ownerYRot) {
                return;
            }
            ((VFXEntity)this.original).setPlayAnimation(true);
            if (this.isLogicalClient()) {
                this.getClientAnimator().playAnimation(((VFXEntity)this.original).getDefaultAnimation(), 0.0f);
            } else {
                this.playAnimationSynchronized((AssetAccessor)((VFXEntity)this.original).getDefaultAnimation(), 0.0f);
            }
            ((VFXEntity)this.original).setShouldRender(true);
        }
        if (!this.animator.getEntityState().inaction() && playAnimation) {
            ((VFXEntity)this.getOriginal()).m_146870_();
        }
    }

    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTick) {
        float ownerYRot = ((VFXEntity)this.original).getStartYRot();
        this.setYRot(ownerYRot);
        ((VFXEntity)this.original).m_5618_(ownerYRot);
        ((VFXEntity)this.original).m_5616_(ownerYRot);
        if (animation instanceof ActionAnimation) {
            AvalonAnimationUtils.joinRotationInPose(pose, (LivingEntityPatch)this, "Root", ((VFXEntity)this.getOriginal()).getXRotOffset(), ((VFXEntity)this.getOriginal()).getYRotOffset(), ((VFXEntity)this.getOriginal()).getZRotOffset());
        }
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return super.getModelMatrix(partialTicks).scale(((VFXEntity)this.original).m_6134_(), ((VFXEntity)this.original).m_6134_(), ((VFXEntity)this.original).m_6134_());
    }

    public OpenMatrix4f getMatrix(float partialTicks) {
        return super.getMatrix(partialTicks).scale(((VFXEntity)this.original).m_6134_(), ((VFXEntity)this.original).m_6134_(), ((VFXEntity)this.original).m_6134_());
    }

    public void updateMotion(boolean considerInaction) {
        if (considerInaction) {
            this.currentLivingMotion = LivingMotions.IDLE;
        }
    }

    public Armature getArmature() {
        return ((VFXEntity)this.getOriginal()).getArmature();
    }

    public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    @Nullable
    public LivingEntityPatch<?> getOwnerPatch() {
        if (this.ownerPatch != null) {
            return this.ownerPatch;
        }
        if (((VFXEntity)this.getOriginal()).getOwner() != null) {
            this.ownerPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)((VFXEntity)this.getOriginal()).getOwner(), LivingEntityPatch.class);
            return this.ownerPatch;
        }
        return null;
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        if (this.getOwnerPatch() != null && this.shouldUseOwnerAttack()) {
            return this.getOwnerPatch().attack(damageSource, target, hand);
        }
        return super.attack(damageSource, target, hand);
    }

    public boolean shouldUseOwnerAttack() {
        return true;
    }

    protected void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, ((VFXEntity)this.original).getIdleAnimation());
    }

    @Nullable
    public EpicFightDamageSource getEpicFightDamageSource() {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getEpicFightDamageSource();
        }
        return super.getEpicFightDamageSource();
    }

    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getDamageSource(animation, hand);
        }
        return super.getDamageSource(animation, hand);
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        if (this.getOwnerPatch() == null) {
            return super.getSwingSound(hand);
        }
        return this.getOwnerPatch().getSwingSound(hand);
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        if (this.getOwnerPatch() == null) {
            return super.getWeaponHitSound(hand);
        }
        return this.getOwnerPatch().getWeaponHitSound(hand);
    }

    public boolean isTargetInvulnerable(Entity entity) {
        if (entity.equals((Object)((VFXEntity)this.getOriginal()).getOwner())) {
            return true;
        }
        if (entity instanceof VFXEntity) {
            VFXEntity artifactSpiritEntity = (VFXEntity)entity;
            if (this.getOwnerPatch() != null) {
                return ((LivingEntity)this.getOwnerPatch().getOriginal()).equals((Object)artifactSpiritEntity.getOwner());
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean flashTargetIndicator(LocalPlayerPatch playerPatch) {
        return false;
    }
}

