/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.entity.projectile;

import com.merlin204.avalon.entity.projectile.AvalonProjectileEntity;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import com.merlin204.avalon.epicfight.AvalonFctions;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

public class AvalonProjectilePatch<T extends AvalonProjectileEntity>
extends MobPatch<T> {
    @Nullable
    private LivingEntityPatch<?> ownerPatch;

    public boolean applyStun(StunType stunType, float stunTime) {
        return false;
    }

    public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    public Faction getFaction() {
        return AvalonFctions.EMPTY;
    }

    public void onConstructed(T entityIn) {
        Animator animator;
        this.original = entityIn;
        this.armature = this.getArmature();
        this.animator = animator = EpicFightSharedConstants.getAnimator((LivingEntityPatch)this);
        this.initAnimator(animator);
        animator.postInit();
    }

    public void updateMotion(boolean b) {
        if (b) {
            this.currentLivingMotion = LivingMotions.IDLE;
        }
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        boolean playAnimation = ((AvalonProjectileEntity)this.getOriginal()).getPlayAnimation();
        if (!(this.isLogicalClient() && ((AvalonProjectileEntity)this.original).getDefaultAnimation() == null && !playAnimation || playAnimation)) {
            ((AvalonProjectileEntity)this.original).setPlayAnimation(true);
            if (this.isLogicalClient()) {
                this.getClientAnimator().playAnimation(((AvalonProjectileEntity)this.original).getDefaultAnimation(), 0.0f);
            } else {
                this.playAnimationSynchronized((AssetAccessor)((AvalonProjectileEntity)this.original).getDefaultAnimation(), 0.0f);
            }
        }
    }

    @Nullable
    public LivingEntityPatch<?> getOwnerPatch() {
        if (this.ownerPatch != null) {
            return this.ownerPatch;
        }
        if (((AvalonProjectileEntity)this.getOriginal()).getOwner() != null) {
            this.ownerPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)((AvalonProjectileEntity)this.getOriginal()).getOwner(), LivingEntityPatch.class);
            return this.ownerPatch;
        }
        return null;
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        return super.getModelMatrix(partialTicks).scale(((AvalonProjectileEntity)this.original).m_6134_(), ((AvalonProjectileEntity)this.original).m_6134_(), ((AvalonProjectileEntity)this.original).m_6134_());
    }

    public OpenMatrix4f getMatrix(float partialTicks) {
        return super.getMatrix(partialTicks).scale(((AvalonProjectileEntity)this.original).m_6134_(), ((AvalonProjectileEntity)this.original).m_6134_(), ((AvalonProjectileEntity)this.original).m_6134_());
    }

    public Armature getArmature() {
        return ((AvalonProjectileEntity)this.original).getArmature();
    }

    public LivingEntity target() {
        if (this.getOwnerPatch().getTarget() != null) {
            return this.getOwnerPatch().getTarget();
        }
        if (this.getTarget() != null) {
            return this.getTarget();
        }
        Level level = ((AvalonProjectileEntity)this.getOriginal()).m_9236_();
        double range = 16.0;
        List nearbyEntities = level.m_6249_(this.getOwnerPatch().getOriginal(), ((LivingEntity)this.getOwnerPatch().getOriginal()).m_20191_().m_82400_(range), entity -> AvalonProjectilePatch.isHostileMob(entity) && entity != this.getOwnerPatch().getOriginal());
        Entity nearestTarget = null;
        double minDistance = Double.MAX_VALUE;
        Entity owner = this.getOwnerPatch().getOriginal();
        for (Entity entity2 : nearbyEntities) {
            double distance = owner.m_20280_(entity2);
            if (level.m_45547_(new ClipContext(owner.m_20299_(1.0f), entity2.m_20299_(1.0f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, owner)).m_6662_() != HitResult.Type.MISS || !(distance < minDistance)) continue;
            minDistance = distance;
            nearestTarget = entity2;
        }
        if (nearestTarget instanceof LivingEntity) {
            return (LivingEntity)nearestTarget;
        }
        return null;
    }

    public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTick) {
        AvalonAnimationUtils.joinRotationInPose(pose, (LivingEntityPatch)this, "Root", -((AvalonProjectileEntity)this.original).getSyncXRot(), 0.0f, 0.0f);
    }

    public static boolean isHostileMob(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        return entity instanceof Enemy || entity instanceof Monster || entity.m_6095_() == EntityType.f_20526_ || entity.m_6095_() == EntityType.f_20468_ || entity.m_6095_() == EntityType.f_20509_ || entity.m_6095_() == EntityType.f_20453_;
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        if (this.getOwnerPatch() != null && this.shouldUseOwnerAttack()) {
            return this.getOwnerPatch().attack(damageSource, target, hand);
        }
        return super.attack(damageSource, target, hand);
    }

    public boolean shouldUseOwnerAttack() {
        return true;
    }

    protected void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, ((AvalonProjectileEntity)this.original).getIdleAnimation());
    }

    @Nullable
    public EpicFightDamageSource getEpicFightDamageSource() {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getEpicFightDamageSource();
        }
        return super.getEpicFightDamageSource();
    }

    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getDamageSource(animation, hand);
        }
        return super.getDamageSource(animation, hand);
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        if (this.getOwnerPatch() == null) {
            return super.getSwingSound(hand);
        }
        return this.getOwnerPatch().getSwingSound(hand);
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        if (this.getOwnerPatch() == null) {
            return super.getWeaponHitSound(hand);
        }
        return this.getOwnerPatch().getWeaponHitSound(hand);
    }

    public boolean isTargetInvulnerable(Entity entity) {
        if (entity.equals((Object)((AvalonProjectileEntity)this.getOriginal()).getOwner())) {
            return true;
        }
        if (entity instanceof VFXEntity) {
            VFXEntity artifactSpiritEntity = (VFXEntity)entity;
            if (this.getOwnerPatch() != null) {
                return ((LivingEntity)this.getOwnerPatch().getOriginal()).equals((Object)artifactSpiritEntity.getOwner());
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean flashTargetIndicator(LocalPlayerPatch playerPatch) {
        return false;
    }
}

