/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.entity.projectile;

import com.merlin204.avalon.entity.IAvalonMeshEntity;
import com.merlin204.avalon.entity.projectile.AvalonProjectilePatch;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public abstract class AvalonProjectileEntity
extends Mob
implements IAvalonMeshEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.m_135353_(AvalonProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> DATA_OWNER_ID = SynchedEntityData.m_135353_(AvalonProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> SYNC_X_ROT = SynchedEntityData.m_135353_(AvalonProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(AvalonProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Boolean> PLAY_ANIMATION = SynchedEntityData.m_135353_(AvalonProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean initialVelocityApplied = false;

    public AvalonProjectileEntity(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
        this.f_19794_ = true;
        this.m_20242_(true);
        this.m_6842_(true);
    }

    protected AvalonProjectileEntity(EntityType<? extends Mob> pEntityType, LivingEntity owner, float scale, Level pLevel) {
        super(pEntityType, pLevel);
        this.tame(owner);
        this.f_19811_ = true;
        this.f_19794_ = true;
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
        this.m_20242_(true);
        this.m_6842_(true);
    }

    public boolean m_147207_(MobEffectInstance pEffectInstance, @Nullable Entity pEntity) {
        return false;
    }

    public boolean getPlayAnimation() {
        return (Boolean)this.f_19804_.m_135370_(PLAY_ANIMATION);
    }

    public void setPlayAnimation(boolean b) {
        this.f_19804_.m_135381_(PLAY_ANIMATION, (Object)b);
    }

    public AvalonProjectilePatch<?> getPatch() {
        return (AvalonProjectilePatch)EpicFightCapabilities.getEntityPatch((Entity)this, AvalonProjectilePatch.class);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.fly();
    }

    public void fly() {
        if (!this.initialVelocityApplied) {
            this.applyInitialVelocity(2.0f);
            this.initialVelocityApplied = true;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_OWNER_ID, (Object)0);
        this.f_19804_.m_135372_(SYNC_X_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(PLAY_ANIMATION, (Object)false);
    }

    public void tame(LivingEntity livingEntity) {
        this.setOwnerUUID(livingEntity.m_20148_());
        this.setOwnerID(livingEntity.m_19879_());
    }

    public void setSyncXRot(float f) {
        this.f_19804_.m_135381_(SYNC_X_ROT, (Object)Float.valueOf(f));
    }

    public float getSyncXRot() {
        return ((Float)this.f_19804_.m_135370_(SYNC_X_ROT)).floatValue();
    }

    @Nullable
    public LivingEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            Player player = this.m_9236_().m_46003_(uuid);
            if (player == null) {
                LivingEntity livingEntity;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    Entity entity = serverLevel.m_8791_(uuid);
                    return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
                }
                Entity entity = this.m_9236_().m_6815_(this.getOwnerID());
                return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
            }
            return player;
        }
        return null;
    }

    public void aimAtEntity(Entity target) {
        if (target == null) {
            return;
        }
        Vec3 eyePos = this.m_146892_();
        Vec3 targetPos = target.m_146892_();
        Vec3 direction = targetPos.m_82546_(eyePos).m_82541_();
        double horizontalDistance = direction.m_165924_();
        float yRot = (float)(Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_) * -57.29577951308232);
        float xRot = (float)(Mth.m_14136_((double)direction.f_82480_, (double)horizontalDistance) * -57.29577951308232);
        this.m_146922_(yRot);
        this.setSyncXRot(xRot);
        this.f_19859_ = yRot;
    }

    public void applyInitialVelocity(float flightSpeed) {
        float yRotRad = this.m_146908_() * ((float)Math.PI / 180);
        float xRotRad = this.getSyncXRot() * ((float)Math.PI / 180);
        double motionX = -Math.sin(yRotRad) * Math.cos(xRotRad);
        double motionY = -Math.sin(xRotRad);
        double motionZ = Math.cos(yRotRad) * Math.cos(xRotRad);
        Vec3 motion = new Vec3(motionX, motionY, motionZ).m_82541_().m_82490_((double)flightSpeed);
        this.m_20256_(motion);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public int getOwnerID() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNER_ID);
    }

    public void setOwnerID(int id) {
        this.f_19804_.m_135381_(DATA_OWNER_ID, (Object)id);
    }

    public static AttributeSupplier getDefaultAttribute() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, (double)19.9f).m_22268_(Attributes.f_22281_, 3.0).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 10.0).m_22265_();
    }

    public float m_6134_() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    @Override
    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getIdleAnimation() {
        return Animations.EMPTY_ANIMATION;
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDefaultAnimation() {
        return null;
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_21017_) {
        return false;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public boolean m_5843_() {
        return false;
    }
}

