/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.entity.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TargetInGirdCondition<T extends LivingEntityPatch>
implements Condition<T> {
    public final boolean test;
    private final List<Rectangle> rectangles;

    public TargetInGirdCondition(int x, int z) {
        this.test = false;
        this.rectangles = Collections.singletonList(new Rectangle(x, z, x, z));
    }

    public TargetInGirdCondition(Rectangle ... rects) {
        this.test = false;
        this.rectangles = Arrays.asList(rects);
    }

    public TargetInGirdCondition(boolean test, int x, int z) {
        this.test = test;
        this.rectangles = Collections.singletonList(new Rectangle(x, z, x, z));
    }

    public TargetInGirdCondition(boolean test, Rectangle ... rects) {
        this.test = test;
        this.rectangles = Arrays.asList(rects);
    }

    public boolean predicate(T livingEntityPatch) {
        Vec3 Pos = livingEntityPatch.getOriginal().m_20182_();
        Level world = livingEntityPatch.getOriginal().m_9236_();
        AABB searchArea = new AABB(Pos.f_82479_ - 30.0, Pos.f_82480_ - 2.0, Pos.f_82481_ - 30.0, Pos.f_82479_ + 30.0, Pos.f_82480_ + 2.0, Pos.f_82481_ + 30.0);
        List entities = world.m_6443_(LivingEntity.class, searchArea, e -> e.m_6084_() && e != livingEntityPatch.getOriginal());
        if (this.test) {
            this.drawAllRectangles(livingEntityPatch);
        }
        float yRot = livingEntityPatch.getOriginal().m_146908_();
        double theta = Math.toRadians(yRot);
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>(this.rectangles);
        for (LivingEntity entity : entities) {
            Vec3 entityPos = entity.m_20182_();
            double dx = entityPos.f_82479_ - Pos.f_82479_;
            double dz = entityPos.f_82481_ - Pos.f_82481_;
            double localX = dx * cos + dz * sin;
            double localZ = -dx * sin + dz * cos;
            if (Math.abs(localX) >= 24.0 || Math.abs(localZ) >= 24.0) continue;
            int gridX = (int)Math.floor(localX + 0.5);
            int gridZ = (int)Math.floor(localZ + 0.5);
            for (Rectangle rect : rects) {
                if (gridX < rect.xMin || gridX > rect.xMax || gridZ < rect.zMin || gridZ > rect.zMax || entity != livingEntityPatch.getTarget()) continue;
                return true;
            }
        }
        return false;
    }

    private void drawAllRectangles(T livingEntityPatch) {
        Vec3 Pos = livingEntityPatch.getOriginal().m_20182_();
        float yRot = livingEntityPatch.getOriginal().m_146908_();
        LivingEntity livingEntity = (LivingEntity)livingEntityPatch.getOriginal();
        for (Rectangle rect : this.rectangles) {
            double minX = (double)rect.xMin - 0.5;
            double maxX = (double)rect.xMax + 0.5;
            double minZ = (double)rect.zMin - 0.5;
            double maxZ = (double)rect.zMax + 0.5;
            this.drawLine(Pos, yRot, minX, minZ, maxX, minZ, livingEntity);
            this.drawLine(Pos, yRot, maxX, minZ, maxX, maxZ, livingEntity);
            this.drawLine(Pos, yRot, maxX, maxZ, minX, maxZ, livingEntity);
            this.drawLine(Pos, yRot, minX, maxZ, minX, minZ, livingEntity);
        }
    }

    private void drawLine(Vec3 Pos, float yRot, double x1, double z1, double x2, double z2, LivingEntity entity) {
        double step = 0.1;
        double dx = x2 - x1;
        double dz = z2 - z1;
        double length = Math.sqrt(dx * dx + dz * dz);
        int steps = (int)(length / 0.1);
        for (int i = 0; i <= steps; ++i) {
            double progress = (double)i / (double)steps;
            double localX = x1 + dx * progress;
            double localZ = z1 + dz * progress;
            Vec3 worldPos = this.localToWorld(new Vec3(localX, 0.0, localZ), Pos, yRot);
            Level level = entity.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, worldPos.f_82479_, worldPos.f_82480_ + 0.5, worldPos.f_82481_, 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private Vec3 localToWorld(Vec3 local, Vec3 origin, float yRot) {
        double radian = Math.toRadians(yRot);
        double cos = Math.cos(radian);
        double sin = Math.sin(radian);
        return new Vec3(origin.f_82479_ + local.f_82479_ * cos - local.f_82481_ * sin, origin.f_82480_, origin.f_82481_ + local.f_82479_ * sin + local.f_82481_ * cos);
    }

    public Condition<T> read(CompoundTag compoundTag) throws IllegalArgumentException {
        return null;
    }

    public CompoundTag serializePredicate() {
        return null;
    }

    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }

    public static class Rectangle {
        public final int xMin;
        public final int xMax;
        public final int zMin;
        public final int zMax;

        public Rectangle(int x1, int z1, int x2, int z2) {
            this.xMin = Math.min(x1, x2);
            this.xMax = Math.max(x1, x2);
            this.zMin = Math.min(z1, z2);
            this.zMax = Math.max(z1, z2);
        }
    }
}

