/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.api;

import com.merlin204.avalon.api.AvalonAutoRegister;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import com.merlin204.avalon.main.AvalonMOD;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import yesman.epicfight.api.client.forgeevent.PatchedRenderersEvent;
import yesman.epicfight.api.forgeevent.EntityPatchRegistryEvent;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;

@Mod.EventBusSubscriber(modid="epic_fight_avalon", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AvalonEntityRegistryManager {
    private static final Map<RegistryObject<EntityType<?>>, AvalonAutoRegister> ENTITY_REGISTRY = new HashMap();

    public static void scanAndRegisterEntities(Class<?> entitiesClass) {
        try {
            for (Field field : entitiesClass.getDeclaredFields()) {
                if (!field.getType().equals(RegistryObject.class) || !field.isAnnotationPresent(AvalonAutoRegister.class)) continue;
                field.setAccessible(true);
                RegistryObject entityRegistry = (RegistryObject)field.get(null);
                AvalonAutoRegister annotation = field.getAnnotation(AvalonAutoRegister.class);
                ENTITY_REGISTRY.put(entityRegistry, annotation);
                AvalonMOD.LOGGER.info("\u81ea\u52a8\u6ce8\u518c\u5b9e\u4f53: {} -> {}", (Object)field.getName(), (Object)annotation.value());
            }
        }
        catch (IllegalAccessException e) {
            AvalonMOD.LOGGER.error("\u626b\u63cf\u5b9e\u4f53\u6ce8\u89e3\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void handleEntityPatchRegistry(EntityPatchRegistryEvent event) {
        for (Map.Entry<RegistryObject<EntityType<?>>, AvalonAutoRegister> entry : ENTITY_REGISTRY.entrySet()) {
            RegistryObject<EntityType<?>> entity = entry.getKey();
            AvalonAutoRegister annotation = entry.getValue();
            Function<Entity, Supplier<EntityPatch<?>>> patchSupplier = AvalonEntityRegistryManager.createEntityPatchSupplier(annotation.entityPatch());
            event.getTypeEntry().put((EntityType)entity.get(), patchSupplier);
            AvalonMOD.LOGGER.debug("Avalon\u81ea\u52a8\u6ce8\u518c EntityPatch: {} -> {}", (Object)entity.getId(), (Object)annotation.entityPatch().getSimpleName());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (Map.Entry<RegistryObject<EntityType<?>>, AvalonAutoRegister> entry : ENTITY_REGISTRY.entrySet()) {
                RegistryObject<EntityType<?>> entity = entry.getKey();
                AvalonAutoRegister annotation = entry.getValue();
                EntityRendererProvider<?> rendererProvider = AvalonEntityRegistryManager.createEntityRendererProvider(annotation.clientRenderer());
                EntityType entityType = (EntityType)entity.get();
                EntityRendererProvider<?> provider = rendererProvider;
                EntityRenderers.m_174036_((EntityType)entityType, provider);
                AvalonMOD.LOGGER.debug("Avalon\u81ea\u52a8\u6ce8\u518c EntityRender: {} -> {}", (Object)entity.getId(), (Object)annotation.clientRenderer());
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handlePatchedRenderers(PatchedRenderersEvent.Add event) {
        for (Map.Entry<RegistryObject<EntityType<?>>, AvalonAutoRegister> entry : ENTITY_REGISTRY.entrySet()) {
            RegistryObject<EntityType<?>> entity = entry.getKey();
            AvalonAutoRegister annotation = entry.getValue();
            Function<EntityType<?>, PatchedEntityRenderer> renderPatchFunction = AvalonEntityRegistryManager.createRenderPatchFunction(annotation.renderPatch(), event.getContext());
            event.addPatchedEntityRenderer((EntityType)entity.get(), renderPatchFunction);
            AvalonMOD.LOGGER.debug("Avalon\u81ea\u52a8\u6ce8\u518c RenderPatch: {} -> {}", (Object)entity.getId(), (Object)annotation.renderPatch());
        }
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        for (Map.Entry<RegistryObject<EntityType<?>>, AvalonAutoRegister> entry : ENTITY_REGISTRY.entrySet()) {
            RegistryObject<EntityType<?>> entity = entry.getKey();
            AvalonAutoRegister annotation = entry.getValue();
            if (!annotation.registerAttributes()) continue;
            try {
                AttributeSupplier attributeSupplier = AvalonEntityRegistryManager.getDefaultAttributes(entity);
                event.put((EntityType)entity.get(), attributeSupplier);
                AvalonMOD.LOGGER.debug("\u6210\u529f\u6ce8\u518c\u5b9e\u4f53\u5c5e\u6027: {}", (Object)entity.getId());
            }
            catch (Exception e) {
                AvalonMOD.LOGGER.error("\u6ce8\u518c\u5b9e\u4f53\u5c5e\u6027\u5931\u8d25: {}", (Object)entity.getId(), (Object)e);
            }
        }
    }

    private static AttributeSupplier getDefaultAttributes(RegistryObject<EntityType<?>> entity) {
        try {
            Class entityClass = ((EntityType)entity.get()).m_142225_();
            Method method = entityClass.getDeclaredMethod("getDefaultAttributes", new Class[0]);
            method.setAccessible(true);
            return (AttributeSupplier)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return VFXEntity.getDefaultAttribute();
            }
            catch (Exception ex) {
                throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u9ed8\u8ba4\u5c5e\u6027", ex);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u5c5e\u6027: " + entity.getId(), e);
        }
    }

    private static Function<Entity, Supplier<EntityPatch<?>>> createEntityPatchSupplier(Class<?> patchClass) {
        return entity -> {
            Supplier<EntityPatch> supplier = () -> {
                try {
                    try {
                        Constructor constructor = patchClass.getDeclaredConstructor(Entity.class);
                        return (EntityPatch)constructor.newInstance(entity);
                    }
                    catch (NoSuchMethodException e) {
                        Constructor constructor = patchClass.getDeclaredConstructor(new Class[0]);
                        EntityPatch patch = (EntityPatch)constructor.newInstance(new Object[0]);
                        try {
                            Method setCustomData = patchClass.getMethod("setCustomData", Object.class);
                            setCustomData.invoke((Object)patch, entity);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        return patch;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Avalon\u65e0\u6cd5\u521b\u5efa EntityPatch: " + patchClass.getName(), e);
                }
            };
            return supplier;
        };
    }

    private static EntityRendererProvider<?> createEntityRendererProvider(String className) {
        return context -> {
            try {
                Class<?> rendererClass = Class.forName(className);
                Constructor<?> constructor = rendererClass.getDeclaredConstructor(EntityRendererProvider.Context.class);
                return (EntityRenderer)constructor.newInstance(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Avalon\u65e0\u6cd5\u521b\u5efa EntityRender: " + className, e);
            }
        };
    }

    private static Function<EntityType<?>, PatchedEntityRenderer> createRenderPatchFunction(String className, EntityRendererProvider.Context context) {
        return entityType -> {
            try {
                Class<?> renderPatchClass = Class.forName(className);
                Constructor<?> constructor = renderPatchClass.getDeclaredConstructor(EntityRendererProvider.Context.class, EntityType.class);
                PatchedEntityRenderer renderer = (PatchedEntityRenderer)constructor.newInstance(context, entityType);
                try {
                    Method initLayerLast = renderPatchClass.getMethod("initLayerLast", EntityRendererProvider.Context.class, EntityType.class);
                    initLayerLast.invoke((Object)renderer, context, entityType);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return renderer;
            }
            catch (Exception e) {
                throw new RuntimeException("Avalon\u65e0\u6cd5\u521b\u5efa RenderPatch: " + className, e);
            }
        };
    }
}

