/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.mixins;

import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.shelmarow.combat_evolution.ai.BehaviorUtils;
import net.shelmarow.combat_evolution.ai.CECombatBehaviors;
import net.shelmarow.combat_evolution.ai.CEHumanoidPatch;
import net.shelmarow.combat_evolution.iml.ILivingEntityData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

@Mixin(value={AttackAnimation.class})
public class EFAttackAnimation {
    @Shadow(remap=false)
    protected void spawnHitParticle(ServerLevel world, LivingEntityPatch<?> attacker, Entity hit, AttackAnimation.Phase phase) {
    }

    @Inject(method={"getEpicFightDamageSource(Lyesman/epicfight/world/capabilities/entitypatch/LivingEntityPatch;Lnet/minecraft/world/entity/Entity;Lyesman/epicfight/api/animation/types/AttackAnimation$Phase;)Lyesman/epicfight/world/damagesource/EpicFightDamageSource;"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void onGetDamageSource(LivingEntityPatch<?> entityPatch, Entity target, AttackAnimation.Phase phase, CallbackInfoReturnable<EpicFightDamageSource> cir) {
        if (entityPatch instanceof CEHumanoidPatch) {
            ILivingEntityData entityData = (ILivingEntityData)entityPatch;
            EpicFightDamageSource returnValue = (EpicFightDamageSource)cir.getReturnValue();
            float damage = entityData.combat_evolution$getDamageMultiplier((LivingEntity)entityPatch.getOriginal());
            float impact = entityData.combat_evolution$getImpactMultiplier((LivingEntity)entityPatch.getOriginal());
            float armorNegation = entityData.combat_evolution$getArmorNegationMultiplier((LivingEntity)entityPatch.getOriginal());
            int stunIndex = entityData.combat_evolution$getStunType((LivingEntity)entityPatch.getOriginal());
            Set<TagKey<DamageType>> sourceTag = BehaviorUtils.getSourceTagSet(entityPatch);
            if (stunIndex != -1) {
                StunType stunType = StunType.values()[stunIndex];
                returnValue.setStunType(stunType);
            }
            returnValue.attachDamageModifier(ValueModifier.multiplier((float)damage));
            returnValue.attachImpactModifier(ValueModifier.multiplier((float)impact));
            returnValue.attachArmorNegationModifier(ValueModifier.multiplier((float)armorNegation));
            if (!sourceTag.isEmpty()) {
                sourceTag.forEach(arg_0 -> ((EpicFightDamageSource)returnValue).addRuntimeTag(arg_0));
            }
            cir.setReturnValue((Object)returnValue);
        }
    }

    @Redirect(method={"hurtCollidingEntities"}, at=@At(value="INVOKE", target="Lyesman/epicfight/api/animation/types/AttackAnimation;spawnHitParticle(Lnet/minecraft/server/level/ServerLevel;Lyesman/epicfight/world/capabilities/entitypatch/LivingEntityPatch;Lnet/minecraft/world/entity/Entity;Lyesman/epicfight/api/animation/types/AttackAnimation$Phase;)V"), remap=false)
    private void onHurtCollidingEntities(AttackAnimation instance, ServerLevel world, LivingEntityPatch<?> entityPatch, Entity target, AttackAnimation.Phase phase) {
        this.spawnHitParticle((ServerLevel)target.m_9236_(), entityPatch, target, phase);
        if (entityPatch instanceof CEHumanoidPatch) {
            CEHumanoidPatch ceHumanoidPatch = (CEHumanoidPatch)entityPatch;
            CECombatBehaviors.Behavior<PathfinderMob> current = BehaviorUtils.getCurrentBehavior(entityPatch);
            if (current != null) {
                current.executeHitEvent(ceHumanoidPatch, target);
            }
        }
    }
}

