/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.mixins;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.shelmarow.combat_evolution.ai.BehaviorUtils;
import net.shelmarow.combat_evolution.ai.CECombatBehaviors;
import net.shelmarow.combat_evolution.ai.CEHumanoidPatch;
import net.shelmarow.combat_evolution.iml.ILivingEntityData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@Mixin(value={AnimationPlayer.class})
public abstract class AnimationPlayerMixin {
    @Shadow(remap=false)
    protected float elapsedTime;
    @Shadow(remap=false)
    protected float prevElapsedTime;
    @Unique
    private LivingEntityPatch<?> combatEvolution$storeEntityPatch;
    @Unique
    DynamicAnimation combatEvolution$currentPlay;

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=false)
    private void tick(LivingEntityPatch<?> entityPatch, CallbackInfo ci) {
        CEHumanoidPatch ceHumanoidPatch;
        CECombatBehaviors.Behavior<PathfinderMob> behavior;
        this.combatEvolution$storeEntityPatch = entityPatch;
        this.combatEvolution$currentPlay = (DynamicAnimation)((AnimationPlayer)this).getAnimation().get();
        if (entityPatch instanceof CEHumanoidPatch && (behavior = BehaviorUtils.getCurrentBehavior(ceHumanoidPatch = (CEHumanoidPatch)entityPatch)) != null) {
            behavior.executeTimeEvent(this.prevElapsedTime, this.elapsedTime, ceHumanoidPatch);
        }
    }

    @ModifyVariable(method={"tick"}, at=@At(value="STORE"), name={"playbackSpeed"}, remap=false)
    private float modifyPlaybackSpeed(float originalValue) {
        ILivingEntityData livingEntityData = (ILivingEntityData)this.combatEvolution$storeEntityPatch;
        if (livingEntityData.combat_evolution$getCanModifySpeed((LivingEntity)this.combatEvolution$storeEntityPatch.getOriginal()) && this.combatEvolution$currentPlay instanceof ActionAnimation && this.combatEvolution$storeEntityPatch instanceof CEHumanoidPatch) {
            return livingEntityData.combat_evolution$getAttackSpeed((LivingEntity)this.combatEvolution$storeEntityPatch.getOriginal());
        }
        return originalValue;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lyesman/epicfight/api/animation/property/AnimationProperty$PlaybackSpeedModifier;modify(Lyesman/epicfight/api/animation/types/DynamicAnimation;Lyesman/epicfight/world/capabilities/entitypatch/LivingEntityPatch;FFF)F", ordinal=0), remap=false)
    private float redirectModify(AnimationProperty.PlaybackSpeedModifier instance, DynamicAnimation dynamicAnimation, LivingEntityPatch<?> entityPatch, float playbackSpeed, float prevElapsedTime, float elapsedTime) {
        ILivingEntityData livingEntityData = (ILivingEntityData)entityPatch;
        if (livingEntityData.combat_evolution$getCanModifySpeed((LivingEntity)entityPatch.getOriginal()) && dynamicAnimation instanceof ActionAnimation && entityPatch instanceof CEHumanoidPatch) {
            return playbackSpeed;
        }
        return instance.modify(dynamicAnimation, entityPatch, playbackSpeed, prevElapsedTime, elapsedTime);
    }
}

