/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.execution;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.shelmarow.combat_evolution.ai.CEHumanoidPatch;
import net.shelmarow.combat_evolution.effect.CEMobEffects;
import net.shelmarow.combat_evolution.execution.ExecutionHandler;
import net.shelmarow.combat_evolution.execution.ExecutionTypeManager;
import net.shelmarow.combat_evolution.tickTask.TickTask;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class ExecutionTask
extends TickTask {
    private final LivingEntity executor;
    private final LivingEntity target;
    private final ExecutionTypeManager.Type executionType;

    public ExecutionTask(LivingEntity executor, LivingEntity target, ExecutionTypeManager.Type executionType, int durationTicks) {
        super(durationTicks);
        this.executor = executor;
        this.target = target;
        this.executionType = executionType;
    }

    @Override
    public void onStart() {
        ExecutionHandler.addExecutingTarget(this.target, this.executor);
        LivingEntityPatch entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.executor, LivingEntityPatch.class);
        LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.target, LivingEntityPatch.class);
        this.executor.m_7292_(new MobEffectInstance((MobEffect)CEMobEffects.FULL_STUN_IMMUNITY.get(), 100, 1, true, false));
        this.target.m_7292_(new MobEffectInstance((MobEffect)CEMobEffects.FULL_STUN_IMMUNITY.get(), 100, 1, true, false));
        if (entityPatch instanceof PlayerPatch) {
            PlayerPatch playerPatch = (PlayerPatch)entityPatch;
            playerPatch.setStamina(playerPatch.getMaxStamina());
            this.executor.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 4));
        }
        if ((entityPatch instanceof PlayerPatch || entityPatch instanceof CEHumanoidPatch || entityPatch instanceof HumanoidMobPatch) && (targetPatch instanceof PlayerPatch || targetPatch instanceof CEHumanoidPatch || targetPatch instanceof HumanoidMobPatch)) {
            entityPatch.playAnimationSynchronized(this.executionType.getExecutionAnimation(), 0.0f);
            targetPatch.playAnimationSynchronized(this.executionType.getExecutedAnimation(), 0.0f);
            Vec3 from = this.executor.m_146892_();
            Vec3 to = this.target.m_146892_();
            double dx = to.f_82479_ - from.f_82479_;
            double dz = to.f_82481_ - from.f_82481_;
            float yaw = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0) - 10.0f;
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                serverPlayerPatch.setModelYRot(yaw, true);
            } else {
                entityPatch.setYRot(yaw);
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public void onFinish() {
        ExecutionHandler.removeExecutingTarget(this.target);
    }
}

