/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.execution;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.shelmarow.combat_evolution.ai.CEHumanoidPatch;
import net.shelmarow.combat_evolution.execution.ExecutionTask;
import net.shelmarow.combat_evolution.execution.ExecutionTypeManager;
import net.shelmarow.combat_evolution.iml.CustomExecuteEntity;
import net.shelmarow.combat_evolution.tickTask.TickTaskManager;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.StunType;

@Mod.EventBusSubscriber(modid="combat_evolution", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExecutionHandler {
    private static final Map<LivingEntity, LivingEntity> executingTargets = new HashMap<LivingEntity, LivingEntity>();
    public static final float EXECUTION_DISTANCE = 3.5f;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity;
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (event.getSource().m_269533_(DamageTypeTags.f_268738_)) {
            return;
        }
        if (executingTargets.containsKey(target)) {
            LivingEntity allowedAttacker = executingTargets.get(target);
            if (source == null || !source.m_20148_().equals(allowedAttacker.m_20148_())) {
                event.setCanceled(true);
            }
        } else if (executingTargets.containsValue(target)) {
            event.setCanceled(true);
        }
        if (source instanceof LivingEntity && executingTargets.containsValue(livingEntity = (LivingEntity)source) && !executingTargets.containsKey(target)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKnockback(LivingKnockBackEvent event) {
        LivingEntity target = event.getEntity();
        if (executingTargets.containsKey(target)) {
            event.setStrength(0.0f);
        }
    }

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
    }

    public static boolean tryExecute(ServerPlayer player) {
        Entity entity = ExecutionHandler.getEntityLookedAt((Player)player, 3.5);
        if (entity != null) {
            LivingEntity livingEntity;
            AssetAccessor stunAnimation;
            ServerPlayerPatch playerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
            LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
            if (targetPatch != null && playerPatch != null && playerPatch.isEpicFightMode() && playerPatch.getEntityState().canUseSkill() && (stunAnimation = Objects.requireNonNull(targetPatch.getAnimator().getPlayerFor(null)).getAnimation()) != null && stunAnimation == targetPatch.getHitAnimation(StunType.NEUTRALIZE) && entity instanceof LivingEntity && ExecutionHandler.canExecute((Player)player, livingEntity = (LivingEntity)entity, targetPatch)) {
                Vec3 frontPos;
                ExecutionTypeManager.Type executionType = ExecutionHandler.getExecutionType(playerPatch, targetPatch);
                Level level = player.m_9236_();
                if (ExecutionHandler.canStandHere(level, frontPos = ExecutionHandler.calculateExecutionPosition(livingEntity, executionType.getOffset()), (LivingEntity)playerPatch.getOriginal())) {
                    player.m_6021_(frontPos.f_82479_, frontPos.f_82480_, frontPos.f_82481_);
                    TickTaskManager.addTask(entity.m_20148_(), new ExecutionTask((LivingEntity)player, livingEntity, executionType, 100));
                    return true;
                }
                player.m_5661_((Component)Component.m_237115_((String)"text.combat_evolution.not_available_pos").m_130940_(ChatFormatting.RED), true);
            }
        }
        return false;
    }

    public static ExecutionTypeManager.Type getExecutionType(LivingEntityPatch<?> executor, LivingEntityPatch<?> targetPatch) {
        ExecutionTypeManager.Type executionType = ExecutionTypeManager.DEFAULT_TYPE;
        if (targetPatch instanceof CustomExecuteEntity) {
            CustomExecuteEntity customExecuteEntity = (CustomExecuteEntity)targetPatch;
            ExecutionTypeManager.Type type = customExecuteEntity.getExecutionType();
            if (type != null) {
                executionType = type;
            }
        } else {
            CapabilityItem capabilityItem = targetPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (capabilityItem != null) {
                ExecutionTypeManager.Type type = ExecutionTypeManager.getExecutionType(((LivingEntity)executor.getOriginal()).m_21120_(InteractionHand.MAIN_HAND));
                if (type == null) {
                    WeaponCategory weaponCategory = capabilityItem.getWeaponCategory();
                    type = ExecutionTypeManager.getExecutionType(weaponCategory);
                }
                if (type != null) {
                    executionType = type;
                }
            }
        }
        return executionType;
    }

    public static Entity getEntityLookedAt(Player player, double maxDistance) {
        AABB aabb;
        Vec3 lookVec;
        Vec3 reachVec;
        Vec3 eyePos = player.m_20299_(1.0f);
        EntityHitResult entityHit = ExecutionHandler.getEntityHitResult((Entity)player, eyePos, reachVec = eyePos.m_82549_((lookVec = player.m_20252_(1.0f)).m_82490_(maxDistance)), aabb = new AABB(eyePos, reachVec).m_82400_(0.2), entity -> entity != player && !entity.m_5833_() && entity.m_6084_() && entity instanceof LivingEntity, maxDistance * maxDistance, 0.5);
        if (entityHit != null) {
            BlockHitResult blockHit = player.m_9236_().m_45547_(new ClipContext(eyePos, entityHit.m_82443_().m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            double blockDistanceSqr = blockHit.m_6662_() != HitResult.Type.MISS ? eyePos.m_82557_(blockHit.m_82450_()) : Double.MAX_VALUE;
            double entityDistanceSqr = eyePos.m_82557_(entityHit.m_82443_().m_146892_());
            if (entityDistanceSqr < blockDistanceSqr && blockDistanceSqr - entityDistanceSqr > entityHit.m_82443_().m_20191_().f_82288_) {
                return entityHit.m_82443_();
            }
        }
        return null;
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Entity shooter, Vec3 start, Vec3 end, AABB region, Predicate<Entity> filter, double maxDistance, double expandRadius) {
        Level level = shooter.m_9236_();
        double closest = maxDistance;
        Entity hitEntity = null;
        Vec3 hitPos = null;
        for (Entity e : level.m_6249_(shooter, region, filter)) {
            Vec3 point;
            double dist;
            AABB aabb = e.m_20191_().m_82400_((double)e.m_6143_() + expandRadius);
            Optional hit = aabb.m_82371_(start, end);
            if (aabb.m_82390_(start)) {
                if (!(closest >= 0.0)) continue;
                hitEntity = e;
                hitPos = hit.orElse(start);
                closest = 0.0;
                continue;
            }
            if (!hit.isPresent() || !((dist = start.m_82557_(point = (Vec3)hit.get())) < closest) && closest != 0.0) continue;
            if (e.m_20201_() == shooter.m_20201_() && !e.canRiderInteract()) {
                if (closest != 0.0) continue;
                hitEntity = e;
                hitPos = point;
                continue;
            }
            hitEntity = e;
            hitPos = point;
            closest = dist;
        }
        return hitEntity == null ? null : new EntityHitResult(hitEntity, hitPos);
    }

    public static boolean canExecute(Player player, LivingEntity entity, LivingEntityPatch<?> entityPatch) {
        return player.m_6084_() && entity.m_6084_() && ExecutionHandler.isExecutingTarget((LivingEntity)player, entity) && ExecutionHandler.isTargetPatchSupported(entityPatch) && ExecutionHandler.isHoldingWeapon(player) && ExecutionHandler.targetIsInRange(player, entity, 0.0, 3.5, 180.0);
    }

    public static boolean isHoldingWeapon(Player player) {
        CapabilityItem capabilityItem = EpicFightCapabilities.getItemStackCapability((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND));
        return capabilityItem.getWeaponCategory() != CapabilityItem.WeaponCategories.NOT_WEAPON && capabilityItem.getWeaponCategory() != CapabilityItem.WeaponCategories.FIST;
    }

    public static boolean isTargetPatchSupported(LivingEntityPatch<?> entityPatch) {
        if (entityPatch instanceof CustomExecuteEntity) {
            CustomExecuteEntity customExecuteEntity = (CustomExecuteEntity)entityPatch;
            return customExecuteEntity.canBeExecuted(entityPatch);
        }
        return entityPatch instanceof CEHumanoidPatch || entityPatch instanceof PlayerPatch || entityPatch instanceof HumanoidMobPatch;
    }

    public static void addExecutingTarget(LivingEntity target, LivingEntity executor) {
        executingTargets.put(target, executor);
    }

    public static void removeExecutingTarget(LivingEntity target) {
        executingTargets.remove(target);
    }

    public static boolean isExecutingTarget(LivingEntity executor, LivingEntity target) {
        return !executingTargets.containsKey(target) && !executingTargets.containsKey(executor);
    }

    private static Vec3 calculateExecutionPosition(LivingEntity target, Vec3 offset) {
        float yaw = target.m_146908_();
        double rad = Math.toRadians(yaw);
        double forwardX = -Math.sin(rad);
        double forwardZ = Math.cos(rad);
        double rightX = Math.cos(rad);
        double rightZ = Math.sin(rad);
        double offsetX = forwardX * offset.f_82479_ + rightX * offset.f_82481_;
        double offsetY = offset.f_82480_;
        double offsetZ = forwardZ * offset.f_82479_ + rightZ * offset.f_82481_;
        return target.m_20182_().m_82520_(offsetX, offsetY, offsetZ);
    }

    public static boolean targetIsInRange(Player player, LivingEntity target, double minDist, double maxDist, double maxAngleDegrees) {
        Vec3 toPlayer;
        Vec3 targetPos = target.m_20182_();
        Vec3 playerPos = player.m_20182_();
        double distance = playerPos.m_82554_(targetPos);
        if (distance < minDist || distance > maxDist) {
            return false;
        }
        float yaw = target.m_146908_();
        double yawRad = Math.toRadians(yaw);
        Vec3 forward = new Vec3(-Math.sin(yawRad), 0.0, Math.cos(yawRad)).m_82541_();
        double dot = forward.m_82526_(toPlayer = playerPos.m_82546_(targetPos).m_82541_());
        double angle = Math.toDegrees(Math.acos(dot));
        return angle <= maxAngleDegrees;
    }

    public static boolean canStandHere(Level level, Vec3 pos, LivingEntity entity) {
        double surfaceY;
        AABB entityBox = entity.m_20191_();
        double width = entityBox.m_82362_();
        double height = entityBox.m_82376_();
        boolean solidBelow = false;
        BlockPos blockPosBelow = BlockPos.m_274561_((double)pos.f_82479_, (double)(pos.f_82480_ - 1.0), (double)pos.f_82481_);
        BlockState stateBelow = level.m_8055_(blockPosBelow);
        VoxelShape shapeBelow = stateBelow.m_60812_((BlockGetter)level, blockPosBelow);
        if (!shapeBelow.m_83281_()) {
            double surfaceY2 = shapeBelow.m_83297_(Direction.Axis.Y) + (double)blockPosBelow.m_123342_();
            solidBelow = Math.abs(pos.f_82480_ - surfaceY2) <= 0.5;
        }
        BlockPos blockPosStand = BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
        BlockState stateStand = level.m_8055_(blockPosStand);
        VoxelShape shapeStand = stateStand.m_60812_((BlockGetter)level, blockPosStand);
        double offsetY = 0.0;
        if (!shapeStand.m_83281_() && (surfaceY = shapeStand.m_83297_(Direction.Axis.Y)) <= 0.5) {
            offsetY = surfaceY;
        }
        AABB checkBox = new AABB(pos.f_82479_ - width / 2.0, pos.f_82480_ + offsetY, pos.f_82481_ - width / 2.0, pos.f_82479_ + width / 2.0, pos.f_82480_ + offsetY + height, pos.f_82481_ + width / 2.0);
        boolean spaceFree = level.m_45772_(checkBox);
        return solidBelow && spaceFree;
    }
}

