/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.client.particle.follow;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CEFollowParticleOptions
implements ParticleOptions {
    private final ParticleType<?> type;
    private final int entityID;
    private final Vec3 offset;
    public static final ParticleOptions.Deserializer<CEFollowParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<CEFollowParticleOptions>(){

        @NotNull
        public CEFollowParticleOptions fromCommand(@NotNull ParticleType<CEFollowParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            int entityId = reader.readInt();
            reader.expect(' ');
            double offsetX = reader.readDouble();
            reader.expect(' ');
            double offsetY = reader.readDouble();
            reader.expect(' ');
            double offsetZ = reader.readDouble();
            return new CEFollowParticleOptions(type, entityId, new Vec3(offsetX, offsetY, offsetZ));
        }

        @NotNull
        public CEFollowParticleOptions fromNetwork(@NotNull ParticleType<CEFollowParticleOptions> type, FriendlyByteBuf buf) {
            return new CEFollowParticleOptions(type, buf.readInt(), new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }
    };

    public CEFollowParticleOptions(ParticleType<?> type, int entityID, Vec3 offset) {
        this.type = type;
        this.entityID = entityID;
        this.offset = offset;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public Vec3 getStartPos() {
        return this.offset;
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeDouble(this.offset.f_82479_);
        buf.writeDouble(this.offset.f_82480_);
        buf.writeDouble(this.offset.f_82481_);
    }

    @NotNull
    public String m_5942_() {
        return String.format("%d %.2f %.2f %.2f", this.entityID, this.offset.f_82479_, this.offset.f_82480_, this.offset.f_82481_);
    }

    public static Codec<CEFollowParticleOptions> codec(ParticleType<CEFollowParticleOptions> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("entity_id").forGetter(CEFollowParticleOptions::getEntityID), (App)Codec.DOUBLE.fieldOf("offset_x").forGetter(o -> o.getStartPos().f_82479_), (App)Codec.DOUBLE.fieldOf("offset_y").forGetter(o -> o.getStartPos().f_82480_), (App)Codec.DOUBLE.fieldOf("offset_z").forGetter(o -> o.getStartPos().f_82481_)).apply((Applicative)instance, (entityId, ox, oy, oz) -> new CEFollowParticleOptions(type, (int)entityId, new Vec3(ox.doubleValue(), oy.doubleValue(), oz.doubleValue()))));
    }
}

