/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shelmarow.combat_evolution.client.execution.HUDTypeManager;
import net.shelmarow.combat_evolution.config.ClientConfig;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class CombatEvolutionConfigScreen
extends Screen {
    private final Screen parent;
    private EditBox inputBox;
    private Button textDisplayButton;
    private boolean showTextDisplayState;
    private final List<String> allHUDTypes = new ArrayList<String>();
    private final List<String> suggestions = new ArrayList<String>();
    private int selectedSuggestion = -1;
    private int suggestionBoxX;
    private int suggestionBoxY;
    private int suggestionBoxW;
    private final int suggestionLineHeight = 12;

    public CombatEvolutionConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Combat Evolution Config"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.allHUDTypes.clear();
        this.allHUDTypes.addAll(HUDTypeManager.getAllHUDTypes().stream().map(ResourceLocation::toString).distinct().toList());
        this.inputBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 80, 200, 20, (Component)Component.m_237113_((String)"HUD Type"));
        this.inputBox.m_94144_((String)ClientConfig.HUD_TYPE.get());
        this.inputBox.m_94151_(this::updateSuggestions);
        this.m_142416_((GuiEventListener)this.inputBox);
        this.showTextDisplayState = (Boolean)ClientConfig.SHOW_TEXT_DISPLAY.get();
        this.textDisplayButton = Button.m_253074_((Component)Component.m_237113_((String)(this.showTextDisplayState ? "on" : "off")), b -> {
            this.showTextDisplayState = !this.showTextDisplayState;
            this.textDisplayButton.m_93666_((Component)Component.m_237113_((String)(this.showTextDisplayState ? "on" : "off")));
        }).m_252987_(this.f_96543_ / 2 - 100, 120, 200, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.textDisplayButton);
        Button saveButton = Button.m_253074_((Component)Component.m_237113_((String)"Save"), b -> this.saveAndClose()).m_252987_(this.f_96543_ / 2 - 40, this.f_96544_ - 40, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)saveButton);
    }

    private void saveAndClose() {
        String valueToSave;
        String selected = this.inputBox.m_94155_();
        if (selected.isEmpty() || !this.allHUDTypes.contains(selected)) {
            String defaultValue = "combat_evolution:default";
            valueToSave = !this.allHUDTypes.isEmpty() && this.allHUDTypes.contains(defaultValue) ? defaultValue : (!this.allHUDTypes.isEmpty() ? this.allHUDTypes.get(0) : defaultValue);
            this.inputBox.m_94144_(valueToSave);
        } else {
            valueToSave = selected;
        }
        ClientConfig.HUD_TYPE.set((Object)valueToSave);
        ClientConfig.SHOW_TEXT_DISPLAY.set((Object)this.showTextDisplayState);
        ClientConfig.CLIENT_SPEC.save();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }

    private void updateSuggestions(String currentText) {
        this.suggestions.clear();
        if (currentText.isEmpty()) {
            return;
        }
        String lower = currentText.toLowerCase(Locale.ROOT);
        for (String type : this.allHUDTypes) {
            if (!type.toLowerCase(Locale.ROOT).contains(lower)) continue;
            this.suggestions.add(type);
        }
        if (this.suggestions.size() > 8) {
            this.suggestions.subList(8, this.suggestions.size()).clear();
        }
        this.selectedSuggestion = -1;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.suggestions.isEmpty()) {
            switch (keyCode) {
                case 264: {
                    this.selectedSuggestion = (this.selectedSuggestion + 1) % this.suggestions.size();
                    return true;
                }
                case 265: {
                    this.selectedSuggestion = (this.selectedSuggestion - 1 + this.suggestions.size()) % this.suggestions.size();
                    return true;
                }
                case 257: 
                case 335: {
                    if (this.selectedSuggestion < 0 || this.selectedSuggestion >= this.suggestions.size()) break;
                    this.inputBox.m_94144_(this.suggestions.get(this.selectedSuggestion));
                    this.suggestions.clear();
                    this.selectedSuggestion = -1;
                    return true;
                }
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers) || this.inputBox.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (!this.suggestions.isEmpty()) {
            int x = this.suggestionBoxX;
            int y = this.suggestionBoxY;
            int w = this.suggestionBoxW;
            int h = 12 * this.suggestions.size() + 4;
            if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h)) {
                int relativeY = (int)mouseY - y - 2;
                int idx = relativeY / 12;
                if (idx >= 0 && idx < this.suggestions.size()) {
                    this.selectedSuggestion = idx;
                }
            } else {
                this.selectedSuggestion = -1;
            }
        }
        super.m_94757_(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && !this.suggestions.isEmpty()) {
            int relativeY;
            int idx;
            int x = this.suggestionBoxX;
            int y = this.suggestionBoxY;
            int w = this.suggestionBoxW;
            int h = 12 * this.suggestions.size() + 4;
            if (mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h) && (idx = (relativeY = (int)mouseY - y - 2) / 12) >= 0 && idx < this.suggestions.size()) {
                this.inputBox.m_94144_(this.suggestions.get(idx));
                this.suggestions.clear();
                this.selectedSuggestion = -1;
                return true;
            }
        }
        this.suggestions.clear();
        this.selectedSuggestion = -1;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.inputBox.m_5534_(codePoint, modifiers);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.m_280137_(this.f_96547_, "Combat Evolution Config", this.f_96543_ / 2, 30, 0xFFFFFF);
        String hudType = "HUD Type:";
        guiGraphics.m_280488_(this.f_96547_, hudType, this.inputBox.m_252754_() - this.f_96547_.m_92895_(hudType) - 10, this.inputBox.m_252907_() + 6, 0xA0A0A0);
        String showTip = "Text Display:";
        guiGraphics.m_280488_(this.f_96547_, showTip, this.textDisplayButton.m_252754_() - this.f_96547_.m_92895_(showTip) - 10, this.textDisplayButton.m_252907_() + 6, 0xA0A0A0);
        if (!this.suggestions.isEmpty()) {
            int x = this.inputBox.m_252754_();
            int y = this.inputBox.m_252907_() + this.inputBox.m_93694_() + 2;
            int w = this.inputBox.m_5711_();
            int lineHeight = 12;
            this.suggestionBoxX = x;
            this.suggestionBoxY = y;
            this.suggestionBoxW = w;
            RenderSystem.enableBlend();
            guiGraphics.m_280509_(x, y, x + w, y + lineHeight * this.suggestions.size() + 4, -1072689136);
            for (int i = 0; i < this.suggestions.size(); ++i) {
                int color = i == this.selectedSuggestion ? 0xFFFFA0 : 0xFFFFFF;
                guiGraphics.m_280488_(this.f_96547_, this.suggestions.get(i), x + 4, y + 2 + i * lineHeight, color);
            }
            RenderSystem.disableBlend();
        }
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }
}

