/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.client.bossbar;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ClientBossData {
    private static final Map<UUID, BossData> BOSS_DATA_MAP = new ConcurrentHashMap<UUID, BossData>();

    public static BossData getBossData(UUID bossId) {
        return BOSS_DATA_MAP.computeIfAbsent(bossId, k -> new BossData());
    }

    public static void removeBoss(UUID bossId) {
        BOSS_DATA_MAP.remove(bossId);
    }

    public static void updateData(UUID bossId, BossData bossData) {
        BOSS_DATA_MAP.put(bossId, bossData);
    }

    public static void partialUpdate(UUID bossId, BossDataUpdater updater) {
        BossData data = ClientBossData.getBossData(bossId);
        updater.update(data);
    }

    public static Component getDisplayType(UUID bossId) {
        return ClientBossData.getBossData((UUID)bossId).displayType;
    }

    public static float getStamina(UUID bossId) {
        return ClientBossData.getBossData((UUID)bossId).stamina;
    }

    public static float getStaminaProgress(BossData data) {
        long elapsed = Util.m_137550_() - data.staminaSetTime;
        float t = Mth.m_14036_((float)((float)elapsed / 100.0f), (float)0.0f, (float)1.0f);
        return Mth.m_14179_((float)t, (float)data.staminaO, (float)data.stamina);
    }

    public static class BossData {
        public Component displayType = Component.m_237119_();
        public float stamina = 1.0f;
        public float staminaO = 1.0f;
        public long staminaSetTime = 0L;
    }

    @FunctionalInterface
    public static interface BossDataUpdater {
        public void update(BossData var1);
    }
}

