/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.ai;

import java.util.function.Consumer;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class TimeEvent {
    private boolean available = true;
    private final float timeStart;
    private final float timeEnd;
    private final EventType eventType;
    private final Consumer<MobPatch<?>> behavior;

    public TimeEvent(Consumer<MobPatch<?>> behavior) {
        this.timeStart = 0.0f;
        this.timeEnd = 0.0f;
        this.behavior = behavior;
        this.eventType = EventType.TICK;
    }

    public TimeEvent(float time, Consumer<MobPatch<?>> behavior) {
        this.timeStart = time;
        this.timeEnd = time;
        this.behavior = behavior;
        this.eventType = EventType.IN_TIME;
    }

    public TimeEvent(float timeStart, float timeEnd, Consumer<MobPatch<?>> behavior) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.behavior = behavior;
        this.eventType = EventType.BETWEEN_TIMES;
    }

    public void executeIfAvailable(float preTime, float currenTime, MobPatch<?> mobPatch) {
        switch (this.eventType) {
            case TICK: {
                if (!this.available) break;
                this.behavior.accept(mobPatch);
                break;
            }
            case IN_TIME: {
                if (!this.available || !(preTime >= this.timeStart) || !(this.timeStart <= currenTime)) break;
                this.behavior.accept(mobPatch);
                this.available = false;
                break;
            }
            case BETWEEN_TIMES: {
                if (!this.available || !(preTime >= this.timeStart && this.timeStart <= currenTime) && (!(preTime >= this.timeEnd) || !(this.timeEnd <= currenTime))) break;
                this.behavior.accept(mobPatch);
            }
        }
    }

    public void resetAvailable() {
        this.available = true;
    }

    public static enum EventType {
        TICK,
        IN_TIME,
        BETWEEN_TIMES;

    }
}

