/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.ai;

import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.shelmarow.combat_evolution.iml.ILivingEntityData;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class CommonChasingGoal
extends Goal {
    protected final MobPatch<? extends PathfinderMob> mobpatch;
    protected final Mob mob;
    protected final double attackRadius;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int failedPathFindingPenalty = 0;
    private final boolean canPenalize = false;
    private long lastCanUseCheck;

    public CommonChasingGoal(MobPatch<? extends PathfinderMob> mobpatch) {
        this(mobpatch, 0.0);
    }

    public CommonChasingGoal(MobPatch<? extends PathfinderMob> mobpatch, double attackRadius) {
        this.mobpatch = mobpatch;
        this.mob = (Mob)mobpatch.getOriginal();
        this.attackRadius = attackRadius;
        this.speedModifier = 1.0;
        this.followingTargetEvenIfNotSeen = false;
    }

    public boolean m_8036_() {
        if (this.mobpatch.getEntityState().inaction()) {
            return false;
        }
        long i = this.mob.m_9236_().m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        Objects.requireNonNull(this);
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        if (this.mobpatch.getEntityState().inaction()) {
            return false;
        }
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        ILivingEntityData entityData = (ILivingEntityData)this.mobpatch;
        if (livingentity != null) {
            double dd0 = this.attackRadius * this.attackRadius;
            double dd1 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
            if (entityData.combat_evolution$isGuard((LivingEntity)this.mobpatch.getOriginal())) {
                dd0 = 4.0;
            }
            if (dd1 <= dd0 || entityData.combat_evolution$isWander((LivingEntity)this.mobpatch.getOriginal())) {
                this.mob.m_21573_().m_26573_();
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                this.mobpatch.rotateTo((Entity)livingentity, 30.0f, true);
            } else if (!this.mobpatch.getEntityState().inaction()) {
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                double distance = ((PathfinderMob)this.mobpatch.getOriginal()).m_20270_((Entity)livingentity);
                if (distance < this.attackRadius) {
                    ((PathfinderMob)this.mobpatch.getOriginal()).m_21573_().m_26573_();
                } else {
                    double d0 = this.mob.m_262793_(livingentity);
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                        this.pathedTargetX = livingentity.m_20185_();
                        this.pathedTargetY = livingentity.m_20186_();
                        this.pathedTargetZ = livingentity.m_20189_();
                        this.ticksUntilNextPathRecalculation = 20;
                        Objects.requireNonNull(this);
                        if (d0 > 1024.0) {
                            this.ticksUntilNextPathRecalculation += 10;
                        } else if (d0 > 256.0) {
                            this.ticksUntilNextPathRecalculation += 5;
                        }
                        if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                            this.ticksUntilNextPathRecalculation += 15;
                        }
                        this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                    }
                }
            }
        }
    }

    protected double getAttackReachSqr(LivingEntity pAttackTarget) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + pAttackTarget.m_20205_();
    }
}

