/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.ai;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.shelmarow.combat_evolution.ai.BehaviorUtils;
import net.shelmarow.combat_evolution.ai.CEAnimationAttackGoal;
import net.shelmarow.combat_evolution.ai.CECombatBehaviors;
import net.shelmarow.combat_evolution.ai.CommonChasingGoal;
import net.shelmarow.combat_evolution.ai.DefaultCombatBehavior;
import net.shelmarow.combat_evolution.ai.StaminaStatus;
import net.shelmarow.combat_evolution.effect.CEMobEffects;
import net.shelmarow.combat_evolution.iml.ILivingEntityData;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public abstract class CEHumanoidPatch
extends MobPatch<PathfinderMob> {
    protected final Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>> weaponLivingMotions = new HashMap<WeaponCategory, Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>>();
    protected final Map<WeaponCategory, Map<Style, List<AnimationManager.AnimationAccessor<? extends StaticAnimation>>>> guardHitMotions = new HashMap<WeaponCategory, Map<Style, List<AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>();
    protected final Map<WeaponCategory, Map<Style, CECombatBehaviors.Builder<MobPatch<?>>>> weaponAttackMotions = new HashMap();
    protected int breakTime = 40;
    protected int recoverTime = 60;
    protected int recoverTickCount = 0;
    protected int lastActionTime = 0;
    protected int staminaRegenDelay = 60;
    protected int attackRadius = 1;

    public CEHumanoidPatch(Factions factions) {
        super((Faction)factions);
        this.setWeaponMotions();
    }

    public void initAI() {
        super.initAI();
        this.setAIAsInfantry();
        ILivingEntityData entityData = (ILivingEntityData)((Object)this);
        float maxStamina = 15.0f;
        if (((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get()) != null) {
            maxStamina = (float)((PathfinderMob)this.original).m_21133_((Attribute)EpicFightAttributes.MAX_STAMINA.get());
        }
        entityData.combat_evolution$setStamina((LivingEntity)this.original, maxStamina);
    }

    protected void selectGoalToRemove(Set<Goal> toRemove) {
        for (WrappedGoal wrappedGoal : ((PathfinderMob)this.original).f_21345_.m_148105_()) {
            Goal goal = wrappedGoal.m_26015_();
            if (!(goal instanceof MeleeAttackGoal) && !(goal instanceof AnimatedAttackGoal) && !(goal instanceof CEAnimationAttackGoal) && !(goal instanceof RangedAttackGoal) && !(goal instanceof TargetChasingGoal) && !(goal instanceof CommonChasingGoal)) continue;
            toRemove.add(goal);
        }
    }

    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, (AssetAccessor)Animations.BIPED_IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, (AssetAccessor)Animations.BIPED_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.CHASE, (AssetAccessor)Animations.BIPED_WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.FALL, (AssetAccessor)Animations.BIPED_FALL);
        animator.addLivingAnimation((LivingMotion)LivingMotions.MOUNT, (AssetAccessor)Animations.BIPED_MOUNT);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, (AssetAccessor)Animations.BIPED_DEATH);
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        CEHumanoidPatch cEHumanoidPatch = this;
        if (cEHumanoidPatch instanceof ILivingEntityData) {
            ILivingEntityData entityData = (ILivingEntityData)((Object)cEHumanoidPatch);
            float maxStamina = 15.0f;
            if (((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get()) != null) {
                maxStamina = (float)((PathfinderMob)this.original).m_21133_((Attribute)EpicFightAttributes.MAX_STAMINA.get());
            }
            float currentStamina = entityData.combat_evolution$getStamina((LivingEntity)this.original);
            StaminaStatus staminaStatus = entityData.combat_evolution$getStaminaStatus((LivingEntity)this.original);
            if (staminaStatus == StaminaStatus.COMMON) {
                if (this.recoverTickCount != 0) {
                    this.recoverTickCount = 0;
                }
                if (currentStamina <= 0.0f) {
                    entityData.combat_evolution$setStaminaStatus((LivingEntity)this.original, StaminaStatus.BREAK);
                } else if (((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.STAMINA_REGEN.get()) != null) {
                    if (this.state.inaction() || entityData.combat_evolution$isGuard((LivingEntity)this.original)) {
                        this.lastActionTime = ((PathfinderMob)this.original).f_19797_;
                    } else if (((PathfinderMob)this.original).f_19797_ - this.lastActionTime > this.staminaRegenDelay && currentStamina < maxStamina) {
                        float regenSpeed = (float)((PathfinderMob)this.original).m_21133_((Attribute)EpicFightAttributes.STAMINA_REGEN.get());
                        entityData.combat_evolution$setStamina((LivingEntity)this.original, currentStamina + maxStamina * 0.01f * regenSpeed);
                    }
                }
            } else {
                ++this.recoverTickCount;
                if (staminaStatus == StaminaStatus.BREAK) {
                    if (this.recoverTickCount >= this.breakTime) {
                        entityData.combat_evolution$setStaminaStatus((LivingEntity)this.original, StaminaStatus.RECOVER);
                    }
                } else if (staminaStatus == StaminaStatus.RECOVER) {
                    float progress = Mth.m_14036_((float)((float)(this.recoverTickCount - this.breakTime) / (float)this.recoverTime), (float)0.0f, (float)1.0f);
                    currentStamina = Mth.m_14179_((float)progress, (float)0.0f, (float)maxStamina);
                    entityData.combat_evolution$setStamina((LivingEntity)this.original, currentStamina);
                    if (progress == 1.0f) {
                        entityData.combat_evolution$setStaminaStatus((LivingEntity)this.original, StaminaStatus.COMMON);
                    }
                }
            }
            AttributeInstance instance = ((PathfinderMob)this.original).m_21051_(Attributes.f_22279_);
            AttributeModifier modifier = new AttributeModifier(UUID.fromString("086f00c3-2763-463e-a64e-b19c8959d4bd"), "guard_move_speed", -0.45, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (instance != null) {
                if (entityData.combat_evolution$isGuard((LivingEntity)this.original)) {
                    if (!instance.m_22109_(modifier)) {
                        instance.m_22125_(modifier);
                    }
                } else if (instance.m_22109_(modifier)) {
                    instance.m_22130_(modifier);
                }
            }
        }
        ((PathfinderMob)this.original).f_21345_.m_148105_().stream().filter(g -> g.m_26015_() instanceof CEAnimationAttackGoal).forEach(g -> {
            CEAnimationAttackGoal goal = (CEAnimationAttackGoal)g.m_26015_();
            AssetAccessor animation = Objects.requireNonNull(this.getAnimator().getPlayerFor(null)).getAnimation();
            for (StunType stunType : StunType.values()) {
                if (stunType == StunType.NONE || this.getHitAnimation(stunType) != animation) continue;
                goal.interruptByStun(stunType);
            }
        });
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        AttackResult result = super.tryHurt(damageSource, amount);
        if (damageSource.m_7640_() != null && result.resultType == AttackResult.ResultType.SUCCESS) {
            ILivingEntityData entityData = (ILivingEntityData)((Object)this);
            if (entityData.combat_evolution$isGuard((LivingEntity)this.original) && this.isBlockableSource(damageSource) && !this.isStunned()) {
                if (!entityData.combat_evolution$isInCounter((LivingEntity)this.original)) {
                    this.onGuardHit(damageSource);
                }
                return AttackResult.blocked((float)0.0f);
            }
            this.onCommonHurt(damageSource);
        }
        return result;
    }

    public boolean isBlockableSource(DamageSource damageSource) {
        return !damageSource.m_269533_(EpicFightDamageTypeTags.UNBLOCKALBE) && !damageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE);
    }

    public void onCommonHurt(DamageSource damageSource) {
        EpicFightDamageSource efSource;
        EpicFightDamageSource epicFightDamageSource = efSource = damageSource instanceof EpicFightDamageSource ? (EpicFightDamageSource)damageSource : null;
        if (!((PathfinderMob)this.original).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get()) && !((PathfinderMob)this.original).m_21023_((MobEffect)CEMobEffects.FULL_STUN_IMMUNITY.get())) {
            float hurtImpactPercent = this.getHurtImpactPercent(damageSource);
            float impact = 0.5f * hurtImpactPercent;
            if (efSource != null) {
                impact = efSource.calculateImpact() * hurtImpactPercent;
            }
            this.dealStaminaDamage(damageSource, impact);
        }
    }

    public void onGuardHit(DamageSource damageSource) {
        EpicFightDamageSource efSource = damageSource instanceof EpicFightDamageSource ? (EpicFightDamageSource)damageSource : null;
        float impact = 0.5f;
        if (efSource != null) {
            impact = efSource.calculateImpact();
        }
        if (!this.dealStaminaDamage(damageSource, impact)) {
            if (damageSource.m_7640_() != null) {
                this.knockBackEntity(damageSource.m_7640_().m_20182_(), 0.15f);
            }
            boolean canCounter = BehaviorUtils.onGuardHit(this);
            AnimationManager.AnimationAccessor<? extends StaticAnimation> guardHit = this.getGuardHitAnimation(damageSource);
            this.playAnimationSynchronized((AssetAccessor)guardHit, 0.0f, SPAnimatorControl::new);
            this.playGuardHitSound();
        }
    }

    public boolean dealStaminaDamage(DamageSource damageSource, float amount) {
        ILivingEntityData entityData = (ILivingEntityData)((Object)this);
        if (entityData.combat_evolution$getStaminaStatus((LivingEntity)this.original) == StaminaStatus.COMMON) {
            float stamina = entityData.combat_evolution$getStamina((LivingEntity)this.original);
            entityData.combat_evolution$setStamina((LivingEntity)this.original, stamina - amount);
            if (amount >= stamina) {
                this.onBreak(damageSource);
                return true;
            }
        }
        return false;
    }

    public void onBreak(DamageSource damageSource) {
        EpicFightDamageSource efSource;
        EpicFightDamageSource epicFightDamageSource = efSource = damageSource instanceof EpicFightDamageSource ? (EpicFightDamageSource)damageSource : null;
        if (efSource != null) {
            efSource.setStunType(StunType.NONE);
            Vec3 sourcePosition = efSource.getInitialPosition();
            if (sourcePosition != null) {
                ((PathfinderMob)this.original).m_7618_(EntityAnchorArgument.Anchor.FEET, sourcePosition);
            }
        }
        this.applyStun(StunType.NEUTRALIZE, 0.0f);
        ((PathfinderMob)this.original).m_147215_(new MobEffectInstance((MobEffect)CEMobEffects.FULL_STUN_IMMUNITY.get(), 100), this.original);
        Vec3 eyePosition = ((PathfinderMob)this.original).m_146892_();
        Vec3 viewVec = ((PathfinderMob)this.original).m_20154_().m_82490_(2.0);
        Vec3 pos = new Vec3(eyePosition.f_82479_ + viewVec.f_82479_, eyePosition.f_82480_ + viewVec.f_82480_, eyePosition.f_82481_ + viewVec.f_82481_);
        ((PathfinderMob)this.getOriginal()).m_9236_().m_7106_((ParticleOptions)EpicFightParticles.NEUTRALIZE.get(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        this.playGuardBreakSound();
    }

    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> blocker) {
    }

    public void onAttackParried(DamageSource damageSource, LivingEntityPatch<?> blocker) {
    }

    public void playGuardBreakSound() {
        this.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 1.0f, 1.0f);
    }

    public void playGuardHitSound() {
        this.playSound((SoundEvent)EpicFightSounds.CLASH.get(), 1.0f, 1.0f);
    }

    public float getHurtImpactPercent(DamageSource damageSource) {
        return 0.35f;
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardHitAnimation(DamageSource damageSource) {
        CapabilityItem capabilityItem = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        WeaponCategory category = capabilityItem.getWeaponCategory();
        Style style = capabilityItem.getStyle((LivingEntityPatch)this);
        AnimationManager.AnimationAccessor<? extends StaticAnimation> guardHit = Animations.EMPTY_ANIMATION;
        if (this.guardHitMotions.get(category) != null && !this.guardHitMotions.get(category).isEmpty()) {
            int index = ((PathfinderMob)this.original).m_217043_().m_216339_(0, this.guardHitMotions.get(category).get(style).size());
            guardHit = this.guardHitMotions.get(category).get(style).get(index);
        }
        return guardHit;
    }

    protected abstract void setWeaponMotions();

    protected CECombatBehaviors.Builder<MobPatch<?>> getCustomWeaponMotionBuilder() {
        Style style;
        Map<Style, CECombatBehaviors.Builder<MobPatch<?>>> motionByStyle;
        CapabilityItem itemCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        if (this.weaponAttackMotions.containsKey(itemCap.getWeaponCategory()) && ((motionByStyle = this.weaponAttackMotions.get(itemCap.getWeaponCategory())).containsKey(style = itemCap.getStyle((LivingEntityPatch)this)) || motionByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            return motionByStyle.getOrDefault(style, motionByStyle.get(CapabilityItem.Styles.COMMON));
        }
        return DefaultCombatBehavior.FIST;
    }

    public void setAIAsInfantry() {
        CECombatBehaviors.Builder<MobPatch<?>> builder = this.getCustomWeaponMotionBuilder();
        if (builder != null) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new CEAnimationAttackGoal(this, this.getCustomWeaponMotionBuilder().build()));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, (Goal)new CommonChasingGoal(this, this.attackRadius));
        }
    }

    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((PathfinderMob)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((PathfinderMob)this.original).m_20202_() != null ? LivingMotions.MOUNT : (!(((PathfinderMob)this.original).m_20184_().f_82480_ < (double)-0.55f) && !this.isAirborneState() ? (((PathfinderMob)this.original).f_267362_.m_267731_() > 0.08f && (double)((PathfinderMob)this.original).f_267362_.m_267731_() <= 0.72 ? LivingMotions.WALK : ((double)((PathfinderMob)this.original).f_267362_.m_267731_() > 0.72 ? (((PathfinderMob)this.original).m_5912_() ? LivingMotions.CHASE : LivingMotions.RUN) : LivingMotions.IDLE)) : LivingMotions.FALL)));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        super.initAI();
        this.setAIAsInfantry();
        if (hand == InteractionHand.OFF_HAND) {
            if (!from.m_41619_()) {
                from.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get()))).m_22130_(arg_0));
            }
            if (!fromCap.isEmpty()) {
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, (LivingEntityPatch)this).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get()))).m_22130_(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, (LivingEntityPatch)this).get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()))).m_22130_(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, (LivingEntityPatch)this).get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get()))).m_22130_(arg_0));
                fromCap.getAttributeModifiers(EquipmentSlot.MAINHAND, (LivingEntityPatch)this).get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()))).m_22130_(arg_0));
            }
            if (!to.m_41619_()) {
                to.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get()))).m_22118_(arg_0));
            }
            if (!toCap.isEmpty()) {
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, (LivingEntityPatch)this).get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()))).m_22118_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, (LivingEntityPatch)this).get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()))).m_22118_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, (LivingEntityPatch)this).get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get()))).m_22118_(arg_0));
                toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, (LivingEntityPatch)this).get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)Objects.requireNonNull(((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()))).m_22118_(arg_0));
            }
        }
        this.modifyLivingMotionByCurrentItem();
        super.updateHeldItem(fromCap, toCap, from, to, hand);
    }

    public void modifyLivingMotionByCurrentItem() {
        Style style;
        Object byStyle;
        Map oldLivingAnimations = this.getAnimator().getLivingAnimations();
        HashMap newLivingAnimations = Maps.newHashMap();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        HashMap livingMotionModifiers = new HashMap(mainhandCap.getLivingMotionModifier((LivingEntityPatch)this, InteractionHand.MAIN_HAND));
        livingMotionModifiers.putAll(offhandCap.getLivingMotionModifier((LivingEntityPatch)this, InteractionHand.OFF_HAND));
        boolean hasChange = false;
        for (Map.Entry entry : livingMotionModifiers.entrySet()) {
            AssetAccessor aniamtion = (AssetAccessor)entry.getValue();
            if (!oldLivingAnimations.containsKey(entry.getKey())) {
                hasChange = true;
            } else if (oldLivingAnimations.get(entry.getKey()) != aniamtion) {
                hasChange = true;
            }
            newLivingAnimations.put((LivingMotion)entry.getKey(), aniamtion);
        }
        if (this.weaponLivingMotions.containsKey(mainhandCap.getWeaponCategory()) && ((byStyle = this.weaponLivingMotions.get(mainhandCap.getWeaponCategory())).containsKey(style = mainhandCap.getStyle((LivingEntityPatch)this)) || byStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            Set animModifierSet = byStyle.getOrDefault(style, (Set)byStyle.get(CapabilityItem.Styles.COMMON));
            for (Pair pair : animModifierSet) {
                newLivingAnimations.put((LivingMotion)pair.getFirst(), (AssetAccessor)pair.getSecond());
            }
        }
        if (!hasChange) {
            for (LivingMotion oldLivingMotion : oldLivingAnimations.keySet()) {
                if (newLivingAnimations.containsKey(oldLivingMotion)) continue;
                hasChange = true;
                break;
            }
        }
        if (hasChange) {
            this.getAnimator().resetLivingAnimations();
            newLivingAnimations.forEach((arg_0, arg_1) -> ((Animator)this.getAnimator()).addLivingAnimation(arg_0, arg_1));
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((PathfinderMob)this.original).m_19879_());
            msg.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)msg, (Entity)this.original, (Object[])new Object[0]);
        }
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        switch (stunType) {
            case LONG: {
                return Animations.BIPED_HIT_LONG;
            }
            case SHORT: 
            case HOLD: {
                return Animations.BIPED_HIT_SHORT;
            }
            case KNOCKDOWN: {
                return Animations.BIPED_KNOCKDOWN;
            }
            case NEUTRALIZE: {
                return Animations.BIPED_COMMON_NEUTRALIZED;
            }
            case FALL: {
                return Animations.BIPED_LANDING;
            }
        }
        return null;
    }
}

