/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.ai;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.shelmarow.combat_evolution.ai.CECombatBehaviors;
import net.shelmarow.combat_evolution.iml.ILivingEntityData;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class CEAnimationAttackGoal<T extends MobPatch<?>>
extends Goal {
    protected final T mobpatch;
    protected final CECombatBehaviors<T> combatBehaviors;
    protected boolean actionStoped = false;

    public CEAnimationAttackGoal(T mobpatch, CECombatBehaviors<T> combatBehaviors) {
        this.mobpatch = mobpatch;
        this.combatBehaviors = combatBehaviors;
    }

    public boolean m_8036_() {
        this.actionStoped = this.combatBehaviors.getCurrentBehavior() != null && !this.mobpatch.getEntityState().inaction();
        return this.checkTargetValid() || this.actionStoped;
    }

    public CECombatBehaviors<T> getCombatBehaviors() {
        return this.combatBehaviors;
    }

    public void interruptByStun(StunType stunType) {
        CECombatBehaviors.Behavior<T> currentBehavior = this.combatBehaviors.getCurrentBehavior();
        if (currentBehavior != null && currentBehavior.stopByStun(stunType)) {
            this.clearCurrentBehavior(currentBehavior);
        }
    }

    public void clearCurrentBehavior(CECombatBehaviors.Behavior<?> currentBehavior) {
        currentBehavior.behaviorFinished();
        currentBehavior.resetCooldown();
        this.combatBehaviors.clearCurrentBehavior();
        ILivingEntityData entityData = (ILivingEntityData)this.mobpatch;
        entityData.combat_evolution$setWander((LivingEntity)this.mobpatch.getOriginal(), false);
        entityData.combat_evolution$setGuard((LivingEntity)this.mobpatch.getOriginal(), false);
        entityData.combat_evolution$setInCounter((LivingEntity)this.mobpatch.getOriginal(), false);
    }

    public void m_8037_() {
        CECombatBehaviors.Behavior<T> currentBehavior = this.combatBehaviors.getCurrentBehavior();
        if (this.mobpatch.getTarget() == null) {
            if (currentBehavior != null) {
                this.clearCurrentBehavior(currentBehavior);
            }
        } else {
            this.combatBehaviors.tick(this.mobpatch);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    protected boolean checkTargetValid() {
        LivingEntity livingentity = this.mobpatch.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (livingentity instanceof Player) {
            Player player = (Player)livingentity;
            return !livingentity.m_5833_() && !player.m_7500_();
        }
        return true;
    }
}

