/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.ai;

import java.util.Objects;
import java.util.Set;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.shelmarow.combat_evolution.ai.CEAnimationAttackGoal;
import net.shelmarow.combat_evolution.ai.CECombatBehaviors;
import net.shelmarow.combat_evolution.ai.CEHumanoidPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class BehaviorUtils {
    public static CECombatBehaviors<?> getCECombatBehaviors(LivingEntityPatch<?> entityPatch) {
        if (entityPatch == null || entityPatch.getOriginal() == null) {
            return null;
        }
        if (entityPatch.isInitialized() && entityPatch instanceof CEHumanoidPatch) {
            CEHumanoidPatch ceHumanoidPatch = (CEHumanoidPatch)entityPatch;
            return ((PathfinderMob)ceHumanoidPatch.getOriginal()).f_21345_.m_148105_().stream().filter(g -> g.m_26015_() instanceof CEAnimationAttackGoal).map(g -> ((CEAnimationAttackGoal)g.m_26015_()).getCombatBehaviors()).findFirst().orElse(null);
        }
        return null;
    }

    public static CECombatBehaviors.Behavior<?> getCurrentBehavior(LivingEntityPatch<?> entityPatch) {
        if (entityPatch == null || entityPatch.getOriginal() == null) {
            return null;
        }
        if (entityPatch.isInitialized() && entityPatch instanceof CEHumanoidPatch) {
            CEHumanoidPatch ceHumanoidPatch = (CEHumanoidPatch)entityPatch;
            return ((PathfinderMob)ceHumanoidPatch.getOriginal()).f_21345_.m_148105_().stream().filter(g -> g.m_26015_() instanceof CEAnimationAttackGoal).map(g -> ((CEAnimationAttackGoal)g.m_26015_()).getCombatBehaviors()).filter(Objects::nonNull).map(CECombatBehaviors::getCurrentBehavior).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    public static boolean onGuardHit(LivingEntityPatch<?> entityPatch) {
        CECombatBehaviors.Behavior<?> b = BehaviorUtils.getCurrentBehavior(entityPatch);
        if (b != null) {
            return b.whenGuardHit();
        }
        return false;
    }

    public static void stopCurrentBehavior(LivingEntity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.f_21345_.m_148105_().stream().filter(goal -> goal.m_26015_() instanceof CEAnimationAttackGoal).forEach(goal -> {
                CEAnimationAttackGoal animationAttackGoal;
                CECombatBehaviors.Behavior behavior;
                Goal patt2409$temp = goal.m_26015_();
                if (patt2409$temp instanceof CEAnimationAttackGoal && (behavior = (animationAttackGoal = (CEAnimationAttackGoal)patt2409$temp).getCombatBehaviors().getCurrentBehavior()) != null) {
                    animationAttackGoal.clearCurrentBehavior(behavior);
                }
            });
        }
    }

    public static Set<TagKey<DamageType>> getSourceTagSet(LivingEntityPatch<?> entitypatch) {
        CECombatBehaviors.Behavior<?> current = BehaviorUtils.getCurrentBehavior(entitypatch);
        return current != null ? current.getSourceTagSet() : Set.of();
    }
}

