/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.combat_evolution.ai;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import yesman.epicfight.world.damagesource.StunType;

public class AnimationParams {
    private float transitionTime = 0.0f;
    private boolean shouldChangeSpeed = false;
    private float attackSpeed = 1.0f;
    private float damageMultiplier = 1.0f;
    private float impactMultiplier = 1.0f;
    private float armorNegationMultiplier = 1.0f;
    private int stunType = -1;
    private final Set<TagKey<DamageType>> damageSource = new HashSet<TagKey<DamageType>>();

    public AnimationParams transitionTime(float t) {
        this.transitionTime = t;
        return this;
    }

    public void setShouldChangeSpeed(boolean shouldChangeSpeed) {
        this.shouldChangeSpeed = shouldChangeSpeed;
    }

    public boolean shouldChangeSpeed() {
        return this.shouldChangeSpeed;
    }

    public AnimationParams playSpeed(float attackSpeed) {
        this.attackSpeed = attackSpeed;
        this.setShouldChangeSpeed(true);
        return this;
    }

    public AnimationParams damageMultiplier(float multiplier) {
        this.damageMultiplier = multiplier;
        return this;
    }

    public AnimationParams impactMultiplier(float multiplier) {
        this.impactMultiplier = multiplier;
        return this;
    }

    public AnimationParams armorNegationMultiplier(float multiplier) {
        this.armorNegationMultiplier = multiplier;
        return this;
    }

    public AnimationParams stunType(StunType stunType) {
        this.stunType = stunType.ordinal();
        return this;
    }

    public AnimationParams damageSource(Set<TagKey<DamageType>> damageSource) {
        this.damageSource.addAll(damageSource);
        return this;
    }

    public float getTransitionTime() {
        return this.transitionTime;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public float getImpactMultiplier() {
        return this.impactMultiplier;
    }

    public float getArmorNegationMultiplier() {
        return this.armorNegationMultiplier;
    }

    public int getStunType() {
        return this.stunType;
    }

    public Set<TagKey<DamageType>> getDamageSource() {
        return this.damageSource;
    }
}

