/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.mixinbooster;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.sinytra.mixinbooster.Constants;
import org.sinytra.mixinbooster.DummyMixinTransformationService;
import org.sinytra.mixinbooster.GeneratedMixinClassesSecureJar;
import org.sinytra.mixinbooster.InstrumentationHack;
import org.sinytra.mixinbooster.MixinModlauncherRemapper;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.launch.MixinLaunchPlugin;
import org.spongepowered.asm.launch.MixinLaunchPluginLegacy;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IRemapper;

public class MixinTransformationService
implements ITransformationService {
    public static final TypesafeMap.Key<Map<Class<?>, ArtifactVersion>> INSTALLED_VERSIONS = new TypesafeMap.KeyBuilder("org.sinytra.mixinbooster.installed_versions", Map.class, IEnvironment.class).get();
    public static final AtomicBoolean SHOULD_LOAD = new AtomicBoolean(false);
    private ArgumentAcceptingOptionSpec<String> mixinArgSpec;
    private List<String> capturedArgs;
    private boolean disguiseName;

    private static void replaceMixinLaunchPlugin() {
        try {
            ClassLoader classLoader = MixinTransformationService.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(classLoader);
            Field launcherLaunchPluginsField = Launcher.class.getDeclaredField("launchPlugins");
            launcherLaunchPluginsField.setAccessible(true);
            Field launchPluginHandlerPluginsField = LaunchPluginHandler.class.getDeclaredField("plugins");
            launchPluginHandlerPluginsField.setAccessible(true);
            Map plugins = (Map)launchPluginHandlerPluginsField.get(launcherLaunchPluginsField.get(Launcher.INSTANCE));
            plugins.put("mixin", new MixinLaunchPlugin());
            Constants.LOG.debug("Replaced the mixin launch plugin");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public MixinTransformationService() {
        Environment env = Launcher.INSTANCE.environment();
        Map installed = (Map)env.computePropertyIfAbsent(INSTALLED_VERSIONS, k -> Collections.synchronizedMap(new LinkedHashMap()));
        installed.put(this.getClass(), Constants.VERSION);
    }

    public String name() {
        return this.disguiseName ? "mixin" : "mixin-booster-" + this.getClass().getPackageName().replace('.', '-');
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
        this.disguiseName = true;
        this.mixinArgSpec = argumentBuilder.apply("config", "a mixin config to load").withRequiredArg().ofType(String.class);
    }

    public void argumentValues(ITransformationService.OptionResult option) {
        this.capturedArgs = option.values(this.mixinArgSpec);
        this.disguiseName = false;
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
        Map.Entry winner = ((Map)env.getProperty(INSTALLED_VERSIONS).orElseThrow()).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).findFirst().orElseThrow();
        if (winner.getKey() != this.getClass()) {
            Constants.LOG.info("Mixin Booster {} ({}) lost against version {} ({}). Skipping...", (Object)Constants.VERSION, this.getClass(), winner.getValue(), winner.getKey());
            return;
        }
        SHOULD_LOAD.set(true);
        Constants.LOG.info("Mixin Booster {} is definitely up to no good...", (Object)this.getClass().getName());
        try {
            InstrumentationHack.inject();
        }
        catch (Throwable t) {
            Constants.LOG.error("Error replacing mixin module source", t);
            throw new RuntimeException(t);
        }
        MixinTransformationService.replaceMixinLaunchPlugin();
        Constants.LOG.info("Crimes against java were committed by {}", (Object)this.getClass().getName());
        Constants.LOG.debug("onLoad called");
        Constants.LOG.debug(String.join((CharSequence)", ", otherServices));
        try {
            Field handlerField = Launcher.class.getDeclaredField("transformationServicesHandler");
            handlerField.setAccessible(true);
            Object handler = handlerField.get(Launcher.INSTANCE);
            Field serviceLookupField = handler.getClass().getDeclaredField("serviceLookup");
            serviceLookupField.setAccessible(true);
            Map serviceLookup = (Map)serviceLookupField.get(handler);
            Constructor ctr = TransformationServiceDecorator.class.getDeclaredConstructor(ITransformationService.class);
            ctr.setAccessible(true);
            TransformationServiceDecorator decorator = (TransformationServiceDecorator)ctr.newInstance(new DummyMixinTransformationService());
            Method onLoad = TransformationServiceDecorator.class.getDeclaredMethod("onLoad", IEnvironment.class, Set.class);
            onLoad.setAccessible(true);
            onLoad.invoke((Object)decorator, env, otherServices);
            serviceLookup.put("mixin", decorator);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void initialize(IEnvironment environment) {
        if (!SHOULD_LOAD.get()) {
            return;
        }
        try {
            Constants.LOG.debug("initialize called");
            Method mixinBootstrapStartMethod = MixinBootstrap.class.getDeclaredMethod("start", new Class[0]);
            mixinBootstrapStartMethod.setAccessible(true);
            Optional plugin = environment.findLaunchPlugin("mixin");
            if (plugin.isEmpty()) {
                throw new Error("Mixin Launch Plugin Service could not be located");
            }
            ILaunchPluginService launchPlugin = (ILaunchPluginService)plugin.get();
            if (!(launchPlugin instanceof MixinLaunchPluginLegacy)) {
                throw new Error("Mixin Launch Plugin Service is present but not compatible");
            }
            Method mixinPluginInitMethod = MixinLaunchPluginLegacy.class.getDeclaredMethod("init", IEnvironment.class, List.class);
            mixinPluginInitMethod.setAccessible(true);
            mixinBootstrapStartMethod.invoke(null, new Object[0]);
            mixinPluginInitMethod.invoke((Object)launchPlugin, environment, this.capturedArgs);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ITransformationService.Resource> beginScanning(IEnvironment environment) {
        if (!SHOULD_LOAD.get()) {
            return List.of();
        }
        if (!FMLEnvironment.production) {
            MixinEnvironment.getDefaultEnvironment().getRemappers().add((IRemapper)new MixinModlauncherRemapper());
        }
        return List.of(new ITransformationService.Resource(IModuleLayerManager.Layer.GAME, List.of(new GeneratedMixinClassesSecureJar())));
    }

    public List<ITransformer> transformers() {
        return List.of();
    }
}

