/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.skinlibrary;

import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIView;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.core.client.gui.widget.InputDialog;
import moe.plushie.armourers_workshop.core.data.DataEncryptMethod;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.data.SkinLibrarySetting;

public class SkinLibraryKeychainWindow {
    private final String securityData;

    public SkinLibraryKeychainWindow(String securityData) {
        this.securityData = securityData;
    }

    public void showInView(UIView view, IResultHandler<SkinFileOptions> consumer) {
        if (this.securityData.startsWith(DataEncryptMethod.PASSWORD.method() + ";")) {
            InputDialog dialog = new InputDialog();
            dialog.setTitle(NSString.localizedString("skin-library.dialog.passwordProvider.title", new Object[0]));
            dialog.setMessageColor(UIColor.of(-43691));
            dialog.setPlaceholder(NSString.localizedString("skin-library.dialog.passwordProvider.enterPassword", new Object[0]));
            dialog.setVerifier(value -> !value.isEmpty());
            dialog.showInView(view, () -> {
                if (dialog.isCancelled()) {
                    return;
                }
                String password = DataEncryptMethod.PASSWORD.key(dialog.value());
                String inputSecurityData = DataEncryptMethod.PASSWORD.signature(password);
                if (!this.securityData.equals(inputSecurityData)) {
                    consumer.abort(new TranslatableException("inventory.armourers_workshop.skin-library.error.illegalPassword", new Object[0]));
                    return;
                }
                SkinFileOptions options = new SkinFileOptions();
                options.setSecurityKey(password);
                options.setSecurityData(inputSecurityData);
                consumer.accept(options);
            });
            return;
        }
        if (this.securityData.startsWith(DataEncryptMethod.AUTH.method() + ";")) {
            SkinLibrarySetting setting = SkinLibraryManager.getClient().setting();
            if (!this.securityData.equals(setting.publicKey())) {
                consumer.abort(new TranslatableException("inventory.armourers_workshop.skin-library.error.illegalServer", new Object[0]));
                return;
            }
            SkinFileOptions options = new SkinFileOptions();
            options.setSecurityKey("");
            options.setSecurityData(this.securityData);
            consumer.accept(options);
            return;
        }
        consumer.abort(new TranslatableException("inventory.armourers_workshop.skin-library.error.illegalAlgorithm", new Object[0]));
    }
}

