/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSMutableString;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UITextField;
import com.apple.library.uikit.UITextView;
import java.util.Optional;
import java.util.function.BiConsumer;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.data.ticket.TicketManager;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.GlobalSkinLibrarySettingWindow;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.GlobalSkinLibraryWindow;
import moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary.panels.AbstractLibraryPanel;
import moe.plushie.armourers_workshop.library.data.GlobalSkinLibrary;
import moe.plushie.armourers_workshop.library.menu.GlobalSkinLibraryMenu;
import moe.plushie.armourers_workshop.library.network.UploadSkinPacket;
import moe.plushie.armourers_workshop.library.network.UploadSkinPrePacket;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.util.Strings;

@OnlyIn(value=Dist.CLIENT)
public class UploadLibraryPanel
extends AbstractLibraryPanel {
    private UILabel warningLabel;
    private UITextField textName;
    private UITextField textTags;
    private UITextView textDescription;
    private UIButton buttonUpload;
    private UICheckBox fileOptionsBox;
    private NSString error = null;
    private boolean isUploading = false;
    private final GlobalSkinLibrary library = GlobalSkinLibrary.getInstance();

    public UploadLibraryPanel() {
        super("skin-library-global.upload", GlobalSkinLibraryWindow.Page.SKIN_UPLOAD::equals);
        this.setup();
    }

    private void setup() {
        float width = this.bounds().width();
        float height = this.bounds().height();
        float inputWidth = width - 15.0f - 162.0f;
        this.textName = this.addTextField(5.0f, 15.0f, inputWidth, 16.0f, "enterName");
        this.textName.setMaxLength(80);
        this.textTags = this.addTextField(5.0f, 45.0f, inputWidth, 16.0f, "enterTags");
        this.textTags.setMaxLength(32);
        this.textDescription = this.addTextView(5.0f, 75.0f, inputWidth, height - 75.0f - 40.0f - 12.0f, "enterDescription");
        this.textDescription.setMaxLength(255);
        this.buttonUpload = this.addTextButton(28.0f, height - 28.0f, 96.0f, 18.0f, "buttonUpload", UploadLibraryPanel::upload);
        this.buttonUpload.setAutoresizingMask(8);
        this.buttonUpload.setEnabled(false);
        this.fileOptionsBox = new UICheckBox(new CGRect(5.0f, this.textDescription.frame().maxY() + 6.0f, inputWidth, 10.0f));
        this.fileOptionsBox.setTitle(this.getDisplayText("fileOptions", new Object[0]));
        this.fileOptionsBox.setTitleColor(UIColor.WHITE);
        this.fileOptionsBox.setSelected(GlobalSkinLibrarySettingWindow.hasChanges());
        this.fileOptionsBox.addTarget(this, UIControl.Event.VALUE_CHANGED, UploadLibraryPanel::changeFileOptions);
        this.fileOptionsBox.setAutoresizingMask(8);
        this.addSubview(this.fileOptionsBox);
        this.addLabel(5.0f, 5.0f, inputWidth, 10.0f, this.getDisplayText("skinName", new Object[0]));
        this.addLabel(5.0f, 35.0f, inputWidth, 10.0f, this.getDisplayText("skinTags", new Object[0]));
        this.addLabel(5.0f, 65.0f, inputWidth, 10.0f, this.getDisplayText("skinDescription", new Object[0]));
        this.warningLabel = this.addLabel(width - 162.0f - 5.0f, 5.0f, 162.0f, height - 90.0f, this.getWarningMessage());
        this.warningLabel.setNumberOfLines(0);
        this.warningLabel.setTextVerticalAlignment(NSTextAlignment.Vertical.TOP);
        this.warningLabel.setAutoresizingMask(17);
        UIImageView bg1 = new UIImageView(new CGRect(width - 162.0f - 5.0f, height - 82.0f, 162.0f, 76.0f));
        bg1.setImage(UIImage.of(ModTextures.GLOBAL_SKIN_LIBRARY).uv(0.0f, 180.0f).build());
        bg1.setAutoresizingMask(9);
        bg1.setOpaque(true);
        this.insertViewAtIndex(bg1, 0);
        UIImageView bg2 = new UIImageView(new CGRect(5.0f, height - 28.0f, 18.0f, 18.0f));
        UIImageView bg3 = new UIImageView(new CGRect(129.0f, height - 32.0f, 26.0f, 26.0f));
        bg2.setOpaque(true);
        bg3.setOpaque(true);
        bg2.setImage(UIImage.of(ModTextures.GLOBAL_SKIN_LIBRARY).uv(0.0f, 162.0f).build());
        bg3.setImage(UIImage.of(ModTextures.GLOBAL_SKIN_LIBRARY).uv(18.0f, 154.0f).build());
        bg2.setAutoresizingMask(8);
        bg3.setAutoresizingMask(8);
        this.insertViewAtIndex(bg2, 0);
        this.insertViewAtIndex(bg3, 0);
    }

    @Override
    public void didMoveToWindow() {
        super.didMoveToWindow();
        this.getMenu().ifPresent(container -> container.setVisible(this.window() != null));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.buttonUpload == null) {
            return;
        }
        boolean flags = Strings.isNotBlank((String)this.textName.text()) && !SkinDescriptor.of(this.getInputStack()).isEmpty() && !this.isUploading;
        this.buttonUpload.setEnabled(flags);
    }

    private UITextField addTextField(float x, float y, float width, float height, String key) {
        UITextField textField = new UITextField(new CGRect(x, y, width, height));
        textField.setPlaceholder(this.getDisplayText(key, new Object[0]));
        textField.setMaxLength(255);
        textField.setAutoresizingMask(2);
        this.addSubview(textField);
        return textField;
    }

    private UITextView addTextView(float x, float y, float width, float height, String key) {
        UITextView textField = new UITextView(new CGRect(x, y, width, height));
        textField.setPlaceholder(this.getDisplayText(key, new Object[0]));
        textField.setAutoresizingMask(18);
        textField.setMaxLength(255);
        this.addSubview(textField);
        return textField;
    }

    private UILabel addLabel(float x, float y, float width, float height, NSString message) {
        UILabel label = new UILabel(new CGRect(x, y, width, height));
        label.setText(message);
        label.setTextColor(UIColor.WHITE);
        label.setAutoresizingMask(2);
        this.addSubview(label);
        return label;
    }

    private UIButton addTextButton(float x, float y, float width, float height, String key, BiConsumer<UploadLibraryPanel, UIControl> handler) {
        UIButton button = new UIButton(new CGRect(x, y, width, height));
        button.setTitle(this.getDisplayText(key, new Object[0]), 0);
        button.setTitleColor(UIColor.WHITE, 0);
        button.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        button.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, handler);
        this.addSubview(button);
        return button;
    }

    private void changeFileOptions(UIControl sender) {
        GlobalSkinLibrarySettingWindow dialog = new GlobalSkinLibrarySettingWindow();
        dialog.setTitle(this.getDisplayText("setting.title", new Object[0]));
        dialog.sizeToFit();
        dialog.showInView(this, () -> {
            if (!dialog.isCancelled()) {
                GlobalSkinLibrarySettingWindow.setChanges(dialog.properties());
                this.fileOptionsBox.setSelected(GlobalSkinLibrarySettingWindow.hasChanges());
            }
        });
        this.fileOptionsBox.setSelected(GlobalSkinLibrarySettingWindow.hasChanges());
    }

    private void upload(UIControl sender) {
        SkinDescriptor descriptor = SkinDescriptor.of(this.getInputStack());
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(TicketManager.RENDERER.get(descriptor));
        if (bakedSkin == null) {
            this.onUploadFailed(this.getDisplayText("error.notSkin", new Object[0]));
            return;
        }
        if (Strings.isBlank((String)this.textName.text())) {
            this.onUploadFailed(this.getDisplayText("error.notSkinName", new Object[0]));
            return;
        }
        SkinFileOptions uploadOptions = this.getUploadOptions(bakedSkin.skin());
        if (bakedSkin.skin().settings().isEncrypted()) {
            this.onUploadFailed(this.getDisplayText("error.notSupported", new Object[0]));
            return;
        }
        if (this.isUploading) {
            return;
        }
        this.isUploading = true;
        NetworkManager.sendToServer(new UploadSkinPrePacket(), (result, exception) -> EnvironmentManager.getClient().execute(() -> {
            if (exception != null || result == null || !result.booleanValue()) {
                this.onUploadFailed(this.getDisplayText("error.notPermission", new Object[0]));
                return;
            }
            this.library.uploadSkin(this.textName.text().trim(), this.textDescription.text().trim(), bakedSkin.skin(), uploadOptions, (result1, exception1) -> {
                if (exception1 != null) {
                    this.onUploadFailed(new NSString(exception1.toString()));
                } else {
                    this.onUploadFinish();
                }
            });
        }));
    }

    private SkinFileOptions getUploadOptions(Skin skin) {
        SkinFileOptions options = GlobalSkinLibrarySettingWindow.fileOptions();
        if (skin.fileVersion() < 20 && options.fileVersion() < 20) {
            return null;
        }
        options.setCompressed(true);
        return options;
    }

    private void onUploadFinish() {
        this.textName.setText("");
        this.textTags.setText("");
        this.textDescription.setText("");
        this.isUploading = false;
        this.router.showNewHome();
        NetworkManager.sendToServer(new UploadSkinPacket());
    }

    private void onUploadFailed(NSString message) {
        this.error = message;
        this.isUploading = false;
        if (this.warningLabel != null) {
            this.warningLabel.setText(this.getWarningMessage());
        }
    }

    private NSString getWarningMessage() {
        NSMutableString message = new NSMutableString("");
        message.append(this.getDisplayText("label.upload_warning", new Object[0]));
        message.append("\n\n");
        if (this.error != null) {
            message.append("\u00a7cError: " + this.error.contents() + "\u00a7r");
            message.append("\n\n");
        }
        return message;
    }

    private ItemStack getInputStack() {
        return this.getMenu().map(GlobalSkinLibraryMenu::inputStack).orElse(ItemStack.f_41583_);
    }

    private Optional<GlobalSkinLibraryMenu> getMenu() {
        if (this.router != null) {
            return Optional.ofNullable(this.router.menu());
        }
        return Optional.empty();
    }
}

