/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.client.gui.globalskinlibrary;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIControl;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileOptions;
import moe.plushie.armourers_workshop.init.ModMenuOptions;
import net.minecraft.nbt.CompoundTag;

public class GlobalSkinLibrarySettingWindow
extends ConfirmDialog {
    private static SkinProperties OPTIONS;
    private int contentHeight = 24;
    private final SkinProperties properties = GlobalSkinLibrarySettingWindow.changes().copy();

    public GlobalSkinLibrarySettingWindow() {
        this.setup();
        this.contentHeight += 6;
    }

    public static boolean hasChanges() {
        return !GlobalSkinLibrarySettingWindow.changes().isEmpty();
    }

    public static void setChanges(SkinProperties properties) {
        SkinProperties newProperties = properties.copy();
        ModMenuOptions.getInstance().putTag("library.uploadFileOptions", newProperties.serializeNBT());
        OPTIONS = newProperties;
    }

    public static SkinProperties changes() {
        if (OPTIONS == null) {
            CompoundTag tag = ModMenuOptions.getInstance().getTag("library.uploadFileOptions");
            OPTIONS = tag != null ? new SkinProperties(tag) : new SkinProperties();
        }
        return OPTIONS;
    }

    public static SkinFileOptions fileOptions() {
        SkinProperties values = GlobalSkinLibrarySettingWindow.changes().copy();
        SkinFileOptions options = new SkinFileOptions();
        options.setEditable(values.get(Option.IS_EDITABLE));
        options.setSavable(values.get(Option.IS_SAVABLE));
        options.setExportable(values.get(Option.IS_EXPORTABLE));
        if (!values.isEmpty()) {
            options.setFileVersion(25);
        }
        return options;
    }

    private void setup() {
        this.messageLabel.removeFromSuperview();
        this.addOptionView(Option.NEW_FORMAT_MODE);
        this.addOptionView(Option.IS_EDITABLE);
        this.addOptionView(Option.IS_SAVABLE);
        this.addOptionView(Option.IS_EXPORTABLE);
    }

    private UICheckBox addOptionView(Option<Boolean> property) {
        UICheckBox checkBox = new UICheckBox(new CGRect(8.0f, this.contentHeight, this.bounds().width() - 16.0f, 9.0f));
        checkBox.setTitle(NSString.localizedString("skin-library.setting." + property.key(), new Object[0]));
        checkBox.setSelected(this.properties.get(property));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, sender) -> this.properties.put(property, sender.isSelected()));
        checkBox.setAutoresizingMask(34);
        this.addSubview(checkBox);
        this.contentHeight += 13;
        return checkBox;
    }

    @Override
    public void sizeToFit() {
        this.setBounds(new CGRect(0.0f, 0.0f, this.bounds().width(), this.contentHeight + 30));
    }

    public SkinProperties properties() {
        return this.properties;
    }

    public static class Option<T>
    extends SkinProperty<T> {
        public static final Option<Boolean> NEW_FORMAT_MODE = Option.normal("newFormatMode", false);
        public static final Option<Boolean> IS_EDITABLE = Option.normal("isEditable", true);
        public static final Option<Boolean> IS_SAVABLE = Option.normal("isSavable", true);
        public static final Option<Boolean> IS_EXPORTABLE = Option.normal("isExportable", true);

        public Option(String key, T defaultValue) {
            super(key, defaultValue, false);
        }

        public static <T> Option<T> normal(String key, T defaultValue) {
            return new Option<T>(key, defaultValue);
        }
    }
}

