/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.ILootFunction;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IResultHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;

public class SkinRandomlyFunction
implements ILootFunction {
    public static final MapCodec<SkinRandomlyFunction> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SkinSource.MAP_CODEC.listOf().fieldOf("skins").forGetter(SkinRandomlyFunction::sources)).apply((Applicative)instance, SkinRandomlyFunction::new));
    public final List<SkinSource> sources;

    public SkinRandomlyFunction(Collection<SkinSource> sources) {
        this.sources = Collections.newList(sources);
    }

    @Override
    public ItemStack apply(ItemStack itemStack, LootContext lootContext) {
        SkinDescriptor descriptor = SkinDescriptor.EMPTY;
        ArrayList<SkinSource> pending = new ArrayList<SkinSource>(this.sources);
        while (descriptor.isEmpty() && !pending.isEmpty()) {
            int index = lootContext.m_230907_().m_188503_(pending.size());
            descriptor = pending.remove(index).apply(lootContext);
        }
        if (descriptor.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.SKIN.get(), descriptor);
        return itemStack;
    }

    public List<SkinSource> sources() {
        return this.sources;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return new HashSet(Collections.compactMap(this.sources, SkinSource::param));
    }

    public static class SkinSource
    implements IResultHandler<SkinDescriptor> {
        public static final Codec<SkinSource> MAP_CODEC = new Codec<SkinSource>(){
            final Codec<SkinSource> simple = Codec.STRING.xmap(SkinSource::new, it -> null);
            final Codec<SkinSource> complex = RecordCodecBuilder.create(instance -> instance.group((App)SkinSlotType.CODEC.fieldOf("type").forGetter(it -> null), (App)Codec.INT.optionalFieldOf("slot", (Object)0).forGetter(it -> 0)).apply((Applicative)instance, SkinSource::new));

            public <T> DataResult<Pair<SkinSource, T>> decode(DynamicOps<T> ops, T input) {
                DataResult result = this.simple.decode(ops, input);
                if (result.result().isPresent()) {
                    return result;
                }
                return this.complex.decode(ops, input);
            }

            public <T> DataResult<T> encode(SkinSource input, DynamicOps<T> ops, T prefix) {
                throw new RuntimeException("why you needs serializer?");
            }
        };
        private SkinDescriptor provider;
        private Function<LootContext, SkinDescriptor> searcher;
        private LootContextParam<?> param;

        public SkinSource(String identifier) {
            if (!identifier.isEmpty()) {
                SkinLoader.getInstance().submit(() -> SkinLoader.getInstance().loadSkinFromDB(identifier, SkinPaintScheme.EMPTY, this));
            }
        }

        public SkinSource(SkinSlotType slotType, int slot) {
            this.searcher = context -> this.search((LootContext)context, slotType, slot);
            this.param = LootContextParams.f_81455_;
        }

        public SkinDescriptor apply(LootContext lootContext) {
            if (this.provider != null) {
                return this.provider;
            }
            if (this.searcher != null) {
                return this.searcher.apply(lootContext);
            }
            return SkinDescriptor.EMPTY;
        }

        @Override
        public void apply(SkinDescriptor value, Exception exception) {
            this.provider = value;
        }

        public SkinDescriptor search(LootContext lootContext, @Nullable SkinSlotType slotType, int index) {
            Object value = lootContext.m_78953_(this.param);
            SkinWardrobe wardrobe = SkinWardrobe.of(Objects.safeCast(value, Entity.class));
            if (wardrobe == null) {
                return SkinDescriptor.EMPTY;
            }
            SkinDescriptor descriptor = SkinDescriptor.EMPTY;
            ArrayList<ItemStack> pending = this.collect(wardrobe, slotType, index);
            while (descriptor.isEmpty() && !pending.isEmpty()) {
                index = lootContext.m_230907_().m_188503_(pending.size());
                descriptor = SkinDescriptor.of(pending.remove(index));
            }
            return descriptor;
        }

        public ArrayList<ItemStack> collect(SkinWardrobe wardrobe, @Nullable SkinSlotType slotType, int index) {
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            if (slotType == null) {
                for (SkinSlotType slotType1 : SkinSlotType.values()) {
                    if (slotType1.skinType() == null) continue;
                    results.addAll(this.collect(wardrobe, slotType1, index));
                }
                return results;
            }
            if (index != 0) {
                results.add(wardrobe.getItem(slotType, index));
                return results;
            }
            int count = wardrobe.getUnlockedSize(slotType);
            for (int i = 0; i < count; ++i) {
                results.add(wardrobe.getItem(slotType, i));
            }
            return results;
        }

        public LootContextParam<?> param() {
            return this.param;
        }
    }
}

