/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import moe.plushie.armourers_workshop.api.skin.texture.ISkinTextureProvider;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureAnimation;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureProperties;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import moe.plushie.armourers_workshop.core.utils.StreamUtils;

public class SkinTextureData
implements ISkinTextureProvider {
    public static final SkinTextureData EMPTY = new SkinTextureData("", 256.0f, 256.0f);
    private final int id = OpenRandomSource.nextInt(SkinTextureData.class);
    private final String name;
    private final float width;
    private final float height;
    private SkinTextureAnimation animation;
    private SkinTextureProperties properties;
    private ByteBuf bytes = Unpooled.EMPTY_BUFFER;
    private List<SkinTextureData> variants = Collections.emptyList();

    public SkinTextureData(String name, float width, float height) {
        this(name, width, height, SkinTextureAnimation.EMPTY, SkinTextureProperties.EMPTY);
    }

    public SkinTextureData(String name, float width, float height, SkinTextureAnimation animation, SkinTextureProperties properties) {
        this.name = name;
        this.width = width;
        this.height = height;
        this.animation = animation;
        this.properties = properties;
    }

    public void load(ByteBuf buf) {
        this.bytes = buf.duplicate();
    }

    public void load(InputStream inputStream) throws IOException {
        this.bytes = Unpooled.buffer((int)1024);
        try (ByteBufOutputStream outputStream = new ByteBufOutputStream(this.bytes);){
            StreamUtils.transferTo(inputStream, (OutputStream)outputStream);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public float width() {
        return this.width;
    }

    @Override
    public float height() {
        return this.height;
    }

    public void setAnimation(SkinTextureAnimation animation) {
        this.animation = animation;
    }

    @Override
    public SkinTextureAnimation animation() {
        return this.animation;
    }

    public void setProperties(SkinTextureProperties properties) {
        this.properties = properties;
    }

    @Override
    public SkinTextureProperties properties() {
        return this.properties;
    }

    @Override
    public ByteBuf buffer() {
        return this.bytes;
    }

    public void setVariants(List<SkinTextureData> variants) {
        this.variants = variants;
    }

    public List<SkinTextureData> variants() {
        return this.variants;
    }

    public String toString() {
        return Objects.toString(this, "name", this.name, "width", Float.valueOf(this.width), "height", Float.valueOf(this.height), "animation", this.animation, "properties", this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinTextureData)) {
            return false;
        }
        SkinTextureData that = (SkinTextureData)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

