/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IDataSerializable;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EntityTextureDescriptor
implements IDataSerializable.Immutable {
    public static final EntityTextureDescriptor EMPTY = new EntityTextureDescriptor(null, null, null);
    private static final Cache<ItemStack, EntityTextureDescriptor> DESCRIPTOR_CACHES = CacheBuilder.newBuilder().maximumSize(8L).expireAfterAccess(15L, TimeUnit.SECONDS).build();
    public static final IDataCodec<EntityTextureDescriptor> CODEC = IDataCodec.COMPOUND_TAG.serializer(EntityTextureDescriptor::new);
    private Source source;
    private String value;
    private GameProfile profile;

    public EntityTextureDescriptor(Source source, String value, GameProfile profile) {
        this.source = source;
        this.value = value;
        this.profile = profile;
    }

    public EntityTextureDescriptor(IDataSerializer serializer) {
        UserInfo info;
        String url = serializer.read(CodingKeys.URL);
        if (url != null) {
            this.source = Source.URL;
            this.value = url;
        }
        if ((info = serializer.read(CodingKeys.USER)) != null) {
            this.source = Source.USER;
            this.value = info.name;
        }
        if (this.value == null && this.profile == null) {
            this.source = null;
        }
    }

    public static EntityTextureDescriptor of(ItemStack itemStack) {
        if (!itemStack.m_150930_((Item)ModItems.MANNEQUIN.get())) {
            return EMPTY;
        }
        CompoundTag entityTag = (CompoundTag)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.ENTITY_DATA.get());
        if (entityTag == null || !entityTag.m_128425_("Texture", 10)) {
            return EMPTY;
        }
        EntityTextureDescriptor descriptor = (EntityTextureDescriptor)DESCRIPTOR_CACHES.getIfPresent((Object)itemStack);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = new EntityTextureDescriptor(OptionalAPI.getOptionalCompound(entityTag, "Texture").map(TagSerializer::new).orElseGet(TagSerializer::new));
        DESCRIPTOR_CACHES.put((Object)itemStack, (Object)descriptor);
        return descriptor;
    }

    public static EntityTextureDescriptor fromURL(String url) {
        return new EntityTextureDescriptor(Source.URL, url, null);
    }

    public static EntityTextureDescriptor fromName(String name) {
        return new EntityTextureDescriptor(Source.USER, name, null);
    }

    public static EntityTextureDescriptor fromProfile(GameProfile profile) {
        return new EntityTextureDescriptor(Source.USER, profile.getName(), profile);
    }

    @Override
    public void serialize(IDataSerializer serializer) {
        if (this.source == Source.URL && this.value != null) {
            serializer.write(CodingKeys.URL, this.value);
        }
        if (this.source == Source.USER && this.value != null) {
            serializer.write(CodingKeys.USER, new UserInfo(this.value));
        }
    }

    public boolean isEmpty() {
        return this.source == null;
    }

    @Nullable
    public String url() {
        if (this.source == Source.URL) {
            return this.value;
        }
        return null;
    }

    @Nullable
    public String name() {
        if (this.source == Source.USER && this.value != null) {
            return this.value;
        }
        return null;
    }

    @Nullable
    public GameProfile profile() {
        return this.profile;
    }

    public Optional<String> value() {
        return Optional.ofNullable(this.value);
    }

    public Optional<Source> source() {
        return Optional.ofNullable(this.source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityTextureDescriptor)) {
            return false;
        }
        EntityTextureDescriptor that = (EntityTextureDescriptor)o;
        return this.source == that.source && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.value});
    }

    public String toString() {
        if (!this.isEmpty()) {
            return this.value;
        }
        return "<empty>";
    }

    public static enum Source {
        USER,
        URL;

    }

    private static class CodingKeys {
        public static final IDataSerializerKey<String> URL = IDataSerializerKey.create("URL", IDataCodec.STRING, null);
        public static final IDataSerializerKey<UserInfo> USER = IDataSerializerKey.create("User", UserInfo.CODEC, null);
        public static final IDataSerializerKey<String> NAME = IDataSerializerKey.create("Name", IDataCodec.STRING, "");

        private CodingKeys() {
        }
    }

    private static class UserInfo
    implements IDataSerializable.Immutable {
        public static final IDataCodec<UserInfo> CODEC = IDataCodec.COMPOUND_TAG.serializer(UserInfo::new);
        private final String name;

        public UserInfo(String name) {
            this.name = name;
        }

        public UserInfo(IDataSerializer serializer) {
            this.name = serializer.read(CodingKeys.NAME);
        }

        @Override
        public void serialize(IDataSerializer serializer) {
            serializer.write(CodingKeys.NAME, this.name);
        }
    }

    public static enum Model {
        STEVE,
        ALEX;

    }
}

