/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometry;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometrySet;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkContext;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkDataOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySelector;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkGeometrySliceSet;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkVariable;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializer;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.geometry.ChunkGeometrySerializers;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class ChunkGeometryData
implements ChunkVariable {
    private final int id;
    private final ChunkPaletteData palette;
    private final LinkedHashMap<Integer, ChunkGeometrySection> sections = new LinkedHashMap();
    private final IdentityHashMap<SkinGeometrySet<?>, Collection<ChunkGeometrySelector>> pending = new IdentityHashMap();
    private final LinkedHashMap<SkinGeometryType, ChunkGeometrySerializer.Encoder<?>> encoders = new LinkedHashMap();

    public ChunkGeometryData(int id, ChunkPaletteData palette) {
        this.id = id;
        this.palette = palette;
    }

    public int id() {
        return this.id;
    }

    @Override
    public boolean freeze() {
        if (!this.palette.isResolved()) {
            return false;
        }
        int offset = 0;
        ArrayList<ChunkGeometrySection> sortedSections = new ArrayList<ChunkGeometrySection>(this.sections.values());
        sortedSections.sort(Comparator.comparing(this::_key));
        for (ChunkGeometrySection section : sortedSections) {
            if (!section.isResolved()) {
                section.freeze(offset);
            }
            offset += section.geometryTotal();
        }
        this.pending.clear();
        return true;
    }

    public void readFromStream(ChunkDataInputStream stream) throws IOException {
        ChunkGeometrySection.Immutable section;
        int offset = 0;
        while ((section = this.readSectionFromStream(stream)) != null) {
            this.sections.put(this._key(section), section);
            section.freeze(offset);
            offset += section.geometryTotal();
        }
    }

    @Override
    public void writeToStream(ChunkOutputStream stream) throws IOException {
        ArrayList<ChunkGeometrySection> sortedSections = new ArrayList<ChunkGeometrySection>(this.sections.values());
        sortedSections.sort(Comparator.comparing(ChunkGeometrySection::index));
        for (ChunkGeometrySection section : sortedSections) {
            this.writeSectionToStream(section, stream);
        }
        this.writeSectionToStream(null, stream);
    }

    public SkinGeometrySet<?> readReferenceFromStream(ChunkDataInputStream stream) throws IOException {
        ArrayList<ChunkGeometrySelector> selectors = new ArrayList<ChunkGeometrySelector>();
        int count = stream.readVarInt();
        for (int i = 0; i < count; ++i) {
            int index = stream.readInt();
            int size = stream.readInt();
            ChunkGeometrySection section = this._sectionAt(index);
            if (section == null) continue;
            int offset = index - section.index();
            selectors.add(new ChunkGeometrySelector(section, offset, offset + size));
        }
        return new ChunkGeometrySliceSet(this.id, selectors, this.palette);
    }

    public void writeReferenceToStream(SkinGeometrySet<?> geometries, ChunkDataOutputStream streamIn) throws IOException {
        if (streamIn.context().isEnableFastEncoder() && geometries instanceof ChunkGeometrySliceSet) {
            ChunkGeometrySliceSet slices = (ChunkGeometrySliceSet)geometries;
            Collection selectors = this.pending.computeIfAbsent(geometries, k -> slices.selectors());
            this.palette.copyFrom(slices.palette());
            streamIn.writeVarInt(selectors.size());
            for (ChunkGeometrySelector selector : selectors) {
                ChunkGeometrySection section2 = selector.section();
                this.sections.put(this._key(section2), section2);
                streamIn.writeVariable(selector);
            }
            return;
        }
        Collection selectors = this.pending.computeIfAbsent(geometries, k -> new ArrayList());
        if (selectors.isEmpty()) {
            LinkedHashMap<ChunkGeometrySection, Integer> changes = this._encodeGeometryData(geometries, streamIn.context());
            changes.forEach((section, startIndex) -> {
                int endIndex = section.geometryTotal();
                selectors.add(new ChunkGeometrySelector((ChunkGeometrySection)section, (int)startIndex, endIndex));
            });
        }
        streamIn.writeVarInt(selectors.size());
        for (ChunkGeometrySelector selector : selectors) {
            streamIn.writeVariable(selector);
        }
    }

    private ChunkGeometrySection.Immutable readSectionFromStream(ChunkDataInputStream stream) throws IOException {
        int geometryTotal = stream.readVarInt();
        if (geometryTotal == 0) {
            return null;
        }
        SkinGeometryType geometryType = SkinGeometryTypes.byId(stream.readVarInt());
        int geometryOptions = stream.readVarInt();
        ChunkGeometrySection.Immutable section = new ChunkGeometrySection.Immutable(geometryTotal, geometryOptions, geometryType, this.palette);
        section.readFromStream(stream);
        return section;
    }

    private void writeSectionToStream(ChunkGeometrySection section, ChunkOutputStream stream) throws IOException {
        if (section == null || section.isEmpty()) {
            stream.writeVarInt(0);
            return;
        }
        stream.writeVarInt(section.geometryTotal());
        stream.writeVarInt(section.geometryType().id());
        stream.writeVarInt(section.geometryOptions());
        section.writeToStream(stream);
    }

    private LinkedHashMap<ChunkGeometrySection, Integer> _encodeGeometryData(SkinGeometrySet<?> geometries, ChunkContext context) throws IOException {
        LinkedHashMap<ChunkGeometrySection, Integer> changes = new LinkedHashMap<ChunkGeometrySection, Integer>();
        for (SkinGeometry geometry : geometries) {
            SkinGeometryType geometryType = geometry.type();
            ChunkGeometrySerializer.Encoder<?> geometryEncoder = this._encoderByType(geometryType);
            int geometryOptions = geometryEncoder.begin((SkinGeometry)Objects.unsafeCast(geometry));
            ChunkGeometrySection.Mutable section = this._mutableSectionAt(geometryType, geometryOptions, context);
            changes.putIfAbsent(section, section.geometryTotal());
            section.write(geometryEncoder, this.palette);
        }
        return changes;
    }

    private Integer _key(ChunkGeometrySection section) {
        return this._key(section.geometryType(), section.geometryOptions());
    }

    private Integer _key(SkinGeometryType geometryType, int options) {
        return geometryType.id() << 24 | options;
    }

    private ChunkGeometrySection _sectionAt(int index) {
        for (ChunkGeometrySection section : this.sections.values()) {
            int startIndex = section.index();
            int endIndex = section.geometryTotal() + startIndex;
            if (startIndex > index || index >= endIndex) continue;
            return section;
        }
        return null;
    }

    private ChunkGeometrySection.Mutable _mutableSectionAt(SkinGeometryType geometryType, int options, ChunkContext context) {
        Integer key = this._key(geometryType, options);
        ChunkGeometrySection section = this.sections.computeIfAbsent(key, it -> new ChunkGeometrySection.Mutable(options, geometryType, context));
        return (ChunkGeometrySection.Mutable)section;
    }

    private ChunkGeometrySerializer.Encoder<?> _encoderByType(SkinGeometryType geometryType) {
        return this.encoders.computeIfAbsent(geometryType, ChunkGeometrySerializers::createEncoder);
    }
}

