/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.particle.lifetime;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class ParticleExpressLifetime
extends SkinParticleComponent {
    private final OpenPrimitive duration;
    private final OpenPrimitive expiration;

    public ParticleExpressLifetime(OpenPrimitive duration, OpenPrimitive expiration) {
        this.duration = duration;
        this.expiration = expiration;
    }

    public ParticleExpressLifetime(IInputStream stream) throws IOException {
        this.duration = stream.readPrimitiveObject();
        this.expiration = stream.readPrimitiveObject();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.duration);
        stream.writePrimitiveObject(this.expiration);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        Expression duration = builder.compile(this.duration, -1.0);
        Expression expiration = builder.compile(this.expiration, 0.0);
        builder.applyParticle((emitter, particle, context) -> {
            double t = duration.compute(context);
            particle.setDuration(t);
        });
        if (this.expiration.isNull()) {
            return;
        }
        builder.updateParticle((emitter, particle, context) -> {
            if (expiration.test(context)) {
                particle.kill();
            }
        });
    }
}

