/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class EmitterExpressionLifetime
extends SkinParticleComponent {
    private final OpenPrimitive activation;
    private final OpenPrimitive expiration;

    public EmitterExpressionLifetime(OpenPrimitive activation, OpenPrimitive expiration) {
        this.activation = activation;
        this.expiration = expiration;
    }

    public EmitterExpressionLifetime(IInputStream stream) throws IOException {
        this.activation = stream.readPrimitiveObject();
        this.expiration = stream.readPrimitiveObject();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.activation);
        stream.writePrimitiveObject(this.expiration);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        Expression activation = builder.compile(this.activation, 0.0);
        Expression expiration = builder.compile(this.expiration, 0.0);
        builder.updateEmitter((emitter, context) -> {
            if (activation.test(context)) {
                emitter.start();
            }
            if (expiration.test(context)) {
                emitter.stop();
            }
        });
    }
}

