/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.part.wings;

import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanRotation;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class WingPartTransform
implements ITransform {
    private double animationTime = 0.0;
    private boolean isFallFlying = false;
    private final boolean isMirror;
    private final SkinMarker marker;
    private final SkinProperties properties;

    public WingPartTransform(SkinPartType partType, SkinProperties properties, SkinMarker marker) {
        ICanRotation rotatableType;
        this.marker = marker;
        this.properties = properties;
        this.isMirror = partType instanceof ICanRotation && (rotatableType = (ICanRotation)((Object)partType)).isMirror();
    }

    public static boolean isFlying(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35935_) {
                return true;
            }
        }
        return entity.m_21255_();
    }

    public void setup(@Nullable Entity entity, double animationTime) {
        LivingEntity livingEntity;
        this.animationTime = animationTime;
        this.isFallFlying = entity instanceof LivingEntity && WingPartTransform.isFlying(livingEntity = (LivingEntity)entity);
    }

    @Override
    public void apply(IPoseStack poseStack) {
        OpenDirection dir = this.marker.direction();
        if (dir == null) {
            return;
        }
        OpenVector3i point = this.marker.position();
        float angle = (float)this.rotationDegrees();
        OpenVector3f offset = new OpenVector3f((float)point.x() + 0.5f, (float)point.y() + 0.5f, (float)point.z() + 0.5f);
        if (!this.isMirror) {
            angle = -angle;
        }
        poseStack.translate(offset.x(), offset.y(), offset.z());
        poseStack.rotate(this.rotationMatrix(dir).rotationDegrees(angle));
        poseStack.translate(-offset.x(), -offset.y(), -offset.z());
    }

    private double rotationDegrees() {
        if (this.properties == null || this.properties.isEmpty()) {
            return 0.0;
        }
        Double maxAngle = this.properties.get(SkinProperty.WINGS_MAX_ANGLE);
        Double minAngle = this.properties.get(SkinProperty.WINGS_MIN_ANGLE);
        String movementTypeName = this.properties.get(SkinProperty.WINGS_MOVMENT_TYPE);
        SkinProperty.MovementType movementType = SkinProperty.MovementType.valueOf(movementTypeName);
        Double flapTime = this.properties.get(SkinProperty.WINGS_IDLE_SPEED);
        if (this.isFallFlying) {
            flapTime = this.properties.get(SkinProperty.WINGS_FLYING_SPEED);
        }
        double finalFlapTime = Math.max(flapTime / 1000.0, (double)0.1f);
        double angle = this.animationTime % finalFlapTime;
        if (movementType == SkinProperty.MovementType.EASE) {
            angle = Math.sin(angle / finalFlapTime * Math.PI * 2.0);
        }
        if (movementType == SkinProperty.MovementType.LINEAR) {
            angle /= finalFlapTime;
        }
        double fullAngle = maxAngle - minAngle;
        if (movementType == SkinProperty.MovementType.LINEAR) {
            return fullAngle * angle;
        }
        return -minAngle.doubleValue() - fullAngle * ((angle + 1.0) / 2.0);
    }

    private OpenVector3f rotationMatrix(OpenDirection direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case OpenDirection.UP -> OpenVector3f.YP;
            case OpenDirection.DOWN -> OpenVector3f.YN;
            case OpenDirection.SOUTH -> OpenVector3f.ZN;
            case OpenDirection.NORTH -> OpenVector3f.ZP;
            case OpenDirection.EAST -> OpenVector3f.XP;
            case OpenDirection.WEST -> OpenVector3f.XN;
        };
    }
}

