/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind;

import moe.plushie.armourers_workshop.compatibility.core.AbstractRegistryManager;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.EntityInfoProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.data.EntityDataStorage;
import moe.plushie.armourers_workshop.core.skin.molang.core.Name;
import moe.plushie.armourers_workshop.core.skin.molang.core.Result;
import moe.plushie.armourers_workshop.core.skin.molang.core.VariableStorage;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.MathHelper;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.BiomeSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.BlockSelector;
import moe.plushie.armourers_workshop.core.skin.molang.runtime.bind.selector.EntitySelector;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.BiomeSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.BlockSelectorImpl;
import moe.plushie.armourers_workshop.core.skin.molang.thirdparty.bind.ContextSelectorImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntitySelectorImpl<T extends Entity>
implements EntitySelector,
VariableStorage {
    protected T entity;
    protected VariableStorage variableStorage;
    protected ContextSelectorImpl contextSelector;
    private final BiomeSelectorImpl biomeSelector = new BiomeSelectorImpl();
    private final BlockSelectorImpl blockSelector = new BlockSelectorImpl();

    public EntitySelectorImpl<T> apply(T entity, ContextSelectorImpl contextSelector) {
        this.entity = entity;
        this.contextSelector = contextSelector;
        this.variableStorage = EntityDataStorage.of(entity).variableStorage().map(it -> it.get(contextSelector)).orElse(null);
        return this;
    }

    public T entity() {
        return this.entity;
    }

    @Override
    public double eyeYaw() {
        return this.entity.m_5686_(this.partialTick());
    }

    @Override
    public double eyePitch() {
        return this.entity.m_5675_(this.partialTick());
    }

    @Override
    public double headYaw() {
        return EntityInfoProvider.getHeadYaw(this.entity, this.partialTick());
    }

    @Override
    public double headPitch() {
        return EntityInfoProvider.getHeadPatch(this.entity, this.partialTick());
    }

    @Override
    public double x(double partialTicks) {
        return MathHelper.lerp(partialTicks, ((Entity)this.entity).f_19854_, this.entity.m_20185_());
    }

    @Override
    public double y(double partialTicks) {
        return MathHelper.lerp(partialTicks, ((Entity)this.entity).f_19855_, this.entity.m_20186_());
    }

    @Override
    public double z(double partialTicks) {
        return MathHelper.lerp(partialTicks, ((Entity)this.entity).f_19856_, this.entity.m_20189_());
    }

    @Override
    public int cardinalFacing() {
        return this.entity.m_6350_().m_122411_();
    }

    @Override
    public double distanceFromCamera() {
        return this.contextSelector.getCameraDistanceFormEntity((Entity)this.entity);
    }

    @Override
    public double distanceFromMove() {
        return ((Entity)this.entity).f_19787_;
    }

    @Override
    public double distanceFromWalk() {
        return ((Entity)this.entity).f_19788_;
    }

    @Override
    public double yawSpeed() {
        return 20.0f * (this.entity.m_146908_() - ((Entity)this.entity).f_19859_);
    }

    @Override
    public double groundSpeed() {
        Vec3 velocity = this.entity.m_20184_();
        return 20.0 * Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
    }

    @Override
    public double verticalSpeed() {
        return 20.0 * (this.entity.m_20182_().f_82480_ - ((Entity)this.entity).f_19855_);
    }

    @Override
    public boolean isVehicle() {
        return this.entity.m_20160_();
    }

    @Override
    public boolean isPassenger() {
        return this.entity.m_20159_();
    }

    @Override
    public boolean isInWater() {
        return this.entity.m_20069_();
    }

    @Override
    public boolean isInWaterRainOrBubble() {
        return this.entity.m_20071_();
    }

    @Override
    public boolean isOnFire() {
        return this.entity.m_6060_();
    }

    @Override
    public boolean isOnGround() {
        return this.entity.m_20096_();
    }

    @Override
    public boolean isSneaking() {
        return this.entity.m_20096_() && this.entity.m_20089_() == Pose.CROUCHING;
    }

    @Override
    public boolean isJumping() {
        return !this.entity.m_20159_() && !this.entity.m_20096_() && !this.entity.m_20069_();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.m_20142_();
    }

    @Override
    public boolean isSwimming() {
        return this.entity.m_6069_();
    }

    @Override
    public boolean isSleeping() {
        return this.entity.m_20089_() == Pose.SLEEPING;
    }

    @Override
    public boolean isSpectator() {
        return this.entity.m_5833_();
    }

    @Override
    public boolean isUnderWater() {
        return this.entity.m_5842_();
    }

    @Override
    public boolean isCloseEyes() {
        if (this.isSleeping()) {
            return true;
        }
        double noise = (double)this.entity.m_19879_() * 0.05;
        double time = (this.contextSelector.animationTicks() + noise) % 4.5;
        return time > 4.25;
    }

    @Override
    public boolean canSeeSky() {
        BlockPos pos;
        Level level = PropertyProvider.getLevel(this.entity);
        if (!level.m_45527_(pos = this.entity.m_20183_())) {
            return false;
        }
        return level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() <= pos.m_123342_();
    }

    @Override
    public double ticksFrozen() {
        return this.entity.m_146888_();
    }

    @Override
    public double airSupply() {
        return this.entity.m_20146_();
    }

    @Override
    @Nullable
    public BiomeSelector biome() {
        Level level = PropertyProvider.getLevel(this.entity);
        AbstractRegistryManager.Biome biome = AbstractRegistryManager.getBiome(level, this.entity.m_20183_());
        return this.biomeSelector.apply(biome);
    }

    @Override
    public BlockSelector relativeBlock(int offsetX, int offsetY, int offsetZ) {
        Level level = PropertyProvider.getLevel(this.entity);
        double x = this.entity.m_20185_() + (double)offsetX;
        double y = this.entity.m_20185_() + (double)offsetX;
        double z = this.entity.m_20185_() + (double)offsetX;
        BlockState blockState = level.m_8055_(new BlockPos((int)x, (int)y, (int)z));
        return this.blockSelector.apply(blockState);
    }

    @Override
    public float partialTick() {
        return this.contextSelector.partialTick();
    }

    @Override
    public void setVariable(Name name, Result value) {
        this.variableStorage.setVariable(name, value);
    }

    @Override
    public Result getVariable(Name name) {
        return this.variableStorage.getVariable(name);
    }
}

