/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.geometry;

import moe.plushie.armourers_workshop.api.skin.geometry.ISkinGeometryOptions;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class SkinGeometryOptions
implements ISkinGeometryOptions {
    public static final SkinGeometryOptions EMPTY = new SkinGeometryOptions();
    private long value = 0L;
    private int renderOrder = 0;

    public SkinGeometryOptions() {
    }

    public SkinGeometryOptions(long value) {
        this.value = value;
        this.renderOrder = (int)(value & 3L);
    }

    public void setRenderOrder(int renderOrder) {
        this.renderOrder = renderOrder;
        this.value = this.value & 0xFFFFFFFFFFFFFFFCL | (long)(renderOrder & 3);
    }

    @Override
    public int renderOrder() {
        return this.renderOrder;
    }

    @Override
    public boolean isEmpty() {
        return this.value == 0L;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkinGeometryOptions)) {
            return false;
        }
        SkinGeometryOptions that = (SkinGeometryOptions)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.format("[renderOrder=%d]", this.renderOrder);
    }
}

