/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractEntityDataSerializer;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.EntityCollisionShape;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.menu.SkinWardrobeMenu;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenEquipmentSlot;
import moe.plushie.armourers_workshop.core.utils.TagSerializer;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class UpdateWardrobePacket
extends CustomPacket {
    private final Type type;
    private final int entityId;
    private final GenericValue<SkinWardrobe, ?> fieldValue;
    private final CompoundTag compoundTag;

    public UpdateWardrobePacket(IFriendlyByteBuf buffer) {
        this.type = buffer.readEnum(Type.class);
        this.entityId = buffer.readInt();
        if (this.type != Type.SYNC_OPTION) {
            this.fieldValue = null;
            this.compoundTag = buffer.readNbt();
        } else {
            this.fieldValue = Field.TYPE.read(buffer);
            this.compoundTag = null;
        }
    }

    public UpdateWardrobePacket(SkinWardrobe wardrobe, Type mode, CompoundTag compoundTag, GenericValue<SkinWardrobe, ?> fieldValue) {
        this.type = mode;
        this.entityId = wardrobe.id();
        this.fieldValue = fieldValue;
        this.compoundTag = compoundTag;
    }

    public static UpdateWardrobePacket sync(SkinWardrobe wardrobe) {
        TagSerializer serializer = new TagSerializer(new CompoundTag(), wardrobe.entity());
        wardrobe.serialize(serializer);
        return new UpdateWardrobePacket(wardrobe, Type.SYNC, serializer.tag(), null);
    }

    public static UpdateWardrobePacket dying(SkinWardrobe wardrobe, int slot, SkinPaintColor color) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("Slot", slot);
        compoundNBT.m_128405_("Color", color.rawValue());
        return new UpdateWardrobePacket(wardrobe, Type.SYNC_ITEM, compoundNBT, null);
    }

    public static UpdateWardrobePacket field(SkinWardrobe wardrobe, GenericValue<SkinWardrobe, ?> fieldValue) {
        return new UpdateWardrobePacket(wardrobe, Type.SYNC_OPTION, null, fieldValue);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum(this.type);
        buffer.writeInt(this.entityId);
        if (this.compoundTag != null) {
            buffer.writeNbt(this.compoundTag);
        }
        if (this.fieldValue != null) {
            this.fieldValue.write(buffer);
        }
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayer player) {
        if (!(player.f_36096_ instanceof SkinWardrobeMenu)) {
            ModLog.info("reject {} operation for '{}'", this.operator(), player.m_6302_());
            return;
        }
        if (!this.checkSecurityByServer()) {
            ModLog.info("reject {} operation for '{}', for security reasons.", this.operator(), player.m_6302_());
            return;
        }
        ModLog.debug("accept {} operation for '{}'", this.operator(), player.m_6302_());
        SkinWardrobe wardrobe = this.apply((Player)player);
        if (wardrobe != null) {
            NetworkManager.sendToTracking(this, (Entity)player);
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, Player player) {
        this.apply(player);
    }

    @Nullable
    private SkinWardrobe apply(Player player) {
        SkinWardrobe wardrobe = SkinWardrobe.of(PropertyProvider.getLevel((Entity)player).m_6815_(this.entityId));
        if (wardrobe == null) {
            return null;
        }
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                TagSerializer serializer = new TagSerializer(this.compoundTag, player);
                wardrobe.deserialize(serializer);
                yield wardrobe;
            }
            case 2 -> {
                if (this.fieldValue != null) {
                    this.fieldValue.apply(wardrobe);
                    yield wardrobe;
                }
                yield null;
            }
            case 1 -> {
                Container inventory = wardrobe.inventory();
                int slot = OptionalAPI.getOptionalInt(this.compoundTag, "Slot").orElse(0);
                if (slot < inventory.m_6643_()) {
                    ItemStack itemStack = ItemStack.f_41583_;
                    SkinPaintColor color = SkinPaintColor.of(OptionalAPI.getOptionalInt(this.compoundTag, "Color").orElse(0));
                    if (!color.isEmpty()) {
                        ItemStack newItemStack = new ItemStack((ItemLike)ModItems.BOTTLE.get());
                        ComponentAPI.set(newItemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), color);
                        itemStack = newItemStack;
                    }
                    inventory.m_6836_(slot, itemStack);
                    yield wardrobe;
                }
                yield null;
            }
        };
    }

    private boolean checkSecurityByServer() {
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> false;
            case 2 -> true;
            case 1 -> {
                int slot = OptionalAPI.getOptionalInt(this.compoundTag, "Slot").orElse(0);
                int index = slot - SkinSlotType.DYE.index();
                if (index < 8 || index >= SkinSlotType.DYE.maxSize()) {
                    yield false;
                }
                yield true;
            }
        };
    }

    private Object operator() {
        if (this.fieldValue != null) {
            return this.fieldValue.property();
        }
        return this.type;
    }

    public static enum Type {
        SYNC,
        SYNC_ITEM,
        SYNC_OPTION;

    }

    public static final class Field<T>
    extends GenericProperty<SkinWardrobe, T> {
        private static final GenericProperties<SkinWardrobe> TYPE = GenericProperties.of(SkinWardrobe.class, UpdateWardrobePacket::field);
        public static final Field<Boolean> WARDROBE_ARMOUR_HEAD = Field.wardrobe(OpenEquipmentSlot.HEAD);
        public static final Field<Boolean> WARDROBE_ARMOUR_CHEST = Field.wardrobe(OpenEquipmentSlot.CHEST);
        public static final Field<Boolean> WARDROBE_ARMOUR_LEGS = Field.wardrobe(OpenEquipmentSlot.LEGS);
        public static final Field<Boolean> WARDROBE_ARMOUR_FEET = Field.wardrobe(OpenEquipmentSlot.FEET);
        public static final Field<Boolean> WARDROBE_EXTRA_RENDER = Field.wardrobe(SkinWardrobe::shouldRenderExtra, SkinWardrobe::setRenderExtra);
        public static final Field<EntityCollisionShape> WARDROBE_COLLISION_SHAPE = Field.wardrobe(SkinWardrobe::collisionShape, SkinWardrobe::setCollisionShape, DataSerializers.COLLISION_SHAPE_OPT);
        public static final Field<Boolean> MANNEQUIN_IS_CHILD = Field.entity(MannequinEntity.DATA_IS_CHILD);
        public static final Field<Boolean> MANNEQUIN_IS_FLYING = Field.entity(MannequinEntity.DATA_IS_FLYING);
        public static final Field<Boolean> MANNEQUIN_IS_VISIBLE = Field.entity(MannequinEntity.DATA_IS_VISIBLE);
        public static final Field<Boolean> MANNEQUIN_IS_GHOST = Field.entity(MannequinEntity.DATA_IS_GHOST);
        public static final Field<Boolean> MANNEQUIN_EXTRA_RENDER = Field.entity(MannequinEntity.DATA_EXTRA_RENDERER);
        public static final Field<Boolean> MANNEQUIN_NO_GRAVITY = Field.entity(MannequinEntity.DATA_NO_GRAVITY);
        public static final Field<CompoundTag> MANNEQUIN_POSE = Field.entity(MannequinEntity::saveCustomPose, MannequinEntity::readCustomPose, DataSerializers.COMPOUND_TAG);
        public static final Field<Vec3> MANNEQUIN_POSITION = Field.entity(Entity::m_20182_, Entity::m_20219_, DataSerializers.VECTOR_3D);
        public static final Field<EntityTextureDescriptor> MANNEQUIN_TEXTURE = Field.entity(MannequinEntity.DATA_TEXTURE);
        public static final Field<EntityTextureDescriptor.Model> MANNEQUIN_TEXTURE_MODEL = Field.entity(MannequinEntity.DATA_TEXTURE_MODEL);

        private static Field<Boolean> wardrobe(OpenEquipmentSlot slotType) {
            return Field.wardrobe(source -> source.shouldRenderEquipment(slotType), (source, value) -> source.setRenderEquipment(slotType, (boolean)value), DataSerializers.BOOLEAN);
        }

        private static Field<Boolean> wardrobe(Function<SkinWardrobe, Boolean> supplier, BiConsumer<SkinWardrobe, Boolean> applier) {
            return Field.wardrobe(supplier, applier, DataSerializers.BOOLEAN);
        }

        private static <T> Field<T> wardrobe(Function<SkinWardrobe, T> supplier, BiConsumer<SkinWardrobe, T> applier, IEntitySerializer<T> dataSerializer) {
            return TYPE.create(dataSerializer).getter(supplier).setter(applier).build(Field::new);
        }

        private static <T> Field<T> entity(EntityDataAccessor<T> dataParameter) {
            return Field.entity(entity -> entity.m_20088_().m_135370_(dataParameter), (entity, value) -> entity.m_20088_().m_135381_(dataParameter, value), AbstractEntityDataSerializer.wrap(dataParameter));
        }

        private static <S extends Entity, T> Field<T> entity(Function<S, T> supplier, BiConsumer<S, T> applier, IEntitySerializer<T> dataSerializer) {
            return TYPE.create(dataSerializer).getter(source -> {
                Entity entity = source.entity();
                if (entity != null) {
                    return supplier.apply((Entity)Objects.unsafeCast(entity));
                }
                return null;
            }).setter((source, value) -> {
                Entity entity = source.entity();
                if (entity != null) {
                    applier.accept((Entity)Objects.unsafeCast(entity), value);
                }
            }).build(Field::new);
        }
    }
}

