/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.io.IOException;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.ITransform;
import moe.plushie.armourers_workshop.api.core.math.ITransform3f;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.Objects;

public class OpenTransform3f
implements ITransform3f,
ITransform {
    public static final int BYTES = 64;
    public static final OpenTransform3f IDENTITY = new OpenTransform3f();
    private OpenVector3f translate = OpenVector3f.ZERO;
    private OpenVector3f rotation = OpenVector3f.ZERO;
    private OpenVector3f scale = OpenVector3f.ONE;
    private OpenVector3f afterTranslate = OpenVector3f.ZERO;
    private OpenVector3f pivot = OpenVector3f.ZERO;

    public static OpenTransform3f create(OpenVector3f translate, OpenVector3f rotation, OpenVector3f scale) {
        return OpenTransform3f.create(translate, rotation, scale, OpenVector3f.ZERO, OpenVector3f.ZERO);
    }

    public static OpenTransform3f create(OpenVector3f translate, OpenVector3f rotation, OpenVector3f scale, OpenVector3f pivot, OpenVector3f afterTranslate) {
        if (translate.equals(OpenVector3f.ZERO) && rotation.equals(OpenVector3f.ZERO) && scale.equals(OpenVector3f.ONE) && pivot.equals(OpenVector3f.ZERO) && afterTranslate.equals(OpenVector3f.ZERO)) {
            return IDENTITY;
        }
        OpenTransform3f transform = new OpenTransform3f();
        transform.translate = OpenTransform3f.optimize(translate, OpenVector3f.ZERO);
        transform.rotation = OpenTransform3f.optimize(rotation, OpenVector3f.ZERO);
        transform.scale = OpenTransform3f.optimize(scale, OpenVector3f.ONE);
        transform.afterTranslate = OpenTransform3f.optimize(afterTranslate, OpenVector3f.ZERO);
        transform.pivot = OpenTransform3f.optimize(pivot, OpenVector3f.ZERO);
        return transform;
    }

    public static OpenTransform3f createRotationTransform(OpenVector3f rotation) {
        if (!rotation.equals(OpenVector3f.ZERO)) {
            OpenTransform3f transform = new OpenTransform3f();
            transform.rotation = rotation;
            return transform;
        }
        return IDENTITY;
    }

    public static OpenTransform3f createScaleTransform(float sx, float sy, float sz) {
        if (sx != 1.0f || sy != 1.0f || sz != 1.0f) {
            OpenTransform3f transform = new OpenTransform3f();
            transform.scale = new OpenVector3f(sx, sy, sz);
            return transform;
        }
        return IDENTITY;
    }

    public static OpenTransform3f createScaleTransform(OpenVector3f scale) {
        if (!scale.equals(OpenVector3f.ONE)) {
            OpenTransform3f transform = new OpenTransform3f();
            transform.scale = scale;
            return transform;
        }
        return IDENTITY;
    }

    public static OpenTransform3f createTranslateTransform(float tx, float ty, float tz) {
        if (tx != 0.0f || ty != 0.0f || tz != 0.0f) {
            OpenTransform3f transform = new OpenTransform3f();
            transform.translate = new OpenVector3f(tx, ty, tz);
            return transform;
        }
        return IDENTITY;
    }

    public static OpenTransform3f createTranslateTransform(OpenVector3f offset) {
        if (!offset.equals(OpenVector3f.ZERO)) {
            OpenTransform3f transform = new OpenTransform3f();
            transform.translate = offset;
            return transform;
        }
        return IDENTITY;
    }

    @Override
    public void apply(IPoseStack poseStack) {
        if (this == IDENTITY) {
            return;
        }
        if (this.translate != OpenVector3f.ZERO) {
            poseStack.translate(this.translate.x(), this.translate.y(), this.translate.z());
        }
        if (this.rotation != OpenVector3f.ZERO) {
            if (this.pivot != OpenVector3f.ZERO) {
                poseStack.translate(this.pivot.x(), this.pivot.y(), this.pivot.z());
            }
            poseStack.rotate(OpenQuaternionf.fromEulerAnglesZYX(this.rotation, true));
            if (this.pivot != OpenVector3f.ZERO) {
                poseStack.translate(-this.pivot.x(), -this.pivot.y(), -this.pivot.z());
            }
        }
        if (this.scale != OpenVector3f.ONE) {
            poseStack.scale(this.scale.x(), this.scale.y(), this.scale.z());
        }
        if (this.afterTranslate != OpenVector3f.ZERO) {
            poseStack.translate(this.afterTranslate.x(), this.afterTranslate.y(), this.afterTranslate.z());
        }
    }

    public void readFromStream(IInputStream stream) throws IOException {
        int flags = stream.readInt();
        this.translate = OpenTransform3f.optimize(stream.readVector3f(), OpenVector3f.ZERO);
        this.rotation = OpenTransform3f.optimize(stream.readVector3f(), OpenVector3f.ZERO);
        this.scale = OpenTransform3f.optimize(stream.readVector3f(), OpenVector3f.ONE);
        this.afterTranslate = OpenTransform3f.optimize(stream.readVector3f(), OpenVector3f.ZERO);
        this.pivot = OpenTransform3f.optimize(stream.readVector3f(), OpenVector3f.ZERO);
    }

    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writeInt(0);
        stream.writeVector3f(this.translate);
        stream.writeVector3f(this.rotation);
        stream.writeVector3f(this.scale);
        stream.writeVector3f(this.afterTranslate);
        stream.writeVector3f(this.pivot);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenTransform3f)) {
            return false;
        }
        OpenTransform3f that = (OpenTransform3f)o;
        return this.translate.equals(that.translate) && this.rotation.equals(that.rotation) && this.scale.equals(that.scale) && this.pivot.equals(that.pivot) && this.afterTranslate.equals(that.afterTranslate);
    }

    public int hashCode() {
        return Objects.hash(this.translate, this.rotation, this.scale, this.pivot, this.afterTranslate);
    }

    public String toString() {
        return Objects.toString(this, "translate", this.translate, "rotation", this.rotation, "scale", this.scale, "pivot", this.pivot, "offset", this.afterTranslate);
    }

    @Override
    public boolean isIdentity() {
        return this == IDENTITY;
    }

    @Override
    public OpenVector3f translate() {
        return this.translate;
    }

    @Override
    public OpenVector3f rotation() {
        return this.rotation;
    }

    @Override
    public OpenVector3f scale() {
        return this.scale;
    }

    @Override
    public OpenVector3f afterTranslate() {
        return this.afterTranslate;
    }

    @Override
    public OpenVector3f pivot() {
        return this.pivot;
    }

    public OpenTransform3f copy() {
        if (this == IDENTITY) {
            return IDENTITY;
        }
        OpenTransform3f transform = new OpenTransform3f();
        transform.translate = this.translate;
        transform.rotation = this.translate;
        transform.scale = this.translate;
        transform.pivot = this.translate;
        transform.afterTranslate = this.translate;
        return transform;
    }

    private static <T> T optimize(T value, T targetValue) {
        if (value.equals(targetValue)) {
            return targetValue;
        }
        return value;
    }
}

