/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.math;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.core.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenRay;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;

public class OpenAxisAlignedBoundingBox {
    public static final OpenAxisAlignedBoundingBox ZERO = new OpenAxisAlignedBoundingBox(OpenVector3f.ZERO, OpenVector3f.ZERO);
    private float minX;
    private float minY;
    private float minZ;
    private float maxX;
    private float maxY;
    private float maxZ;

    public OpenAxisAlignedBoundingBox(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public OpenAxisAlignedBoundingBox(OpenVector3f min, OpenVector3f max) {
        this(min.x(), min.y(), min.z(), max.x(), max.y(), max.z());
    }

    public OpenAxisAlignedBoundingBox(IRectangle3f rect) {
        this(rect.minX(), rect.minY(), rect.minZ(), rect.maxX(), rect.maxY(), rect.maxZ());
    }

    public void transform(IMatrix4f matrix) {
        ArrayList<OpenVector3f> vertices = new ArrayList<OpenVector3f>();
        vertices.add(new OpenVector3f(this.minX, this.minY, this.minZ));
        vertices.add(new OpenVector3f(this.maxX, this.minY, this.minZ));
        vertices.add(new OpenVector3f(this.minX, this.maxY, this.minZ));
        vertices.add(new OpenVector3f(this.maxX, this.maxY, this.minZ));
        vertices.add(new OpenVector3f(this.minX, this.minY, this.maxZ));
        vertices.add(new OpenVector3f(this.maxX, this.minY, this.maxZ));
        vertices.add(new OpenVector3f(this.minX, this.maxY, this.maxZ));
        vertices.add(new OpenVector3f(this.maxX, this.maxY, this.maxZ));
        this.minX = Float.MAX_VALUE;
        this.minY = Float.MAX_VALUE;
        this.minZ = Float.MAX_VALUE;
        this.maxX = Float.MIN_VALUE;
        this.maxY = Float.MIN_VALUE;
        this.maxZ = Float.MIN_VALUE;
        for (OpenVector3f vertex : vertices) {
            vertex.transform(matrix);
            this.minX = Math.min(this.minX, vertex.x());
            this.minY = Math.min(this.minY, vertex.y());
            this.minZ = Math.min(this.minZ, vertex.z());
            this.maxX = Math.max(this.maxX, vertex.x());
            this.maxY = Math.max(this.maxY, vertex.y());
            this.maxZ = Math.max(this.maxZ, vertex.z());
        }
    }

    public boolean intersects(OpenAxisAlignedBoundingBox box) {
        return this.intersects(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    public boolean intersects(float d, float e, float f, float g, float h, float i) {
        return this.minX < g && this.maxX > d && this.minY < h && this.maxY > e && this.minZ < i && this.maxZ > f;
    }

    public boolean intersects(OpenRay ray) {
        return ray.intersects(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public OpenAxisAlignedBoundingBox transforming(IMatrix4f matrix) {
        OpenAxisAlignedBoundingBox ret = this.copy();
        ret.transform(matrix);
        return ret;
    }

    public float minX() {
        return this.minX;
    }

    public float minY() {
        return this.minY;
    }

    public float minZ() {
        return this.minZ;
    }

    public float maxX() {
        return this.maxX;
    }

    public float maxY() {
        return this.maxY;
    }

    public float maxZ() {
        return this.maxZ;
    }

    public OpenAxisAlignedBoundingBox copy() {
        return new OpenAxisAlignedBoundingBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

