/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.slot;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.minecraft.world.item.ItemStack;

public class ItemMatcher {
    private final Pattern matchPattern;
    private final Pattern nonMatchPattern;
    private final Collection<String> whitelist;
    private final Collection<String> blacklist;
    private final Predicate<ItemStack> requirements;

    public ItemMatcher(String matchRegex, String nonMatchRegex, Collection<String> whitelist, Collection<String> blacklist, Predicate<ItemStack> requirements) {
        this.matchPattern = this.tryCompile(matchRegex);
        this.nonMatchPattern = this.tryCompile(nonMatchRegex);
        this.whitelist = whitelist;
        this.blacklist = blacklist;
        this.requirements = requirements;
    }

    public boolean test(IResourceLocation registryName, ItemStack itemStack) {
        String id = registryName.toString();
        if (this.whitelist.contains(id)) {
            return true;
        }
        if (!ModConfig.Common.enableMatchingByItemId) {
            return false;
        }
        if (ModConfig.Common.disableMatchingItems.contains(id) || this.blacklist.contains(id)) {
            return false;
        }
        if (this.matchPattern != null && this.matchPattern.matcher(registryName.path()).find()) {
            if (this.nonMatchPattern != null && this.nonMatchPattern.matcher(registryName.path()).find()) {
                return false;
            }
            return this.requirements == null || this.requirements.test(itemStack);
        }
        return false;
    }

    private Pattern tryCompile(String regex) {
        if (!regex.isEmpty()) {
            return Pattern.compile(regex, 2);
        }
        return null;
    }
}

