/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerProvider;
import moe.plushie.armourers_workshop.core.data.DataContainerKey;

public class DataContainer
implements IAssociatedContainerProvider {
    private final HashMap<Object, Object> values = new HashMap();

    public static <T, V> void set(T object, V value) {
        DataContainer.set(object, Builtin.DEFAULT, value);
    }

    public static <T, V> V get(T object) {
        return (V)DataContainer.get(object, Builtin.DEFAULT);
    }

    public static <T, V> V getOrDefault(T object, V defaultValue) {
        return (V)DataContainer.getOrDefault(object, Builtin.DEFAULT, defaultValue);
    }

    public static <T, V> V of(T object, Function<T, V> supplier) {
        return (V)DataContainer.of(object, Builtin.DEFAULT, supplier);
    }

    public static <T, V> void set(T object, IAssociatedContainerKey<V> key, V value) {
        IAssociatedContainerProvider provider = (IAssociatedContainerProvider)object;
        provider.setAssociatedObject(key, value);
    }

    public static <T, V> V get(T object, IAssociatedContainerKey<V> key) {
        IAssociatedContainerProvider provider = (IAssociatedContainerProvider)object;
        return provider.getAssociatedObject(key);
    }

    public static <T, V> V getOrDefault(T object, IAssociatedContainerKey<V> key, V defaultValue) {
        V value = DataContainer.get(object, key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static <T, V> V of(T object, IAssociatedContainerKey<V> key, Function<T, V> supplier) {
        IAssociatedContainerProvider provider = (IAssociatedContainerProvider)object;
        V value = provider.getAssociatedObject(key);
        if (value != null) {
            return value;
        }
        V newValue = supplier.apply(object);
        provider.setAssociatedObject(key, newValue);
        return newValue;
    }

    @Override
    public <T> T getAssociatedObject(IAssociatedContainerKey<T> key) {
        Object value = this.getValue(key);
        if (value != null) {
            return key.type().cast(value);
        }
        return key.defaultValue();
    }

    @Override
    public <T> void setAssociatedObject(IAssociatedContainerKey<T> key, T value) {
        this.setValue(key, value);
    }

    protected void setValue(IAssociatedContainerKey<?> key, Object value) {
        this.values.put(key, value);
    }

    protected Object getValue(IAssociatedContainerKey<?> key) {
        return this.values.get(key);
    }

    public static class Builtin
    extends DataContainer {
        private static final DataContainerKey<Object> DEFAULT = new DataContainerKey<Object>("builtin", Object.class, null);
        private Object builtin;

        @Override
        protected Object getValue(IAssociatedContainerKey<?> key) {
            if (key == DEFAULT) {
                return this.builtin;
            }
            return super.getValue(key);
        }

        @Override
        protected void setValue(IAssociatedContainerKey<?> key, Object value) {
            if (key == DEFAULT) {
                this.builtin = value;
            } else {
                super.setValue(key, value);
            }
        }
    }
}

