/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.core.IResourceManager;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.renderer.item.ItemProperties.ABI;
import moe.plushie.armourers_workshop.core.client.model.SkinItemModel;
import moe.plushie.armourers_workshop.core.client.model.SkinItemOverride;
import moe.plushie.armourers_workshop.core.client.model.SkinItemProperty;
import moe.plushie.armourers_workshop.core.client.model.SkinItemTransform;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IODataObject;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.JsonSerializer;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SkinItemModelManager {
    private static final SkinItemModelManager INSTANCE = new SkinItemModelManager();
    private SkinItemModel missingModel;
    private final Map<SkinType, SkinItemModel> typedItemModels = new ConcurrentHashMap<SkinType, SkinItemModel>();
    private final Map<IResourceLocation, SkinItemModel> namedItemModels = new ConcurrentHashMap<IResourceLocation, SkinItemModel>();
    private final Map<IResourceLocation, SkinItemProperty> namedItemProperties = Collections.immutableMap(it -> {
        it.put((Object)ModConstants.key("is_skin"), (Object)SkinItemModelManager.handOnly("armourers_workshop:is_skin"));
        it.put((Object)ModConstants.key("is_crossbow"), (Object)SkinItemModelManager.vanilla("armourers_workshop:is_crossbow"));
        it.put((Object)ModConstants.key("is_blocking"), (Object)SkinItemModelManager.vanilla("minecraft:blocking"));
        it.put((Object)ModConstants.key("is_throwing"), (Object)SkinItemModelManager.vanilla("minecraft:throwing"));
    });

    public static SkinItemModelManager getInstance() {
        return INSTANCE;
    }

    public static void init() {
        new SimpleLoader(INSTANCE).load();
    }

    public SkinItemModel getModel(SkinType skinType) {
        return this.typedItemModels.computeIfAbsent(skinType, it -> {
            OpenResourceLocation id = ModConstants.key("skin/" + skinType.registryName().path());
            return this.namedItemModels.getOrDefault(id, this.missingModel);
        });
    }

    @Nullable
    public SkinItemProperty getProperty(IResourceLocation id) {
        return this.namedItemProperties.get(id);
    }

    private static SkinItemProperty vanilla(String id) {
        final OpenResourceLocation registryName = OpenResourceLocation.parse(id);
        final ResourceLocation location = registryName.toLocation();
        return new SkinItemProperty(){

            @Override
            public float apply(ItemStack itemStack, @Nullable Entity entity, @Nullable Level level, int flags, OpenItemDisplayContext displayContext) {
                ItemPropertyFunction func = ABI.getProperty(ItemProperties.class, itemStack, location);
                if (func != null) {
                    return func.m_141951_(itemStack, (ClientLevel)level, (LivingEntity)entity, flags);
                }
                return Float.NEGATIVE_INFINITY;
            }

            public String toString() {
                return registryName.toString();
            }
        };
    }

    private static SkinItemProperty handOnly(String id) {
        final SkinItemProperty property = SkinItemModelManager.vanilla(id);
        return new SkinItemProperty(){

            @Override
            public float apply(ItemStack itemStack, @Nullable Entity entity, @Nullable Level level, int flags, OpenItemDisplayContext displayContext) {
                if (displayContext.isFirstPerson() || displayContext.isThirdPerson()) {
                    return property.apply(itemStack, entity, level, flags, displayContext);
                }
                return 0.0f;
            }

            public String toString() {
                return property.toString();
            }
        };
    }

    private static class SimpleLoader {
        private final SkinItemModelManager modelManager;
        private final IResourceManager resourceManager;
        private final Map<IResourceLocation, SimpleBuilder> builders = new LinkedHashMap<IResourceLocation, SimpleBuilder>();
        private final Map<IResourceLocation, SkinItemModel> models = new LinkedHashMap<IResourceLocation, SkinItemModel>();

        public SimpleLoader(SkinItemModelManager modelManager) {
            this.modelManager = modelManager;
            this.resourceManager = EnvironmentManager.getResourceManager();
        }

        public void load() {
            this.resourceManager.readResources(ModConstants.key("models/skin"), s -> s.endsWith(".json"), (location, resource) -> {
                IODataObject object = JsonSerializer.readFromResource(resource);
                if (object == null) {
                    return;
                }
                String path = FileUtils.getRegistryName(location.path(), "models/");
                IResourceLocation location1 = location.withPath(FileUtils.removeExtension(path));
                SimpleBuilder builder = this.builders.computeIfAbsent(location1, SimpleBuilder::new);
                object.get("parent").ifPresent(it -> {
                    OpenResourceLocation key = OpenResourceLocation.parse(it.stringValue());
                    builder.parent = this.builders.computeIfAbsent(key, SimpleBuilder::new);
                });
                object.get("display").entrySet().forEach(entry -> {
                    String name = (String)entry.getKey();
                    IODataObject value = (IODataObject)entry.getValue();
                    OpenVector3f translation = this.parseVector3f(value.get("translation"), OpenVector3f.ZERO);
                    OpenVector3f rotation = this.parseVector3f(value.get("rotation"), OpenVector3f.ZERO);
                    OpenVector3f scale = this.parseVector3f(value.get("scale"), OpenVector3f.ONE);
                    builder.addTransform(name, new SimpleTransform(translation, rotation, scale));
                });
                object.get("overrides").allValues().forEach(it -> {
                    String model = it.get("model").stringValue();
                    ArrayList<Pair<IResourceLocation, Number>> predicate = new ArrayList<Pair<IResourceLocation, Number>>();
                    it.get("predicate").entrySet().forEach(entry -> {
                        OpenResourceLocation key = ModConstants.key((String)entry.getKey());
                        Number value = ((IODataObject)entry.getValue()).numberValue();
                        predicate.add(Pair.of((Object)key, (Object)value));
                    });
                    builder.addOverride(model, predicate);
                });
            });
            IdentityHashMap<SkinItemOverride, IResourceLocation> references = new IdentityHashMap<SkinItemOverride, IResourceLocation>();
            this.builders.forEach((name, builder) -> {
                SkinItemModel itemModel = builder.build(references);
                this.models.put((IResourceLocation)name, itemModel);
            });
            references.forEach((override, reference) -> override.setModel(this.models.get(reference)));
            SkinItemModel missingModel = this.models.get(ModConstants.key("skin/unknown"));
            if (missingModel == null) {
                throw new RuntimeException("Can't find missing model, some think wrong!");
            }
            this.modelManager.namedItemModels.putAll(this.models);
            this.modelManager.missingModel = missingModel;
        }

        private OpenVector3f parseVector3f(IODataObject value, OpenVector3f defaultValue) {
            if (value.isNull()) {
                return defaultValue;
            }
            if (value.size() != 3) {
                throw new RuntimeException("Expected 3 double values, found: " + String.valueOf(value.allValues()));
            }
            float x = value.at(0).floatValue();
            float y = value.at(1).floatValue();
            float z = value.at(2).floatValue();
            return new OpenVector3f(x, y, z);
        }
    }

    private static class SimpleTransform
    extends SkinItemTransform {
        public SimpleTransform(OpenVector3f translation, OpenVector3f rotation, OpenVector3f scale) {
            super(SimpleTransform.scale(translation, new OpenVector3f(-1.0f, -1.0f, 1.0f), OpenVector3f.ZERO), SimpleTransform.scale(rotation, new OpenVector3f(-1.0f, -1.0f, 1.0f), OpenVector3f.ZERO), SimpleTransform.optimize(scale, OpenVector3f.ONE));
        }

        @Override
        public void apply(boolean applyLeftHandTransform, IPoseStack poseStack) {
            super.apply(applyLeftHandTransform, poseStack);
            if (applyLeftHandTransform) {
                poseStack.scale(-1.0f, 1.0f, 1.0f);
            }
        }

        private static float scale(float a, float b) {
            if (a != 0.0f) {
                return a * b;
            }
            return a;
        }

        private static OpenVector3f scale(OpenVector3f value, OpenVector3f scale, OpenVector3f defaultValue) {
            float x = SimpleTransform.scale(value.x(), scale.x());
            float y = SimpleTransform.scale(value.y(), scale.y());
            float z = SimpleTransform.scale(value.z(), scale.z());
            return SimpleTransform.optimize(new OpenVector3f(x, y, z), defaultValue);
        }
    }

    private static class SimpleBuilder {
        private SimpleBuilder parent;
        private final IResourceLocation name;
        private final Map<IResourceLocation, List<Pair<IResourceLocation, Number>>> overrides = new LinkedHashMap<IResourceLocation, List<Pair<IResourceLocation, Number>>>();
        private final Map<OpenItemDisplayContext, SkinItemTransform> transforms = new LinkedHashMap<OpenItemDisplayContext, SkinItemTransform>();

        public SimpleBuilder(IResourceLocation name) {
            this.name = name;
        }

        public void addOverride(String name, List<Pair<IResourceLocation, Number>> predicate) {
            this.overrides.put(OpenResourceLocation.parse(name), predicate);
        }

        public void addTransform(String name, SkinItemTransform transform) {
            this.transforms.put(OpenItemDisplayContext.byName(name), transform);
        }

        public SkinItemModel build(Map<SkinItemOverride, IResourceLocation> references) {
            ArrayList<SkinItemOverride> itemOverrides = new ArrayList<SkinItemOverride>();
            for (Map.Entry<IResourceLocation, List<Pair<IResourceLocation, Number>>> override : this.overrides.entrySet()) {
                List<Pair<IResourceLocation, Number>> it = override.getValue();
                SkinItemProperty[] properties = new SkinItemProperty[it.size()];
                float[] values = new float[it.size()];
                for (int i = 0; i < properties.length; ++i) {
                    properties[i] = SkinItemModelManager.getInstance().getProperty((IResourceLocation)it.get(i).getKey());
                    values[i] = ((Number)it.get(i).getValue()).floatValue();
                }
                SkinItemOverride itemOverride = new SkinItemOverride(properties, values);
                itemOverrides.add(itemOverride);
                references.put(itemOverride, override.getKey());
            }
            EnumMap<OpenItemDisplayContext, SkinItemTransform> itemTransforms = new EnumMap<OpenItemDisplayContext, SkinItemTransform>(OpenItemDisplayContext.class);
            for (OpenItemDisplayContext displayContext : OpenItemDisplayContext.values()) {
                itemTransforms.put(displayContext, this.resolveTransformValue(displayContext, SkinItemTransform.NO_TRANSFORM));
            }
            return new SkinItemModel(this.name, itemOverrides, itemTransforms);
        }

        private SkinItemTransform resolveTransformValue(OpenItemDisplayContext transformType, SkinItemTransform defaultValue) {
            SkinItemTransform transform = this.transforms.get((Object)transformType);
            if (transform != null) {
                return transform;
            }
            if (this.parent != null) {
                return this.parent.resolveTransformValue(transformType, defaultValue);
            }
            return defaultValue;
        }
    }
}

