/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIComboBox;
import com.apple.library.uikit.UIComboItem;
import com.apple.library.uikit.UITextView;
import java.util.Collection;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.utils.Collections;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReportDialog
extends ConfirmDialog {
    protected String content;
    protected UIComboBox comboBox = this.buildComboBox(0, 0, 100, 20);
    protected UITextView textView = this.buildTextField(0, 0, 100, 80);

    public ReportDialog() {
        this.setFrame(new CGRect(0.0f, 0.0f, 240.0f, 200.0f));
        this.setup();
    }

    private void setup() {
        float width = this.bounds().width;
        this.textView.setFrame(new CGRect(10.0f, 45.0f, width - 20.0f, 80.0f));
        this.addSubview(this.textView);
        this.comboBox.setFrame(new CGRect(10.0f, 25.0f, width - 20.0f, 16.0f));
        this.addSubview(this.comboBox);
        this.messageLabel.setFrame(new CGRect(10.0f, 130.0f, width - 20.0f, 40.0f));
        this.messageLabel.setTextVerticalAlignment(NSTextAlignment.Vertical.TOP);
    }

    public String text() {
        if (this.textView != null) {
            return this.textView.text();
        }
        return null;
    }

    public void setText(String value) {
        this.content = value;
        if (this.textView != null) {
            this.textView.setText(value);
        }
    }

    public NSString placeholder() {
        return this.textView.placeholder();
    }

    public void setPlaceholder(NSString placeholderText) {
        this.textView.setPlaceholder(placeholderText);
    }

    public int reportType() {
        return this.comboBox.selectedIndex();
    }

    public void setReportTypes(Collection<NSString> types) {
        this.comboBox.reloadData(Collections.compactMap(types, UIComboItem::new));
    }

    private UIComboBox buildComboBox(int x, int y, int width, int height) {
        int selectedIndex = 0;
        UIComboBox comboBox = new UIComboBox(new CGRect(x, y, width, height));
        comboBox.setSelectedIndex(selectedIndex);
        this.addSubview(comboBox);
        return comboBox;
    }

    private UITextView buildTextField(int x, int y, int width, int height) {
        UITextView textBox = new UITextView(new CGRect(x, y, width, height));
        textBox.setMaxLength(255);
        if (this.content != null) {
            textBox.setText(this.content);
            this.content = null;
        }
        return textBox;
    }
}

